/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor.set;

import java.math.BigInteger;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.redis.internal.data.RedisData;
import org.apache.geode.redis.internal.data.RedisDataType;
import org.apache.geode.redis.internal.data.RedisDataTypeMismatchException;
import org.apache.geode.redis.internal.data.RedisKey;
import org.apache.geode.redis.internal.executor.RedisResponse;
import org.apache.geode.redis.internal.executor.key.AbstractScanExecutor;
import org.apache.geode.redis.internal.executor.set.RedisSetCommandsFunctionInvoker;
import org.apache.geode.redis.internal.netty.Coder;
import org.apache.geode.redis.internal.netty.Command;
import org.apache.geode.redis.internal.netty.ExecutionHandlerContext;

public class SScanExecutor
extends AbstractScanExecutor {
    @Override
    public RedisResponse executeCommand(Command command, ExecutionHandlerContext context) {
        Pattern matchPattern;
        BigInteger cursor;
        List<byte[]> commandElems = command.getProcessedCommand();
        String cursorString = Coder.bytesToString(commandElems.get(2));
        String globPattern = null;
        int count = 10;
        try {
            cursor = new BigInteger(cursorString).abs();
        }
        catch (NumberFormatException e) {
            return RedisResponse.error("invalid cursor");
        }
        if (cursor.compareTo(this.UNSIGNED_LONG_CAPACITY) > 0) {
            return RedisResponse.error("invalid cursor");
        }
        RedisKey key = command.getKey();
        if (!this.getDataRegion(context).containsKey((Object)key)) {
            context.getRedisStats().incKeyspaceMisses();
            return RedisResponse.emptyScan();
        }
        if (((RedisData)this.getDataRegion(context).get((Object)key)).getType() != RedisDataType.REDIS_SET) {
            throw new RedisDataTypeMismatchException("Operation against a key holding the wrong kind of value");
        }
        command.getCommandType().checkDeferredParameters(command, context);
        if (!cursor.equals(context.getSscanCursor())) {
            cursor = new BigInteger("0");
        }
        for (int i = 3; i < commandElems.size(); i += 2) {
            byte[] commandElemBytes = commandElems.get(i);
            String keyword = Coder.bytesToString(commandElemBytes);
            if (keyword.equalsIgnoreCase("MATCH")) {
                commandElemBytes = commandElems.get(i + 1);
                globPattern = Coder.bytesToString(commandElemBytes);
                continue;
            }
            if (keyword.equalsIgnoreCase("COUNT")) {
                commandElemBytes = commandElems.get(i + 1);
                try {
                    count = Coder.bytesToInt(commandElemBytes);
                }
                catch (NumberFormatException e) {
                    return RedisResponse.error("value is not an integer or out of range");
                }
                if (count >= 1) continue;
                return RedisResponse.error("syntax error");
            }
            return RedisResponse.error("syntax error");
        }
        try {
            matchPattern = this.convertGlobToRegex(globPattern);
        }
        catch (PatternSyntaxException e) {
            LogService.getLogger().warn("Could not compile the pattern: '{}' due to the following exception: '{}'. SSCAN will return an empty list.", globPattern, (Object)e.getMessage());
            return RedisResponse.emptyScan();
        }
        RedisSetCommandsFunctionInvoker redisSetCommands = new RedisSetCommandsFunctionInvoker(context.getRegionProvider().getDataRegion());
        Pair<BigInteger, List<Object>> scanResult = redisSetCommands.sscan(key, matchPattern, count, cursor);
        context.setSscanCursor((BigInteger)scanResult.getLeft());
        return RedisResponse.scan((BigInteger)scanResult.getLeft(), (List)scanResult.getRight());
    }
}

