/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor.key;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.redis.internal.data.RedisKey;
import org.apache.geode.redis.internal.executor.RedisResponse;
import org.apache.geode.redis.internal.executor.key.AbstractScanExecutor;
import org.apache.geode.redis.internal.netty.Coder;
import org.apache.geode.redis.internal.netty.Command;
import org.apache.geode.redis.internal.netty.ExecutionHandlerContext;

public class ScanExecutor
extends AbstractScanExecutor {
    @Override
    public RedisResponse executeCommand(Command command, ExecutionHandlerContext context) {
        Pattern matchPattern;
        BigInteger cursor;
        List<byte[]> commandElems = command.getProcessedCommand();
        String cursorString = command.getStringKey();
        String globPattern = null;
        int count = 10;
        try {
            cursor = new BigInteger(cursorString).abs();
        }
        catch (NumberFormatException e) {
            return RedisResponse.error("invalid cursor");
        }
        if (cursor.compareTo(this.UNSIGNED_LONG_CAPACITY) > 0) {
            return RedisResponse.error("invalid cursor");
        }
        if (!cursor.equals(context.getScanCursor())) {
            cursor = new BigInteger("0");
        }
        for (int i = 2; i < commandElems.size(); i += 2) {
            byte[] commandElemBytes = commandElems.get(i);
            String keyword = Coder.bytesToString(commandElemBytes);
            if (keyword.equalsIgnoreCase("MATCH")) {
                commandElemBytes = commandElems.get(i + 1);
                globPattern = Coder.bytesToString(commandElemBytes);
                continue;
            }
            if (keyword.equalsIgnoreCase("COUNT")) {
                commandElemBytes = commandElems.get(i + 1);
                try {
                    count = Coder.bytesToInt(commandElemBytes);
                }
                catch (NumberFormatException e) {
                    return RedisResponse.error("value is not an integer or out of range");
                }
                if (count >= 1) continue;
                return RedisResponse.error("syntax error");
            }
            return RedisResponse.error("syntax error");
        }
        try {
            matchPattern = this.convertGlobToRegex(globPattern);
        }
        catch (PatternSyntaxException e) {
            LogService.getLogger().warn("Could not compile the pattern: '{}' due to the following exception: '{}'. SCAN will return an empty list.", globPattern, (Object)e.getMessage());
            return RedisResponse.emptyScan();
        }
        Pair<BigInteger, List<Object>> scanResult = this.scan(this.getDataRegion(context).keySet(), matchPattern, count, cursor);
        context.setScanCursor((BigInteger)scanResult.getLeft());
        return RedisResponse.scan((BigInteger)scanResult.getLeft(), (List)scanResult.getRight());
    }

    private Pair<BigInteger, List<Object>> scan(Collection<RedisKey> list, Pattern matchPattern, int count, BigInteger cursor) {
        ArrayList<RedisKey> returnList = new ArrayList<RedisKey>();
        int size = list.size();
        BigInteger beforeCursor = new BigInteger("0");
        int numElements = 0;
        int i = -1;
        for (RedisKey key : list) {
            ++i;
            if (beforeCursor.compareTo(cursor) < 0) {
                beforeCursor = beforeCursor.add(new BigInteger("1"));
                continue;
            }
            if (matchPattern != null) {
                if (matchPattern.matcher(key.toString()).matches()) {
                    returnList.add(key);
                    ++numElements;
                }
            } else {
                returnList.add(key);
                ++numElements;
            }
            if (numElements != count) continue;
            break;
        }
        ImmutablePair scanResult = i >= size - 1 ? new ImmutablePair((Object)new BigInteger("0"), returnList) : new ImmutablePair((Object)new BigInteger(String.valueOf(i + 1)), returnList);
        return scanResult;
    }
}

