/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.functions;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.internal.cache.execute.InternalFunction;
import org.apache.geode.internal.tcp.ConnectionTable;
import org.apache.geode.logging.internal.executors.LoggingExecutors;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class ShutDownFunction
implements InternalFunction<Void> {
    private static final Logger logger = LogService.getLogger();
    public static final String ID = ShutDownFunction.class.getName();
    private static final long serialVersionUID = 1L;

    public void execute(FunctionContext<Void> context) {
        try {
            InternalDistributedSystem system = InternalDistributedSystem.getConnectedInstance();
            if (system == null) {
                return;
            }
            String memberName = system.getDistributedMember().getId();
            logger.info("Received GFSH shutdown. Shutting down member " + memberName);
            this.disconnectInNonDaemonThread(system);
            context.getResultSender().lastResult((Object)("SUCCESS: succeeded in shutting down " + memberName));
        }
        catch (Exception ex) {
            logger.warn("Error during shutdown", (Throwable)ex);
            context.getResultSender().lastResult((Object)("FAILURE: failed in shutting down " + ex.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disconnectInNonDaemonThread(InternalDistributedSystem ids) throws InterruptedException, ExecutionException {
        ExecutorService exec = LoggingExecutors.newSingleThreadExecutor((String)"Shutdown Disconnector", (boolean)false);
        Future<?> future = exec.submit(() -> {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ConnectionTable.threadWantsSharedResources();
            if (ids.isConnected()) {
                ids.disconnect();
            }
        });
        try {
            future.get();
        }
        finally {
            exec.shutdown();
        }
    }

    public String getId() {
        return ID;
    }

    public boolean hasResult() {
        return true;
    }

    public boolean optimizeForWrite() {
        return false;
    }

    public boolean isHA() {
        return false;
    }
}

