/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.examples;

import java.util.Properties;
import org.apache.geode.security.AuthenticationFailedException;
import org.apache.geode.security.ResourcePermission;
import org.apache.geode.security.SecurityManager;

public class SimpleSecurityManager
implements SecurityManager {
    public static final String VALID_TOKEN = "FOO_BAR";

    @Override
    public void init(Properties securityProps) {
    }

    @Override
    public Object authenticate(Properties credentials) throws AuthenticationFailedException {
        String token = credentials.getProperty("security-token");
        if (token != null) {
            if (VALID_TOKEN.equalsIgnoreCase(token) || token.length() > 20) {
                return "Bearer " + token;
            }
            throw new AuthenticationFailedException("Invalid token");
        }
        String username = credentials.getProperty("security-username");
        String password = credentials.getProperty("security-password");
        if (username != null && username.equals(password)) {
            return username;
        }
        throw new AuthenticationFailedException("invalid username/password");
    }

    @Override
    public boolean authorize(Object principal, ResourcePermission permission) {
        String[] principals;
        if (principal.toString().startsWith("Bearer ")) {
            return true;
        }
        for (String role : principals = principal.toString().toLowerCase().split(",")) {
            String permissionString = permission.toString().replace(":", "").toLowerCase();
            if (!permissionString.startsWith(role)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void close() {
    }
}

