/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.geode.CancelException;
import org.apache.geode.GemFireConfigException;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.annotations.internal.MakeNotStatic;
import org.apache.geode.cache.client.internal.locator.ClientConnectionRequest;
import org.apache.geode.cache.client.internal.locator.ClientReplacementRequest;
import org.apache.geode.cache.client.internal.locator.GetAllServersRequest;
import org.apache.geode.cache.client.internal.locator.LocatorListRequest;
import org.apache.geode.cache.client.internal.locator.LocatorStatusRequest;
import org.apache.geode.cache.client.internal.locator.QueueConnectionRequest;
import org.apache.geode.cache.client.internal.locator.wan.LocatorMembershipListener;
import org.apache.geode.cache.internal.HttpService;
import org.apache.geode.distributed.DistributedSystem;
import org.apache.geode.distributed.Locator;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.DistributionConfig;
import org.apache.geode.distributed.internal.DistributionConfigImpl;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.InfoRequestHandler;
import org.apache.geode.distributed.internal.InternalConfigurationPersistenceService;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.LocatorStats;
import org.apache.geode.distributed.internal.PoolStatHelper;
import org.apache.geode.distributed.internal.ProductUseLog;
import org.apache.geode.distributed.internal.ProtocolCheckerImpl;
import org.apache.geode.distributed.internal.ResourceEvent;
import org.apache.geode.distributed.internal.RestartHandler;
import org.apache.geode.distributed.internal.ServerLocator;
import org.apache.geode.distributed.internal.WanLocatorDiscoverer;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.distributed.internal.membership.adapter.ServiceConfig;
import org.apache.geode.distributed.internal.membership.api.MembershipConfig;
import org.apache.geode.distributed.internal.membership.api.MembershipConfigurationException;
import org.apache.geode.distributed.internal.membership.api.MembershipLocator;
import org.apache.geode.distributed.internal.membership.api.MembershipLocatorBuilder;
import org.apache.geode.distributed.internal.membership.api.MembershipLocatorStatistics;
import org.apache.geode.distributed.internal.membership.api.QuorumChecker;
import org.apache.geode.distributed.internal.tcpserver.InfoRequest;
import org.apache.geode.distributed.internal.tcpserver.ProtocolChecker;
import org.apache.geode.distributed.internal.tcpserver.TcpHandler;
import org.apache.geode.distributed.internal.tcpserver.TcpServer;
import org.apache.geode.distributed.internal.tcpserver.TcpSocketCreator;
import org.apache.geode.internal.CopyOnWriteHashSet;
import org.apache.geode.internal.GemFireVersion;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.admin.remote.DistributionLocatorId;
import org.apache.geode.internal.admin.remote.RemoteTransportConfig;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.InternalCacheBuilder;
import org.apache.geode.internal.cache.client.protocol.ClientProtocolServiceLoader;
import org.apache.geode.internal.cache.wan.WANServiceProvider;
import org.apache.geode.internal.config.JAXBService;
import org.apache.geode.internal.inet.LocalHostUtil;
import org.apache.geode.internal.logging.CoreLoggingExecutors;
import org.apache.geode.internal.logging.InternalLogWriter;
import org.apache.geode.internal.logging.LogWriterFactory;
import org.apache.geode.internal.net.SocketCreator;
import org.apache.geode.internal.net.SocketCreatorFactory;
import org.apache.geode.internal.security.SecurableCommunicationChannel;
import org.apache.geode.internal.serialization.DSFIDSerializer;
import org.apache.geode.internal.statistics.StatisticsConfig;
import org.apache.geode.logging.internal.InternalSessionContext;
import org.apache.geode.logging.internal.LoggingSession;
import org.apache.geode.logging.internal.NullLoggingSession;
import org.apache.geode.logging.internal.executors.LoggingThread;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.logging.internal.spi.LogConfig;
import org.apache.geode.logging.internal.spi.LogConfigListener;
import org.apache.geode.logging.internal.spi.LogConfigSupplier;
import org.apache.geode.management.ManagementService;
import org.apache.geode.management.api.ClusterManagementService;
import org.apache.geode.management.internal.AgentUtil;
import org.apache.geode.management.internal.JmxManagerLocator;
import org.apache.geode.management.internal.JmxManagerLocatorRequest;
import org.apache.geode.management.internal.api.LocatorClusterManagementService;
import org.apache.geode.management.internal.configuration.domain.SharedConfigurationStatus;
import org.apache.geode.management.internal.configuration.handlers.ClusterManagementServiceInfoRequestHandler;
import org.apache.geode.management.internal.configuration.handlers.SharedConfigurationStatusRequestHandler;
import org.apache.geode.management.internal.configuration.messages.ClusterManagementServiceInfoRequest;
import org.apache.geode.management.internal.configuration.messages.SharedConfigurationStatusRequest;
import org.apache.geode.management.internal.configuration.messages.SharedConfigurationStatusResponse;
import org.apache.geode.metrics.internal.InternalDistributedSystemMetricsService;
import org.apache.geode.security.AuthTokenEnabledComponents;
import org.apache.logging.log4j.Logger;

public class InternalLocator
extends Locator
implements InternalDistributedSystem.ConnectListener,
LogConfigSupplier {
    public static final int MAX_POOL_SIZE = Integer.getInteger("gemfire.TcpServer.MAX_POOL_SIZE", 100);
    public static final int POOL_IDLE_TIMEOUT = 60000;
    private static final Logger logger = LogService.getLogger();
    public static final String FORCE_LOCATOR_DM_TYPE = "Locator.forceLocatorDMType";
    public static final String INHIBIT_DM_BANNER = "Locator.inhibitDMBanner";
    public static final String LOCATORS_PREFERRED_AS_COORDINATORS = "gemfire.disable-floating-coordinator";
    @MakeNotStatic
    private static InternalLocator locator;
    private static final Object locatorLock;
    private final Set<RestartHandler> restartHandlers = new CopyOnWriteHashSet<RestartHandler>();
    private final LocatorMembershipListener locatorListener;
    private final AtomicBoolean shutdownHandled = new AtomicBoolean(false);
    private final LoggingSession loggingSession;
    private final LocatorStats locatorStats;
    private final Path workingDirectory;
    private final MembershipLocator<InternalDistributedMember> membershipLocator;
    private volatile boolean stoppedForReconnect;
    private volatile boolean reconnected;
    private volatile boolean forcedDisconnect;
    private volatile boolean isSharedConfigurationStarted;
    private volatile Thread restartThread;
    private InternalDistributedSystem internalDistributedSystem;
    private InternalCache internalCache;
    private ProductUseLog productUseLog;
    private boolean peerLocator;
    private ServerLocator serverLocator;
    private Properties env;
    private DistributionConfigImpl distributionConfig;
    private WanLocatorDiscoverer locatorDiscoverer;
    private InternalConfigurationPersistenceService configurationPersistenceService;
    private ClusterManagementService clusterManagementService;
    private final Object servicesRestartLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InternalLocator getLocator() {
        Object object = locatorLock;
        synchronized (object) {
            return locator;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasLocator() {
        Object object = locatorLock;
        synchronized (object) {
            return locator != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeLocator(InternalLocator locator) {
        if (locator == null) {
            return;
        }
        Object object = locatorLock;
        synchronized (object) {
            if (locator.loggingSession.getState() != InternalSessionContext.State.STOPPED) {
                locator.loggingSession.stopSession();
                locator.loggingSession.shutdown();
            }
            if (locator.equals(InternalLocator.locator)) {
                InternalLocator.locator = null;
            }
        }
    }

    @Deprecated
    public static InternalLocator createLocator(int port, LoggingSession loggingSession, File logFile, InternalLogWriter logWriter, InternalLogWriter securityLogWriter, InetAddress bindAddress, String hostnameForClients, Properties distributedSystemProperties, boolean startDistributedSystem) {
        return InternalLocator.createLocator(port, loggingSession, logFile, logWriter, securityLogWriter, bindAddress, hostnameForClients, distributedSystemProperties, Paths.get(System.getProperty("user.dir"), new String[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InternalLocator createLocator(int port, LoggingSession loggingSession, File logFile, InternalLogWriter logWriter, InternalLogWriter securityLogWriter, InetAddress bindAddress, String hostnameForClients, Properties distributedSystemProperties, Path workingDirectory) {
        Object object = locatorLock;
        synchronized (object) {
            InternalLocator locator;
            if (InternalLocator.hasLocator()) {
                throw new IllegalStateException("A locator can not be created because one already exists in this JVM.");
            }
            InternalLocator.locator = locator = new InternalLocator(port, loggingSession, logFile, logWriter, securityLogWriter, bindAddress, hostnameForClients, distributedSystemProperties, null, workingDirectory);
            return locator;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setLocator(InternalLocator locator) {
        Object object = locatorLock;
        synchronized (object) {
            if (InternalLocator.locator != null && InternalLocator.locator != locator) {
                throw new IllegalStateException("A locator can not be created because one already exists in this JVM.");
            }
            InternalLocator.locator = locator;
        }
    }

    public static InternalLocator startLocator(int port, File logFile, InternalLogWriter logWriter, InternalLogWriter securityLogWriter, InetAddress bindAddress, boolean startDistributedSystem, Properties distributedSystemProperties, String hostnameForClients) throws IOException {
        return InternalLocator.startLocator(port, logFile, logWriter, securityLogWriter, bindAddress, startDistributedSystem, distributedSystemProperties, hostnameForClients, Paths.get(System.getProperty("user.dir"), new String[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InternalLocator startLocator(int port, File logFile, InternalLogWriter logWriter, InternalLogWriter securityLogWriter, InetAddress bindAddress, boolean startDistributedSystem, Properties distributedSystemProperties, String hostnameForClients, Path workingDirectory) throws IOException {
        InternalLocator internalLocator;
        System.setProperty(FORCE_LOCATOR_DM_TYPE, "true");
        InternalLocator newLocator = null;
        boolean startedLocator = false;
        try {
            InternalDistributedSystem system;
            block12: {
                LoggingSession loggingSession = startDistributedSystem ? NullLoggingSession.create() : LoggingSession.create();
                newLocator = InternalLocator.createLocator(port, loggingSession, logFile, logWriter, securityLogWriter, bindAddress, hostnameForClients, distributedSystemProperties, workingDirectory);
                loggingSession.createSession(newLocator);
                loggingSession.startSession();
                try {
                    newLocator.startPeerLocation();
                    if (!startDistributedSystem) break block12;
                    try {
                        newLocator.startDistributedSystem();
                    }
                    catch (RuntimeException e) {
                        newLocator.stop();
                        throw e;
                    }
                    system = newLocator.internalDistributedSystem;
                    if (system != null) {
                        system.getDistributionManager().addHostedLocators(system.getDistributedMember(), InternalLocator.getLocatorStrings(), newLocator.isSharedConfigurationEnabled());
                    }
                }
                catch (IllegalStateException e) {
                    newLocator.stop();
                    throw e;
                }
            }
            system = InternalDistributedSystem.getConnectedInstance();
            if (system != null) {
                try {
                    newLocator.startServerLocation(system);
                }
                catch (RuntimeException e) {
                    newLocator.stop();
                    throw e;
                }
            }
            newLocator.endStartLocator(null);
            startedLocator = true;
            internalLocator = newLocator;
        }
        catch (Throwable throwable) {
            System.clearProperty(FORCE_LOCATOR_DM_TYPE);
            if (!startedLocator) {
                InternalLocator.removeLocator(newLocator);
            }
            throw throwable;
        }
        System.clearProperty(FORCE_LOCATOR_DM_TYPE);
        if (!startedLocator) {
            InternalLocator.removeLocator(newLocator);
        }
        return internalLocator;
    }

    public static boolean isDedicatedLocator() {
        InternalLocator internalLocator = InternalLocator.getLocator();
        if (internalLocator == null) {
            return false;
        }
        InternalDistributedSystem system = internalLocator.internalDistributedSystem;
        if (system == null) {
            return false;
        }
        DistributionManager distributionManager = system.getDistributionManager();
        if (distributionManager.isLoner()) {
            return false;
        }
        ClusterDistributionManager clusterDistributionManager = (ClusterDistributionManager)system.getDistributionManager();
        return clusterDistributionManager.getDMType() == 11;
    }

    @VisibleForTesting
    InternalLocator(int port, LoggingSession loggingSession, File logFile, InternalLogWriter logWriter, InternalLogWriter securityLogWriter, InetAddress bindAddress, String hostnameForClients, Properties distributedSystemProperties, DistributionConfigImpl distributionConfig, Path workingDirectory) {
        boolean hasLogFileButConfigDoesNot;
        this.logFile = logFile;
        this.bindAddress = bindAddress;
        this.hostnameForClients = hostnameForClients;
        this.workingDirectory = workingDirectory;
        this.env = new Properties();
        if (bindAddress != null && !bindAddress.isAnyLocalAddress()) {
            this.env.setProperty("bind-address", bindAddress.getHostAddress());
        }
        if (distributedSystemProperties != null) {
            this.env.putAll((Map<?, ?>)distributedSystemProperties);
        }
        this.env.setProperty("cache-xml-file", "");
        if (distributionConfig == null) {
            distributionConfig = new DistributionConfigImpl(this.env);
            this.env.clear();
            this.env.putAll((Map<?, ?>)distributionConfig.getProps());
        }
        this.distributionConfig = distributionConfig;
        boolean bl = hasLogFileButConfigDoesNot = this.logFile != null && this.distributionConfig.getLogFile().toString().equals(DistributionConfig.DEFAULT_LOG_FILE.toString());
        if (logWriter == null && hasLogFileButConfigDoesNot) {
            this.distributionConfig.unsafeSetLogFile(this.logFile);
        }
        if (loggingSession == null) {
            throw new Error("LoggingSession must not be null");
        }
        this.loggingSession = loggingSession;
        if (logWriter == null) {
            LogWriterFactory.createLogWriterLogger(this.distributionConfig, false);
            if (logger.isDebugEnabled()) {
                logger.debug("LogWriter for locator is created.");
            }
        }
        if (securityLogWriter == null) {
            securityLogWriter = LogWriterFactory.createLogWriterLogger(this.distributionConfig, true);
            securityLogWriter.fine("SecurityLogWriter for locator is created.");
        }
        SocketCreatorFactory.setDistributionConfig(this.distributionConfig);
        this.locatorListener = WANServiceProvider.createLocatorMembershipListener();
        if (this.locatorListener != null) {
            this.locatorListener.setConfig(this.getConfig());
        }
        this.locatorStats = new LocatorStats();
        InternalLocatorTcpHandler handler = new InternalLocatorTcpHandler();
        try {
            ServiceConfig config = new ServiceConfig(new RemoteTransportConfig(distributionConfig, 11), distributionConfig);
            Supplier<ExecutorService> executor = () -> CoreLoggingExecutors.newThreadPoolWithSynchronousFeed("locator request thread ", MAX_POOL_SIZE, new DelayedPoolStatHelper(), 60000, new ThreadPoolExecutor.CallerRunsPolicy());
            SocketCreator socketCreator = SocketCreatorFactory.getSocketCreatorForComponent(SecurableCommunicationChannel.LOCATOR);
            this.membershipLocator = MembershipLocatorBuilder.newLocatorBuilder((TcpSocketCreator)socketCreator, (DSFIDSerializer)InternalDataSerializer.getDSFIDSerializer(), (Path)workingDirectory, executor).setConfig((MembershipConfig)config).setPort(port).setBindAddress(bindAddress).setProtocolChecker((ProtocolChecker)new ProtocolCheckerImpl(this, new ClientProtocolServiceLoader())).setFallbackHandler((TcpHandler)handler).setLocatorsAreCoordinators(this.shouldLocatorsBeCoordinators()).setLocatorStats((MembershipLocatorStatistics)this.locatorStats).create();
        }
        catch (UnknownHostException | MembershipConfigurationException e) {
            throw new GemFireConfigException(e.getMessage());
        }
        this.membershipLocator.addHandler(InfoRequest.class, (TcpHandler)new InfoRequestHandler());
        this.restartHandlers.add((ds, cache, sharedConfig) -> {
            InternalDistributedSystem ids = (InternalDistributedSystem)ds;
            this.membershipLocator.setMembership(ids.getDM().getDistribution().getMembership());
        });
    }

    public boolean isSharedConfigurationEnabled() {
        return this.distributionConfig.getEnableClusterConfiguration();
    }

    private boolean loadFromSharedConfigDir() {
        return this.distributionConfig.getLoadClusterConfigFromDir();
    }

    public boolean isSharedConfigurationRunning() {
        return this.configurationPersistenceService != null && this.configurationPersistenceService.getStatus() == SharedConfigurationStatus.RUNNING;
    }

    public LocatorMembershipListener getLocatorMembershipListener() {
        return this.locatorListener;
    }

    @Deprecated
    public LocatorMembershipListener getlocatorMembershipListener() {
        return this.getLocatorMembershipListener();
    }

    private void startTcpServer() throws IOException {
        logger.info("Starting {}", (Object)this);
        this.membershipLocator.start();
    }

    public InternalConfigurationPersistenceService getConfigurationPersistenceService() {
        return this.configurationPersistenceService;
    }

    public DistributionConfigImpl getConfig() {
        return this.distributionConfig;
    }

    public InternalCache getCache() {
        if (this.internalCache == null) {
            return GemFireCacheImpl.getInstance();
        }
        return this.internalCache;
    }

    int startPeerLocation() throws IOException {
        if (this.isPeerLocator()) {
            throw new IllegalStateException(String.format("Peer location is already running for %s", this));
        }
        logger.info("Starting peer location for {}", (Object)this);
        this.peerLocator = true;
        int boundPort = this.membershipLocator.start();
        File productUseFile = this.workingDirectory.resolve("locator" + boundPort + "views.log").toFile();
        this.productUseLog = new ProductUseLog(productUseFile);
        return boundPort;
    }

    private boolean shouldLocatorsBeCoordinators() {
        boolean locatorsAreCoordinators;
        boolean networkPartitionDetectionEnabled = this.distributionConfig.getEnableNetworkPartitionDetection();
        if (networkPartitionDetectionEnabled) {
            locatorsAreCoordinators = true;
        } else {
            String prop = this.distributionConfig.getSecurityPeerAuthInit();
            boolean bl = locatorsAreCoordinators = prop != null && !prop.isEmpty();
            if (!locatorsAreCoordinators) {
                locatorsAreCoordinators = Boolean.getBoolean(LOCATORS_PREFERRED_AS_COORDINATORS);
            }
        }
        return locatorsAreCoordinators;
    }

    public MembershipLocator<InternalDistributedMember> getMembershipLocator() {
        return this.membershipLocator;
    }

    @Deprecated
    public static InternalLocator startLocator(int locatorPort, File logFile, InternalLogWriter logWriter, InternalLogWriter securityLogWriter, InetAddress bindAddress, Properties distributedSystemProperties, boolean peerLocator, boolean serverLocator, String hostnameForClients, boolean b1) throws IOException {
        return InternalLocator.startLocator(locatorPort, logFile, logWriter, securityLogWriter, bindAddress, true, distributedSystemProperties, hostnameForClients);
    }

    private void startDistributedSystem() throws IOException {
        InternalDistributedSystem existing = InternalDistributedSystem.getConnectedInstance();
        if (existing != null) {
            logger.info("Using existing distributed system: {}", (Object)existing);
            this.startCache(existing);
        } else {
            StringBuilder sb = new StringBuilder(100);
            if (this.bindAddress != null) {
                sb.append(this.bindAddress.getHostAddress());
            } else {
                sb.append(LocalHostUtil.getLocalHost().getCanonicalHostName());
            }
            sb.append('[').append(this.getPort()).append(']');
            String thisLocator = sb.toString();
            if (this.peerLocator) {
                boolean setLocatorsProp = false;
                String locatorsConfigValue = this.distributionConfig.getLocators();
                if (StringUtils.isNotBlank((CharSequence)locatorsConfigValue)) {
                    if (!locatorsConfigValue.contains(thisLocator)) {
                        locatorsConfigValue = locatorsConfigValue + ',' + thisLocator;
                        setLocatorsProp = true;
                    }
                } else {
                    locatorsConfigValue = thisLocator;
                    setLocatorsProp = true;
                }
                if (setLocatorsProp) {
                    Properties updateEnv = new Properties();
                    updateEnv.setProperty("locators", locatorsConfigValue);
                    this.distributionConfig.setApiProps(updateEnv);
                    String locatorsPropertyName = "gemfire.locators";
                    if (System.getProperty(locatorsPropertyName) != null) {
                        System.setProperty(locatorsPropertyName, locatorsConfigValue);
                    }
                }
            }
            Properties distributedSystemProperties = new Properties();
            distributedSystemProperties.put("ds-config", this.distributionConfig);
            logger.info("Starting distributed system");
            this.internalDistributedSystem = InternalDistributedSystem.connectInternal(distributedSystemProperties, null, new InternalDistributedSystemMetricsService.Builder(), this.membershipLocator);
            if (this.peerLocator) {
                this.membershipLocator.setMembership(this.internalDistributedSystem.getDM().getDistribution().getMembership());
            }
            this.internalDistributedSystem.addDisconnectListener(sys -> this.stop(false, false, false));
            this.startCache(this.internalDistributedSystem);
            logger.info("Locator started on {}", (Object)thisLocator);
        }
    }

    private void startCache(DistributedSystem system) throws IOException {
        InternalCache internalCache = GemFireCacheImpl.getInstance();
        if (internalCache == null) {
            logger.info("Creating cache for locator.");
            this.internalCache = new InternalCacheBuilder(system.getProperties()).create((InternalDistributedSystem)system);
            internalCache = this.internalCache;
        } else {
            logger.info("Using existing cache for locator.");
            ((InternalDistributedSystem)system).handleResourceEvent(ResourceEvent.LOCATOR_START, this);
        }
        this.startJmxManagerLocationService(internalCache);
        this.startClusterManagementService();
    }

    @VisibleForTesting
    void startClusterManagementService() throws IOException {
        this.startConfigurationPersistenceService();
        AgentUtil agentUtil = new AgentUtil(GemFireVersion.getGemFireVersion());
        this.startClusterManagementService(this.internalCache, agentUtil);
    }

    @VisibleForTesting
    void startClusterManagementService(InternalCache myCache, AgentUtil agentUtil) {
        if (myCache == null) {
            return;
        }
        this.clusterManagementService = new LocatorClusterManagementService(myCache, this.configurationPersistenceService);
        URI gemfireManagementWar = agentUtil.findWarLocation("geode-web-management");
        if (gemfireManagementWar == null) {
            logger.info("Unable to find GemFire V2 Management REST API WAR file; the Management REST Interface for Geode will not be accessible.");
            return;
        }
        HashMap<String, Object> serviceAttributes = new HashMap<String, Object>();
        serviceAttributes.put("org.apache.geode.securityService", myCache.getSecurityService());
        serviceAttributes.put("org.apache.geode.cluster.management.service", this.clusterManagementService);
        String[] authEnabledComponents = this.distributionConfig.getSecurityAuthTokenEnabledComponents();
        boolean managementAuthTokenEnabled = Arrays.stream(authEnabledComponents).anyMatch(AuthTokenEnabledComponents::hasManagement);
        serviceAttributes.put("org.apache.geode.auth.token.enabled", managementAuthTokenEnabled);
        if (this.distributionConfig.getEnableManagementRestService()) {
            myCache.getOptionalService(HttpService.class).ifPresent(x -> {
                try {
                    ManagementService managementService = ManagementService.getManagementService(myCache);
                    if (!managementService.isManager()) {
                        managementService.startManager();
                    }
                    logger.info("Geode Property {}=true Geode Management Rest Service is enabled.", (Object)"enable-management-rest-service");
                    x.addWebApplication("/management", Paths.get(gemfireManagementWar), serviceAttributes);
                }
                catch (Throwable e) {
                    logger.warn("Unable to start management service: {}", (Object)e.getMessage());
                }
            });
        } else {
            logger.info("Geode Property {}=false Geode Management Rest Service is disabled.", (Object)"enable-management-rest-service");
        }
    }

    void endStartLocator(InternalDistributedSystem distributedSystem) {
        this.env = null;
        if (distributedSystem == null) {
            distributedSystem = InternalDistributedSystem.getConnectedInstance();
        }
        if (distributedSystem != null) {
            this.onConnect(distributedSystem);
        } else {
            InternalDistributedSystem.addConnectListener(this);
        }
        this.locatorDiscoverer = WANServiceProvider.createLocatorDiscoverer();
        if (this.locatorDiscoverer != null) {
            this.locatorDiscoverer.discover(this.getPort(), this.distributionConfig, this.locatorListener, this.hostnameForClients);
        }
    }

    void startServerLocation(InternalDistributedSystem distributedSystem) throws IOException {
        if (this.isServerLocator()) {
            throw new IllegalStateException(String.format("Server location is already running for %s", this));
        }
        logger.info("Starting server location for {}", (Object)this);
        if (distributedSystem == null && (distributedSystem = InternalDistributedSystem.getConnectedInstance()) == null) {
            throw new IllegalStateException("Since server location is enabled the distributed system must be connected.");
        }
        ServerLocator serverLocator = new ServerLocator(this.getPort(), this.bindAddress, this.hostnameForClients, this.logFile, this.productUseLog, this.getConfig().getName(), distributedSystem, this.locatorStats);
        this.restartHandlers.add(serverLocator);
        this.membershipLocator.addHandler(LocatorListRequest.class, (TcpHandler)serverLocator);
        this.membershipLocator.addHandler(ClientConnectionRequest.class, (TcpHandler)serverLocator);
        this.membershipLocator.addHandler(QueueConnectionRequest.class, (TcpHandler)serverLocator);
        this.membershipLocator.addHandler(ClientReplacementRequest.class, (TcpHandler)serverLocator);
        this.membershipLocator.addHandler(GetAllServersRequest.class, (TcpHandler)serverLocator);
        this.membershipLocator.addHandler(LocatorStatusRequest.class, (TcpHandler)serverLocator);
        this.serverLocator = serverLocator;
        if (!this.membershipLocator.isAlive()) {
            this.startTcpServer();
        }
        this.productUseLog.monitorUse(distributedSystem);
    }

    @Override
    public void stop() {
        this.stop(false, false, true);
    }

    public void stop(boolean forcedDisconnect, boolean stopForReconnect, boolean waitForDisconnect) {
        boolean isDebugEnabled = logger.isDebugEnabled();
        this.stoppedForReconnect = stopForReconnect;
        this.forcedDisconnect = forcedDisconnect;
        if (this.membershipLocator.isShuttingDown() && waitForDisconnect) {
            long endOfWait = System.currentTimeMillis() + 60000L;
            if (isDebugEnabled && this.membershipLocator.isAlive()) {
                logger.debug("sleeping to wait for the locator server to shut down...");
            }
            while (this.membershipLocator.isAlive() && System.currentTimeMillis() < endOfWait) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException ignored) {
                    Thread.currentThread().interrupt();
                    return;
                }
            }
            if (isDebugEnabled) {
                if (this.membershipLocator.isAlive()) {
                    logger.debug("60 seconds have elapsed waiting for the locator server to shut down - terminating wait and returning");
                } else {
                    logger.debug("the locator server has shut down");
                }
            }
        }
        if (this.locatorDiscoverer != null) {
            this.locatorDiscoverer.stop();
            this.locatorDiscoverer = null;
        }
        if (!this.membershipLocator.isShuttingDown()) {
            this.membershipLocator.stop();
        }
        InternalLocator.removeLocator(this);
        this.handleShutdown();
        logger.info("{} is stopped", (Object)this);
        if (stopForReconnect) {
            this.launchRestartThread();
        }
    }

    public boolean isStopped() {
        return !this.membershipLocator.isAlive();
    }

    void handleShutdown() {
        if (!this.shutdownHandled.compareAndSet(false, true)) {
            return;
        }
        if (this.productUseLog != null) {
            this.productUseLog.close();
        }
        if (this.internalCache != null && !this.stoppedForReconnect && !this.forcedDisconnect) {
            logger.info("Closing locator's cache");
            try {
                this.internalCache.close("Normal disconnect", null, false, false, true);
            }
            catch (RuntimeException ex) {
                logger.info("Could not close locator's cache because: {}", (Object)ex.getMessage(), (Object)ex);
            }
        }
        if (this.locatorStats != null) {
            this.locatorStats.close();
        }
        if (this.locatorListener != null) {
            this.locatorListener.clearLocatorInfo();
        }
        this.isSharedConfigurationStarted = false;
        if (this.internalDistributedSystem != null && !this.forcedDisconnect && this.internalDistributedSystem.isConnected()) {
            logger.info("Disconnecting distributed system for {}", (Object)this);
            this.internalDistributedSystem.disconnect();
        }
    }

    public void waitToStop() throws InterruptedException {
        boolean restarted;
        do {
            InternalDistributedSystem system = this.internalDistributedSystem;
            restarted = false;
            this.membershipLocator.waitToShutdown();
            if (!this.stoppedForReconnect) continue;
            logger.info("waiting for distributed system to disconnect...");
            while (((DistributedSystem)system).isConnected()) {
                Thread.sleep(5000L);
            }
            logger.info("waiting for distributed system to reconnect...");
            try {
                restarted = ((DistributedSystem)system).waitUntilReconnected(-1L, TimeUnit.SECONDS);
            }
            catch (CancelException cancelException) {
                // empty catch block
            }
            if (restarted) {
                logger.info("system restarted");
            } else {
                logger.info("system was not restarted");
            }
            Thread restartThread = this.restartThread;
            if (restartThread == null) continue;
            logger.info("waiting for services to restart...");
            restartThread.join();
            this.restartThread = null;
            logger.info("done waiting for services to restart");
        } while (restarted);
    }

    private void launchRestartThread() {
        String threadName = "Location services restart thread";
        this.restartThread = new LoggingThread(threadName, () -> {
            Object object = this.servicesRestartLock;
            synchronized (object) {
                this.stoppedForReconnect = true;
                boolean restarted = false;
                try {
                    restarted = this.attemptReconnect();
                    logger.info("attemptReconnect returned {}", (Object)restarted);
                }
                catch (InterruptedException e) {
                    logger.info("attempt to restart location services was interrupted", (Throwable)e);
                }
                catch (IOException e) {
                    logger.info("attempt to restart location services terminated", (Throwable)e);
                }
                finally {
                    this.shutdownHandled.set(false);
                    if (!restarted) {
                        this.stoppedForReconnect = false;
                    }
                    this.reconnected = restarted;
                    this.restartThread = null;
                }
            }
        });
        this.restartThread.start();
    }

    public boolean isReconnected() {
        return this.reconnected;
    }

    private boolean attemptReconnect() throws InterruptedException, IOException {
        boolean restarted = false;
        if (this.stoppedForReconnect) {
            logger.info("attempting to restart locator");
            boolean tcpServerStarted = false;
            InternalDistributedSystem system = this.internalDistributedSystem;
            long waitTime = system.getConfig().getMaxWaitTimeForReconnect() / 2;
            QuorumChecker quorumChecker = null;
            while (system.getReconnectedSystem() == null && !system.isReconnectCancelled()) {
                boolean start;
                if (quorumChecker == null && (quorumChecker = system.getQuorumChecker()) != null) {
                    logger.info("The distributed system returned this quorum checker: {}", (Object)quorumChecker);
                }
                if (quorumChecker != null && !tcpServerStarted && (start = quorumChecker.checkForQuorum(3L * (long)system.getConfig().getMemberTimeout()))) {
                    logger.info("starting peer location");
                    if (this.locatorListener != null) {
                        this.locatorListener.clearLocatorInfo();
                    }
                    this.stoppedForReconnect = false;
                    this.internalDistributedSystem = null;
                    this.internalCache = null;
                    this.restartWithoutSystem();
                    tcpServerStarted = true;
                    InternalLocator.setLocator(this);
                }
                try {
                    system.waitUntilReconnected(waitTime, TimeUnit.MILLISECONDS);
                }
                catch (CancelException e) {}
            }
            InternalDistributedSystem newSystem = (InternalDistributedSystem)system.getReconnectedSystem();
            if (newSystem != null) {
                boolean noprevlocator = false;
                if (!InternalLocator.hasLocator()) {
                    InternalLocator.setLocator(this);
                    noprevlocator = true;
                }
                if (!tcpServerStarted) {
                    if (this.locatorListener != null) {
                        this.locatorListener.clearLocatorInfo();
                    }
                    this.stoppedForReconnect = false;
                }
                try {
                    this.restartWithSystem(newSystem, GemFireCacheImpl.getInstance());
                }
                catch (CancelException e) {
                    this.stoppedForReconnect = true;
                    if (noprevlocator) {
                        InternalLocator.removeLocator(this);
                    }
                    return false;
                }
                restarted = true;
            }
        }
        logger.info("restart thread exiting.  Service was {}restarted", (Object)(restarted ? "" : "not "));
        return restarted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restartWithoutSystem() throws IOException {
        Object object = locatorLock;
        synchronized (object) {
            if (locator != this && InternalLocator.hasLocator()) {
                throw new IllegalStateException("A locator can not be created because one already exists in this JVM.");
            }
            this.internalDistributedSystem = null;
            this.internalCache = null;
            logger.info("Locator restart: initializing TcpServer peer location services");
            this.membershipLocator.restarting();
            if (this.productUseLog.isClosed()) {
                this.productUseLog.reopen();
            }
            if (!this.membershipLocator.isAlive()) {
                logger.info("Locator restart: starting TcpServer");
                this.startTcpServer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restartWithSystem(InternalDistributedSystem newSystem, InternalCache newCache) throws IOException {
        Object object = locatorLock;
        synchronized (object) {
            if (locator != this && InternalLocator.hasLocator()) {
                throw new IllegalStateException("A locator can not be created because one already exists in this JVM.");
            }
        }
        this.internalDistributedSystem = newSystem;
        this.internalCache = newCache;
        logger.info("Locator restart: initializing TcpServer");
        try {
            this.restartHandlers.forEach(handler -> handler.restarting(newSystem, newCache, this.configurationPersistenceService));
            this.membershipLocator.restarting();
        }
        catch (CancelException e) {
            this.internalDistributedSystem = null;
            this.internalCache = null;
            logger.info("Locator restart: attempt to restart location services failed", (Throwable)e);
            throw e;
        }
        if (this.productUseLog.isClosed()) {
            this.productUseLog.reopen();
        }
        this.productUseLog.monitorUse(newSystem);
        if (this.isSharedConfigurationEnabled()) {
            this.configurationPersistenceService = new InternalConfigurationPersistenceService(newCache, this.workingDirectory, JAXBService.create(new Class[0]));
            this.startClusterManagementService();
        }
        if (!this.membershipLocator.isAlive()) {
            logger.info("Locator restart: starting TcpServer");
            this.startTcpServer();
        }
        logger.info("Locator restart: initializing JMX manager");
        this.startJmxManagerLocationService(newCache);
        this.endStartLocator(this.internalDistributedSystem);
        logger.info("Locator restart completed");
        this.restartHandlers.forEach(handler -> handler.restartCompleted(newSystem));
    }

    public ClusterManagementService getClusterManagementService() {
        return this.clusterManagementService;
    }

    @Override
    public DistributedSystem getDistributedSystem() {
        if (this.internalDistributedSystem == null) {
            return InternalDistributedSystem.getAnyInstance();
        }
        return this.internalDistributedSystem;
    }

    @Override
    public boolean isPeerLocator() {
        return this.peerLocator;
    }

    @Override
    public boolean isServerLocator() {
        return this.serverLocator != null;
    }

    public ServerLocator getServerLocatorAdvisee() {
        return this.serverLocator;
    }

    @Override
    public Integer getPort() {
        if (this.membershipLocator != null && this.membershipLocator.isAlive()) {
            return this.membershipLocator.getPort();
        }
        return null;
    }

    @Override
    public LogConfig getLogConfig() {
        return this.distributionConfig;
    }

    @Override
    public StatisticsConfig getStatisticsConfig() {
        return this.distributionConfig;
    }

    @Override
    public void addLogConfigListener(LogConfigListener logConfigListener) {
    }

    @Override
    public void removeLogConfigListener(LogConfigListener logConfigListener) {
    }

    public SharedConfigurationStatusResponse getSharedConfigurationStatus() {
        SharedConfigurationStatusResponse response;
        ExecutorService waitingPoolExecutor = this.internalCache.getDistributionManager().getExecutors().getWaitingThreadPool();
        Future<SharedConfigurationStatusResponse> statusFuture = waitingPoolExecutor.submit(new FetchSharedConfigStatus());
        try {
            response = statusFuture.get(5L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            logger.info("Exception occurred while fetching the status {}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
            response = new SharedConfigurationStatusResponse();
            response.setStatus(SharedConfigurationStatus.UNDETERMINED);
        }
        return response;
    }

    @Override
    public void onConnect(InternalDistributedSystem sys) {
        try {
            this.locatorStats.hookupStats(sys, LocalHostUtil.getCanonicalLocalHostName() + '-' + this.membershipLocator.getSocketAddress());
        }
        catch (UnknownHostException e) {
            logger.warn((Object)e);
        }
    }

    public static Collection<String> getLocatorStrings() {
        Collection<String> locatorStrings;
        try {
            Collection<DistributionLocatorId> locatorIds = DistributionLocatorId.asDistributionLocatorIds(InternalLocator.getLocators());
            locatorStrings = DistributionLocatorId.asStrings(locatorIds);
        }
        catch (UnknownHostException ignored) {
            locatorStrings = null;
        }
        if (locatorStrings == null || locatorStrings.isEmpty()) {
            return null;
        }
        return locatorStrings;
    }

    private void startConfigurationPersistenceService() throws IOException {
        this.installRequestHandlers();
        if (!this.distributionConfig.getEnableClusterConfiguration()) {
            logger.info("Cluster configuration service is disabled");
            return;
        }
        if (!this.distributionConfig.getJmxManager()) {
            throw new IllegalStateException("Cannot start cluster configuration without jmx-manager=true");
        }
        if (this.isSharedConfigurationStarted) {
            logger.info("Cluster configuration service is already started.");
            return;
        }
        if (!InternalLocator.isDedicatedLocator()) {
            logger.info("Cluster configuration service not enabled as it is only supported in dedicated locators");
            return;
        }
        if (this.configurationPersistenceService == null) {
            this.configurationPersistenceService = new InternalConfigurationPersistenceService(this.internalCache, this.workingDirectory, JAXBService.create(new Class[0]));
        }
        this.configurationPersistenceService.initSharedConfiguration(this.loadFromSharedConfigDir());
        logger.info("Cluster configuration service start up completed successfully and is now running ....");
        this.isSharedConfigurationStarted = true;
    }

    public void startJmxManagerLocationService(InternalCache internalCache) {
        if (internalCache.getJmxManagerAdvisor() != null && !this.membershipLocator.isHandled(JmxManagerLocatorRequest.class)) {
            JmxManagerLocator jmxHandler = new JmxManagerLocator(internalCache);
            this.restartHandlers.add(jmxHandler);
            this.membershipLocator.addHandler(JmxManagerLocatorRequest.class, (TcpHandler)jmxHandler);
        }
    }

    private void installRequestHandlers() {
        if (!this.membershipLocator.isHandled(SharedConfigurationStatusRequest.class)) {
            this.membershipLocator.addHandler(SharedConfigurationStatusRequest.class, (TcpHandler)new SharedConfigurationStatusRequestHandler());
            logger.info("SharedConfigStatusRequestHandler installed");
        }
        if (!this.membershipLocator.isHandled(ClusterManagementServiceInfoRequest.class)) {
            this.membershipLocator.addHandler(ClusterManagementServiceInfoRequest.class, (TcpHandler)new ClusterManagementServiceInfoRequestHandler());
            logger.info("ClusterManagementServiceInfoRequestHandler installed");
        }
    }

    public boolean hasHandlerForClass(Class messageClass) {
        return this.membershipLocator.isHandled(messageClass);
    }

    static {
        locatorLock = new Object();
    }

    private class InternalLocatorTcpHandler
    implements TcpHandler {
        private InternalLocatorTcpHandler() {
        }

        public Object processRequest(Object request) throws IOException {
            return InternalLocator.this.locatorListener == null ? null : InternalLocator.this.locatorListener.handleRequest(request);
        }

        public void endRequest(Object request, long startTime) {
        }

        public void endResponse(Object request, long startTime) {
        }

        public void shutDown() {
            InternalLocator.this.handleShutdown();
        }

        public void init(TcpServer tcpServer) {
            if (InternalLocator.this.locatorListener != null) {
                InternalLocator.this.locatorListener.setPort(tcpServer.getPort());
            }
        }
    }

    protected class DelayedPoolStatHelper
    implements PoolStatHelper {
        protected DelayedPoolStatHelper() {
        }

        @Override
        public void startJob() {
            InternalLocator.this.locatorStats.incRequestInProgress(1);
        }

        @Override
        public void endJob() {
            InternalLocator.this.locatorStats.incRequestInProgress(-1);
        }
    }

    class FetchSharedConfigStatus
    implements Callable<SharedConfigurationStatusResponse> {
        FetchSharedConfigStatus() {
        }

        @Override
        public SharedConfigurationStatusResponse call() throws InterruptedException {
            SharedConfigurationStatusResponse response;
            InternalLocator locator = InternalLocator.this;
            if (InternalLocator.this.configurationPersistenceService != null) {
                response = InternalLocator.this.configurationPersistenceService.createStatusResponse();
            } else {
                response = new SharedConfigurationStatusResponse();
                response.setStatus(SharedConfigurationStatus.UNDETERMINED);
            }
            return response;
        }
    }
}

