/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor.hash;

import java.util.List;
import org.apache.geode.redis.internal.ByteArrayWrapper;
import org.apache.geode.redis.internal.Coder;
import org.apache.geode.redis.internal.Command;
import org.apache.geode.redis.internal.ExecutionHandlerContext;
import org.apache.geode.redis.internal.Extendable;
import org.apache.geode.redis.internal.executor.hash.GeodeRedisHashSynchronized;
import org.apache.geode.redis.internal.executor.hash.HashExecutor;

public class HSetExecutor
extends HashExecutor
implements Extendable {
    @Override
    public void executeCommand(Command command, ExecutionHandlerContext context) {
        List<ByteArrayWrapper> commandElems = command.getProcessedCommandWrappers();
        if (commandElems.size() < 4 || commandElems.size() % 2 == 1) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), this.getArgsError()));
            return;
        }
        ByteArrayWrapper key = command.getKey();
        GeodeRedisHashSynchronized hash = new GeodeRedisHashSynchronized(key, context);
        int fieldsAdded = hash.hset(commandElems.subList(2, commandElems.size()), this.onlySetOnAbsent());
        command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), fieldsAdded));
    }

    protected boolean onlySetOnAbsent() {
        return false;
    }

    @Override
    public String getArgsError() {
        return "The wrong number of arguments or syntax was provided, the format for the HSET command is \"HSET key field value\"";
    }
}

