/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor.hash;

import java.util.List;
import org.apache.geode.redis.internal.ByteArrayWrapper;
import org.apache.geode.redis.internal.Coder;
import org.apache.geode.redis.internal.Command;
import org.apache.geode.redis.internal.ExecutionHandlerContext;
import org.apache.geode.redis.internal.executor.hash.GeodeRedisHashSynchronized;
import org.apache.geode.redis.internal.executor.hash.HashExecutor;

public class HMSetExecutor
extends HashExecutor {
    private static final String SUCCESS = "OK";

    @Override
    public void executeCommand(Command command, ExecutionHandlerContext context) {
        List<ByteArrayWrapper> commandElems = command.getProcessedCommandWrappers();
        if (commandElems.size() < 4 || commandElems.size() % 2 == 1) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The wrong number of arguments or syntax was provided, the format for the HMSET command is \"HMSET key field value [field value ...]\", or not every field is associated with a value"));
            return;
        }
        ByteArrayWrapper key = command.getKey();
        GeodeRedisHashSynchronized hash = new GeodeRedisHashSynchronized(key, context);
        hash.hset(commandElems.subList(2, commandElems.size()), false);
        command.setResponse(Coder.getSimpleStringResponse(context.getByteBufAllocator(), SUCCESS));
    }
}

