/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.apache.geode.redis.internal.Client;
import org.apache.geode.redis.internal.Subscription;

public class Subscriptions {
    private final List<Subscription> subscriptions = new CopyOnWriteArrayList<Subscription>();

    public boolean exists(Object channelOrPattern, Client client) {
        return this.subscriptions.stream().anyMatch(subscription -> subscription.isEqualTo(channelOrPattern, client));
    }

    public List<Subscription> findSubscriptions(Client client) {
        return this.subscriptions.stream().filter(subscription -> subscription.matchesClient(client)).collect(Collectors.toList());
    }

    public List<Subscription> findSubscriptions(String channelOrPattern) {
        return this.subscriptions.stream().filter(subscription -> subscription.matches(channelOrPattern)).collect(Collectors.toList());
    }

    public void add(Subscription subscription) {
        this.subscriptions.add(subscription);
    }

    public void remove(Client client) {
        this.subscriptions.removeIf(subscription -> subscription.matchesClient(client));
    }

    public void remove(Object channel, Client client) {
        this.subscriptions.removeIf(subscription -> subscription.isEqualTo(channel, client));
    }

    public int size() {
        return this.subscriptions.size();
    }
}

