/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.protocol.protobuf.v1.operations;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.geode.internal.protocol.protobuf.ProtocolVersion;
import org.apache.geode.internal.protocol.protobuf.statistics.ClientStatistics;
import org.apache.geode.internal.protocol.protobuf.v1.operations.VersionValidator;

public class ProtocolVersionHandler {
    private static final VersionValidator validator = new VersionValidator();

    public static boolean handleVersionMessage(InputStream inputStream, OutputStream outputStream, ClientStatistics statistics) throws IOException {
        ProtocolVersion.NewConnectionClientVersion versionMessage = ProtocolVersion.NewConnectionClientVersion.parseDelimitedFrom(inputStream);
        statistics.messageReceived(versionMessage.getSerializedSize());
        boolean versionAccepted = validator.isValid(versionMessage.getMajorVersion(), versionMessage.getMinorVersion());
        ProtocolVersion.VersionAcknowledgement handshakeResponse = ProtocolVersion.VersionAcknowledgement.newBuilder().setServerMajorVersion(1).setServerMinorVersion(1).setVersionAccepted(versionAccepted).build();
        handshakeResponse.writeDelimitedTo(outputStream);
        statistics.messageSent(handshakeResponse.getSerializedSize());
        if (!versionAccepted) {
            throw new IOException("Incompatible protobuf version.");
        }
        return versionAccepted;
    }
}

