/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.protocol.protobuf.v1.operations;

import com.google.protobuf.ProtocolStringList;
import java.util.List;
import org.apache.geode.internal.exception.InvalidExecutionContextException;
import org.apache.geode.internal.protocol.operations.ProtobufOperationHandler;
import org.apache.geode.internal.protocol.protobuf.v1.FunctionAPI;
import org.apache.geode.internal.protocol.protobuf.v1.MessageExecutionContext;
import org.apache.geode.internal.protocol.protobuf.v1.ProtobufSerializationService;
import org.apache.geode.internal.protocol.protobuf.v1.Result;
import org.apache.geode.internal.protocol.protobuf.v1.Success;
import org.apache.geode.internal.protocol.protobuf.v1.serialization.exception.DecodingException;
import org.apache.geode.internal.protocol.protobuf.v1.serialization.exception.EncodingException;

public class ExecuteFunctionOnMemberRequestOperationHandler
implements ProtobufOperationHandler<FunctionAPI.ExecuteFunctionOnMemberRequest, FunctionAPI.ExecuteFunctionOnMemberResponse> {
    @Override
    public Result<FunctionAPI.ExecuteFunctionOnMemberResponse> process(ProtobufSerializationService serializationService, FunctionAPI.ExecuteFunctionOnMemberRequest request, MessageExecutionContext messageExecutionContext) throws InvalidExecutionContextException, DecodingException, EncodingException {
        String functionID = request.getFunctionID();
        ProtocolStringList memberNameList = request.getMemberNameList();
        Object arguments = this.getFunctionArguments(request, serializationService);
        List<Object> results = messageExecutionContext.getSecureCache().getFunctionService().executeFunctionOnMember(functionID, arguments, memberNameList);
        FunctionAPI.ExecuteFunctionOnMemberResponse.Builder responseMessage = FunctionAPI.ExecuteFunctionOnMemberResponse.newBuilder();
        results.stream().map(serializationService::encode).forEach(responseMessage::addResults);
        return Success.of(responseMessage.build());
    }

    private Object getFunctionArguments(FunctionAPI.ExecuteFunctionOnMemberRequest request, ProtobufSerializationService serializationService) throws DecodingException {
        if (request.hasArguments()) {
            return serializationService.decode(request.getArguments());
        }
        return null;
    }
}

