/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal.membership.gms.messages;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Objects;
import org.apache.geode.distributed.internal.membership.api.MemberIdentifier;
import org.apache.geode.distributed.internal.membership.gms.GMSMembershipView;
import org.apache.geode.distributed.internal.membership.gms.messages.AbstractGMSMessage;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.SerializationContext;
import org.apache.geode.internal.serialization.Version;

public class InstallViewMessage<ID extends MemberIdentifier>
extends AbstractGMSMessage<ID> {
    private GMSMembershipView<ID> view;
    private Object credentials;
    private messageType kind;
    private int previousViewId;

    public InstallViewMessage(GMSMembershipView<ID> view, Object credentials, boolean preparing) {
        this.view = view;
        this.kind = preparing ? messageType.PREPARE : messageType.INSTALL;
        this.credentials = credentials;
    }

    public InstallViewMessage(GMSMembershipView<ID> view, Object credentials, int previousViewId, boolean preparing) {
        this.view = view;
        this.kind = preparing ? messageType.PREPARE : messageType.INSTALL;
        this.credentials = credentials;
        this.previousViewId = previousViewId;
    }

    public InstallViewMessage() {
    }

    public boolean isRebroadcast() {
        return this.kind == messageType.SYNC;
    }

    public GMSMembershipView<ID> getView() {
        return this.view;
    }

    public Object getCredentials() {
        return this.credentials;
    }

    public boolean isPreparing() {
        return this.kind == messageType.PREPARE;
    }

    public Version[] getSerializationVersions() {
        return null;
    }

    public int getDSFID() {
        return -150;
    }

    public void toData(DataOutput out, SerializationContext context) throws IOException {
        out.writeInt(this.previousViewId);
        out.writeInt(this.kind.ordinal());
        context.getSerializer().writeObject(this.view, out);
        context.getSerializer().writeObject(this.credentials, out);
    }

    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        this.previousViewId = in.readInt();
        this.kind = messageType.values()[in.readInt()];
        this.view = (GMSMembershipView)context.getDeserializer().readObject(in);
        this.credentials = context.getDeserializer().readObject(in);
    }

    public String toString() {
        return "InstallViewMessage(type=" + (Object)((Object)this.kind) + "; Current ViewID=" + this.view.getViewId() + "; Previous View ID=" + this.previousViewId + "; " + this.view + "; cred=" + (this.credentials == null ? "null" : "not null") + ")";
    }

    public int hashCode() {
        return Objects.hash(this.view, this.previousViewId);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InstallViewMessage other = (InstallViewMessage)obj;
        if (this.credentials == null ? other.credentials != null : !this.credentials.equals(other.credentials)) {
            return false;
        }
        if (this.kind != other.kind) {
            return false;
        }
        if (this.previousViewId != other.previousViewId) {
            return false;
        }
        return !(this.view == null ? other.view != null : !this.view.equals(other.view));
    }

    static enum messageType {
        INSTALL,
        PREPARE,
        SYNC;

    }
}

