/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.functions.table;

import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.data.ArrayData;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.MapData;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.functions.SpecializedFunction;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.runtime.functions.BuiltInSpecializedFunction;
import org.apache.flink.table.runtime.functions.table.BuiltInTableFunction;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.MapType;
import org.apache.flink.table.types.logical.MultisetType;
import org.apache.flink.table.types.logical.RowType;

@Internal
public class UnnestRowsFunction
extends BuiltInSpecializedFunction {
    public UnnestRowsFunction() {
        super(BuiltInFunctionDefinitions.INTERNAL_UNNEST_ROWS);
    }

    @Override
    public UserDefinedFunction specialize(SpecializedFunction.SpecializedContext context) {
        LogicalType argType = context.getCallContext().getArgumentDataTypes().get(0).getLogicalType();
        switch (argType.getTypeRoot()) {
            case ARRAY: {
                ArrayType arrayType = (ArrayType)argType;
                return new CollectionUnnestTableFunction(context, arrayType.getElementType(), ArrayData.createElementGetter(arrayType.getElementType()));
            }
            case MULTISET: {
                MultisetType multisetType = (MultisetType)argType;
                return new CollectionUnnestTableFunction(context, multisetType.getElementType(), ArrayData.createElementGetter(multisetType.getElementType()));
            }
            case MAP: {
                MapType mapType = (MapType)argType;
                return new MapUnnestTableFunction(context, RowType.of(false, mapType.getKeyType(), mapType.getValueType()), ArrayData.createElementGetter(mapType.getKeyType()), ArrayData.createElementGetter(mapType.getValueType()));
            }
        }
        throw new UnsupportedOperationException("Unsupported type for UNNEST: " + argType);
    }

    public static LogicalType getUnnestedType(LogicalType logicalType) {
        switch (logicalType.getTypeRoot()) {
            case ARRAY: {
                return ((ArrayType)logicalType).getElementType();
            }
            case MULTISET: {
                return ((MultisetType)logicalType).getElementType();
            }
            case MAP: {
                MapType mapType = (MapType)logicalType;
                return RowType.of(false, mapType.getKeyType(), mapType.getValueType());
            }
        }
        throw new UnsupportedOperationException("Unsupported UNNEST type: " + logicalType);
    }

    public static final class MapUnnestTableFunction
    extends UnnestTableFunctionBase {
        private static final long serialVersionUID = 1L;
        private final ArrayData.ElementGetter keyGetter;
        private final ArrayData.ElementGetter valueGetter;

        public MapUnnestTableFunction(SpecializedFunction.SpecializedContext context, LogicalType outputType, ArrayData.ElementGetter keyGetter, ArrayData.ElementGetter valueGetter) {
            super(context, outputType);
            this.keyGetter = keyGetter;
            this.valueGetter = valueGetter;
        }

        public void eval(MapData mapData) {
            if (mapData == null) {
                return;
            }
            int size = mapData.size();
            ArrayData keyArray = mapData.keyArray();
            ArrayData valueArray = mapData.valueArray();
            for (int i = 0; i < size; ++i) {
                this.collect(GenericRowData.of(this.keyGetter.getElementOrNull(keyArray, i), this.valueGetter.getElementOrNull(valueArray, i)));
            }
        }
    }

    public static final class CollectionUnnestTableFunction
    extends UnnestTableFunctionBase {
        private static final long serialVersionUID = 1L;
        private final ArrayData.ElementGetter elementGetter;

        public CollectionUnnestTableFunction(SpecializedFunction.SpecializedContext context, LogicalType outputType, ArrayData.ElementGetter elementGetter) {
            super(context, outputType);
            this.elementGetter = elementGetter;
        }

        public void eval(ArrayData arrayData) {
            if (arrayData == null) {
                return;
            }
            int size = arrayData.size();
            for (int pos = 0; pos < size; ++pos) {
                this.collect(this.elementGetter.getElementOrNull(arrayData, pos));
            }
        }

        public void eval(MapData mapData) {
            if (mapData == null) {
                return;
            }
            int size = mapData.size();
            ArrayData keys = mapData.keyArray();
            ArrayData values = mapData.valueArray();
            for (int pos = 0; pos < size; ++pos) {
                int multiplier = values.getInt(pos);
                Object key = this.elementGetter.getElementOrNull(keys, pos);
                for (int i = 0; i < multiplier; ++i) {
                    this.collect(key);
                }
            }
        }
    }

    private static abstract class UnnestTableFunctionBase
    extends BuiltInTableFunction<Object> {
        private final transient DataType outputDataType;

        UnnestTableFunctionBase(SpecializedFunction.SpecializedContext context, LogicalType outputType) {
            super(BuiltInFunctionDefinitions.INTERNAL_UNNEST_ROWS, context);
            this.outputDataType = DataTypes.of(outputType).toInternal();
        }

        @Override
        public DataType getOutputDataType() {
            return this.outputDataType;
        }
    }
}

