/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.file.compact;

import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.flink.table.store.file.compact.CompactResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CompactManager {
    private static final Logger LOG = LoggerFactory.getLogger(CompactManager.class);
    protected final ExecutorService executor;
    protected Future<CompactResult> taskFuture;

    public CompactManager(ExecutorService executor) {
        this.executor = executor;
    }

    public abstract void submitCompaction();

    public boolean isCompactionFinished() {
        return this.taskFuture == null;
    }

    public Optional<CompactResult> finishCompaction(boolean blocking) throws ExecutionException, InterruptedException {
        if (this.taskFuture != null && (blocking || this.taskFuture.isDone())) {
            CompactResult result;
            try {
                result = this.taskFuture.get();
            }
            catch (CancellationException e) {
                LOG.info("Compaction future is cancelled", (Throwable)e);
                this.taskFuture = null;
                return Optional.empty();
            }
            this.taskFuture = null;
            return Optional.of(result);
        }
        return Optional.empty();
    }

    public void cancelCompaction() {
        if (this.taskFuture != null && !this.taskFuture.isCancelled()) {
            this.taskFuture.cancel(true);
        }
    }
}

