/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.partition.BoundedData;
import org.apache.flink.runtime.io.network.partition.BufferReaderWriterUtil;
import org.apache.flink.runtime.io.network.partition.PageSizeUtil;
import org.apache.flink.runtime.io.network.partition.ResultSubpartitionView;
import org.apache.flink.shaded.netty4.io.netty.util.internal.PlatformDependent;
import org.apache.flink.util.IOUtils;
import org.apache.flink.util.Preconditions;

final class MemoryMappedBoundedData
implements BoundedData {
    private static final int PAGE_SIZE = PageSizeUtil.getSystemPageSizeOrConservativeMultiple();
    @Nullable
    private ByteBuffer currentBuffer;
    private final ArrayList<ByteBuffer> fullBuffers;
    private final FileChannel file;
    private final Path filePath;
    private long nextMappingOffset;
    private final long mappingSize;

    MemoryMappedBoundedData(Path filePath, FileChannel fileChannel, int maxSizePerByteBuffer) throws IOException {
        this.filePath = filePath;
        this.file = fileChannel;
        this.mappingSize = MemoryMappedBoundedData.alignSize(maxSizePerByteBuffer);
        this.fullBuffers = new ArrayList(4);
        this.rollOverToNextBuffer();
    }

    @Override
    public void writeBuffer(Buffer buffer) throws IOException {
        assert (this.currentBuffer != null);
        if (BufferReaderWriterUtil.writeBuffer(buffer, this.currentBuffer)) {
            return;
        }
        this.rollOverToNextBuffer();
        if (!BufferReaderWriterUtil.writeBuffer(buffer, this.currentBuffer)) {
            this.throwTooLargeBuffer(buffer);
        }
    }

    @Override
    public BufferSlicer createReader(ResultSubpartitionView ignored) {
        assert (this.currentBuffer == null);
        List<ByteBuffer> buffers = this.fullBuffers.stream().map(bb -> bb.slice().order(ByteOrder.nativeOrder())).collect(Collectors.toList());
        return new BufferSlicer(buffers);
    }

    @Override
    public void finishWrite() throws IOException {
        assert (this.currentBuffer != null);
        this.currentBuffer.flip();
        this.fullBuffers.add(this.currentBuffer);
        this.currentBuffer = null;
        this.file.close();
    }

    @Override
    public void close() throws IOException {
        IOUtils.closeQuietly(this.file);
        for (ByteBuffer bb : this.fullBuffers) {
            PlatformDependent.freeDirectBuffer((ByteBuffer)bb);
        }
        this.fullBuffers.clear();
        if (this.currentBuffer != null) {
            PlatformDependent.freeDirectBuffer((ByteBuffer)this.currentBuffer);
            this.currentBuffer = null;
        }
        Files.delete(this.filePath);
    }

    @Override
    public long getSize() {
        long size = 0L;
        for (ByteBuffer bb : this.fullBuffers) {
            size += (long)bb.remaining();
        }
        if (this.currentBuffer != null) {
            size += (long)this.currentBuffer.position();
        }
        return size;
    }

    @Override
    public Path getFilePath() {
        return this.filePath;
    }

    private void rollOverToNextBuffer() throws IOException {
        if (this.currentBuffer != null) {
            this.currentBuffer.flip();
            this.fullBuffers.add(this.currentBuffer);
        }
        this.currentBuffer = this.file.map(FileChannel.MapMode.READ_WRITE, this.nextMappingOffset, this.mappingSize);
        this.currentBuffer.order(ByteOrder.nativeOrder());
        this.nextMappingOffset += this.mappingSize;
    }

    private void throwTooLargeBuffer(Buffer buffer) throws IOException {
        throw new IOException(String.format("The buffer (%d bytes) is larger than the maximum size of a memory buffer (%d bytes)", buffer.getSize(), this.mappingSize));
    }

    private static int alignSize(int maxRegionSize) {
        Preconditions.checkArgument(maxRegionSize >= PAGE_SIZE);
        return maxRegionSize - maxRegionSize % PAGE_SIZE;
    }

    public static MemoryMappedBoundedData create(Path memMappedFilePath) throws IOException {
        return MemoryMappedBoundedData.createWithRegionSize(memMappedFilePath, Integer.MAX_VALUE);
    }

    public static MemoryMappedBoundedData createWithRegionSize(Path memMappedFilePath, int regionSize) throws IOException {
        FileChannel fileChannel = FileChannel.open(memMappedFilePath, StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.CREATE_NEW);
        return new MemoryMappedBoundedData(memMappedFilePath, fileChannel, regionSize);
    }

    static final class BufferSlicer
    implements BoundedData.Reader {
        private ByteBuffer currentData;
        private final Iterator<ByteBuffer> furtherData;

        BufferSlicer(Iterable<ByteBuffer> data) {
            this.furtherData = data.iterator();
            this.currentData = this.furtherData.next();
        }

        @Override
        @Nullable
        public Buffer nextBuffer() {
            assert (this.currentData != null);
            Buffer next = BufferReaderWriterUtil.sliceNextBuffer(this.currentData);
            if (next != null) {
                return next;
            }
            if (!this.furtherData.hasNext()) {
                return null;
            }
            this.currentData = this.furtherData.next();
            return this.nextBuffer();
        }

        @Override
        public void close() throws IOException {
        }
    }
}

