/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators.co;

import java.util.List;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.state.MapStateDescriptor;
import org.apache.flink.streaming.api.functions.co.KeyedBroadcastProcessFunction;
import org.apache.flink.streaming.api.operators.BoundedMultiInput;
import org.apache.flink.streaming.api.operators.co.CoBroadcastWithKeyedOperator;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.util.Preconditions;

@Internal
public class BatchCoBroadcastWithKeyedOperator<KS, IN1, IN2, OUT>
extends CoBroadcastWithKeyedOperator<KS, IN1, IN2, OUT>
implements BoundedMultiInput {
    private static final long serialVersionUID = 5926499536290284870L;
    private volatile transient boolean isBroadcastSideDone = false;

    public BatchCoBroadcastWithKeyedOperator(KeyedBroadcastProcessFunction<KS, IN1, IN2, OUT> function, List<MapStateDescriptor<?, ?>> broadcastStateDescriptors) {
        super(function, broadcastStateDescriptors);
    }

    @Override
    public void endInput(int inputId) throws Exception {
        if (inputId == 2) {
            this.isBroadcastSideDone = true;
        }
    }

    @Override
    public void processElement1(StreamRecord<IN1> element) throws Exception {
        Preconditions.checkState(this.isBroadcastSideDone, "Should not process regular input before broadcast side is done.");
        super.processElement1(element);
    }
}

