/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.bundle.trigger;

import org.apache.flink.table.runtime.operators.bundle.trigger.BundleTrigger;
import org.apache.flink.table.runtime.operators.bundle.trigger.BundleTriggerCallback;
import org.apache.flink.util.Preconditions;

public class CountBundleTrigger<T>
implements BundleTrigger<T> {
    private static final long serialVersionUID = -3640028071558094814L;
    private final long maxCount;
    private transient BundleTriggerCallback callback;
    private transient long count = 0L;

    public CountBundleTrigger(long maxCount) {
        Preconditions.checkArgument(maxCount > 0L, "maxCount must be greater than 0");
        this.maxCount = maxCount;
    }

    @Override
    public void registerCallback(BundleTriggerCallback callback) {
        this.callback = Preconditions.checkNotNull(callback, "callback is null");
    }

    @Override
    public void onElement(T element) throws Exception {
        ++this.count;
        if (this.count >= this.maxCount) {
            this.callback.finishBundle();
            this.reset();
        }
    }

    @Override
    public void reset() {
        this.count = 0L;
    }

    @Override
    public String explain() {
        return "CountBundleTrigger with size " + this.maxCount;
    }
}

