/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.param;

import org.apache.commons.lang3.ArrayUtils;
import org.apache.flink.ml.param.ParamValidator;

public class ParamValidators {
    public static <T> ParamValidator<T> alwaysTrue() {
        return value -> true;
    }

    public static <T> ParamValidator<T> gt(double lowerBound) {
        return value -> value != null && ((Number)value).doubleValue() > lowerBound;
    }

    public static <T> ParamValidator<T> gtEq(double lowerBound) {
        return value -> value != null && ((Number)value).doubleValue() >= lowerBound;
    }

    public static <T> ParamValidator<T> lt(double upperBound) {
        return value -> value != null && ((Number)value).doubleValue() < upperBound;
    }

    public static <T> ParamValidator<T> ltEq(double upperBound) {
        return value -> value != null && ((Number)value).doubleValue() <= upperBound;
    }

    public static <T> ParamValidator<T> inRange(final double lowerBound, final double upperBound, final boolean lowerInclusive, final boolean upperInclusive) {
        return new ParamValidator<T>(){

            @Override
            public boolean validate(T obj) {
                if (obj == null) {
                    return false;
                }
                double value = ((Number)obj).doubleValue();
                return value >= lowerBound && value <= upperBound && (lowerInclusive || value != lowerBound) && (upperInclusive || value != upperBound);
            }
        };
    }

    public static <T> ParamValidator<T> inRange(double lowerBound, double upperBound) {
        return ParamValidators.inRange(lowerBound, upperBound, true, true);
    }

    public static <T> ParamValidator<T> inArray(final T ... allowed) {
        return new ParamValidator<T>(){

            @Override
            public boolean validate(T value) {
                return value != null && ArrayUtils.contains((Object[])allowed, value);
            }
        };
    }

    public static <T> ParamValidator<T> notNull() {
        return new ParamValidator<T>(){

            @Override
            public boolean validate(T value) {
                return value != null;
            }
        };
    }

    public static <T> ParamValidator<T[]> nonEmptyArray() {
        return value -> value != null && ((Object[])value).length > 0;
    }

    @SafeVarargs
    public static <T> ParamValidator<T[]> isSubSet(final T ... allowed) {
        return new ParamValidator<T[]>(){

            @Override
            public boolean validate(T[] value) {
                if (value == null) {
                    return false;
                }
                for (Object t : value) {
                    if (ArrayUtils.contains((Object[])allowed, t)) continue;
                    return false;
                }
                return true;
            }
        };
    }
}

