/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.linalg.typeinfo;

import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.apache.flink.api.common.typeutils.SimpleTypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.ml.linalg.DenseVector;
import org.apache.flink.ml.util.Bits;

public final class DenseVectorSerializer
extends TypeSerializer<DenseVector> {
    private static final long serialVersionUID = 1L;
    private static final double[] EMPTY = new double[0];
    private final byte[] buf = new byte[1024];

    public boolean isImmutableType() {
        return false;
    }

    public TypeSerializer<DenseVector> duplicate() {
        return new DenseVectorSerializer();
    }

    public DenseVector createInstance() {
        return new DenseVector(EMPTY);
    }

    public DenseVector copy(DenseVector from) {
        return new DenseVector(Arrays.copyOf(from.values, from.values.length));
    }

    public DenseVector copy(DenseVector from, DenseVector reuse) {
        if (from.values.length == reuse.values.length) {
            System.arraycopy(from.values, 0, reuse.values, 0, from.values.length);
            return reuse;
        }
        return this.copy(from);
    }

    public int getLength() {
        return -1;
    }

    public void serialize(DenseVector vector, DataOutputView target) throws IOException {
        if (vector == null) {
            throw new IllegalArgumentException("The vector must not be null.");
        }
        int len = vector.values.length;
        target.writeInt(len);
        for (int i = 0; i < len; ++i) {
            Bits.putDouble(this.buf, (i & 0x7F) << 3, vector.values[i]);
            if ((i & 0x7F) != 127) continue;
            target.write(this.buf);
        }
        target.write(this.buf, 0, (len & 0x7F) << 3);
    }

    public DenseVector deserialize(DataInputView source) throws IOException {
        int len = source.readInt();
        double[] values = new double[len];
        this.readDoubleArray(values, source, len);
        return new DenseVector(values);
    }

    private void readDoubleArray(double[] dst, DataInputView source, int len) throws IOException {
        int index = 0;
        for (int i = 0; i < len >> 7; ++i) {
            source.readFully(this.buf, 0, 1024);
            for (int j = 0; j < 128; ++j) {
                dst[index++] = Bits.getDouble(this.buf, j << 3);
            }
        }
        source.readFully(this.buf, 0, len << 3 & 0x3FF);
        for (int j = 0; j < (len & 0x7F); ++j) {
            dst[index++] = Bits.getDouble(this.buf, j << 3);
        }
    }

    public DenseVector deserialize(DenseVector reuse, DataInputView source) throws IOException {
        int len = source.readInt();
        if (len == reuse.values.length) {
            this.readDoubleArray(reuse.values, source, len);
            return reuse;
        }
        double[] values = new double[len];
        this.readDoubleArray(values, source, len);
        return new DenseVector(values);
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        int len = source.readInt();
        target.writeInt(len);
        target.write(source, len * 8);
    }

    public boolean equals(Object o) {
        return o instanceof DenseVectorSerializer;
    }

    public int hashCode() {
        return Objects.hashCode(DenseVectorSerializer.class);
    }

    public TypeSerializerSnapshot<DenseVector> snapshotConfiguration() {
        return new DenseVectorSerializerSnapshot();
    }

    public static final class DenseVectorSerializerSnapshot
    extends SimpleTypeSerializerSnapshot<DenseVector> {
        public DenseVectorSerializerSnapshot() {
            super(DenseVectorSerializer::new);
        }
    }
}

