/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.linalg.typeinfo;

import java.io.IOException;
import java.util.Arrays;
import org.apache.flink.api.common.typeutils.SimpleTypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.base.TypeSerializerSingleton;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.ml.linalg.DenseMatrix;

public final class DenseMatrixSerializer
extends TypeSerializerSingleton<DenseMatrix> {
    private static final long serialVersionUID = 1L;
    private static final double[] EMPTY = new double[0];
    public static final DenseMatrixSerializer INSTANCE = new DenseMatrixSerializer();

    public boolean isImmutableType() {
        return false;
    }

    public DenseMatrix createInstance() {
        return new DenseMatrix(0, 0, EMPTY);
    }

    public DenseMatrix copy(DenseMatrix from) {
        return new DenseMatrix(from.numRows(), from.numCols(), Arrays.copyOf(from.values, from.values.length));
    }

    public DenseMatrix copy(DenseMatrix from, DenseMatrix reuse) {
        if (from.values.length == reuse.values.length) {
            System.arraycopy(from.values, 0, reuse.values, 0, from.values.length);
            if (from.numCols() == reuse.numCols()) {
                return reuse;
            }
            return new DenseMatrix(from.numRows(), from.numCols(), reuse.values);
        }
        return this.copy(from);
    }

    public int getLength() {
        return -1;
    }

    public void serialize(DenseMatrix matrix, DataOutputView target) throws IOException {
        if (matrix == null) {
            throw new IllegalArgumentException("The matrix must not be null.");
        }
        int len = matrix.values.length;
        target.writeInt(matrix.numRows());
        target.writeInt(matrix.numCols());
        for (int i = 0; i < len; ++i) {
            target.writeDouble(matrix.values[i]);
        }
    }

    public DenseMatrix deserialize(DataInputView source) throws IOException {
        int m = source.readInt();
        int n = source.readInt();
        double[] values = new double[m * n];
        DenseMatrixSerializer.deserializeDoubleArray(values, source, m * n);
        return new DenseMatrix(m, n, values);
    }

    private static void deserializeDoubleArray(double[] dst, DataInputView source, int len) throws IOException {
        for (int i = 0; i < len; ++i) {
            dst[i] = source.readDouble();
        }
    }

    public DenseMatrix deserialize(DenseMatrix reuse, DataInputView source) throws IOException {
        int n;
        double[] values = reuse.values;
        int m = source.readInt();
        if (values.length != m * (n = source.readInt())) {
            double[] tmpValues = new double[m * n];
            DenseMatrixSerializer.deserializeDoubleArray(tmpValues, source, m * n);
            return new DenseMatrix(m, n, tmpValues);
        }
        DenseMatrixSerializer.deserializeDoubleArray(values, source, m * n);
        return new DenseMatrix(m, n, values);
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        int m = source.readInt();
        target.writeInt(m);
        int n = source.readInt();
        target.writeInt(n);
        target.write(source, m * n * 8);
    }

    public TypeSerializerSnapshot<DenseMatrix> snapshotConfiguration() {
        return new DenseMatrixSerializerSnapshot();
    }

    public static final class DenseMatrixSerializerSnapshot
    extends SimpleTypeSerializerSnapshot<DenseMatrix> {
        public DenseMatrixSerializerSnapshot() {
            super(() -> INSTANCE);
        }
    }
}

