/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.table;

import java.util.LinkedHashMap;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.connector.file.table.PartitionComputer;
import org.apache.flink.connector.file.table.PartitionTempFileManager;
import org.apache.flink.connector.file.table.PartitionWriter;
import org.apache.flink.core.fs.Path;
import org.apache.flink.table.utils.PartitionPathUtils;

@Internal
public class SingleDirectoryWriter<T>
implements PartitionWriter<T> {
    private final PartitionWriter.Context<T> context;
    private final PartitionTempFileManager manager;
    private final PartitionComputer<T> computer;
    private final LinkedHashMap<String, String> staticPartitions;
    private final PartitionWriter.PartitionWriterListener writerListener;
    private OutputFormat<T> format;

    public SingleDirectoryWriter(PartitionWriter.Context<T> context, PartitionTempFileManager manager, PartitionComputer<T> computer, LinkedHashMap<String, String> staticPartitions) {
        this(context, manager, computer, staticPartitions, new PartitionWriter.DefaultPartitionWriterListener());
    }

    public SingleDirectoryWriter(PartitionWriter.Context<T> context, PartitionTempFileManager manager, PartitionComputer<T> computer, LinkedHashMap<String, String> staticPartitions, PartitionWriter.PartitionWriterListener writerListener) {
        this.context = context;
        this.manager = manager;
        this.computer = computer;
        this.staticPartitions = staticPartitions;
        this.writerListener = writerListener;
    }

    @Override
    public void write(T in) throws Exception {
        if (this.format == null) {
            String partition = PartitionPathUtils.generatePartitionPath(this.staticPartitions);
            Path path = this.staticPartitions.isEmpty() ? this.manager.createPartitionDir(new String[0]) : this.manager.createPartitionDir(partition);
            this.format = this.context.createNewOutputFormat(path);
            this.writerListener.onFileOpened(partition, path);
        }
        this.format.writeRecord(this.computer.projectColumnsToWrite(in));
    }

    @Override
    public void close() throws Exception {
        if (this.format != null) {
            this.format.close();
            this.format = null;
        }
    }
}

