/*
 * Decompiled with CFR 0.152.
 */
package flash.tools.debugger.expression;

import flash.tools.debugger.PlayerDebugException;
import flash.tools.debugger.expression.Context;
import flash.tools.debugger.expression.DebuggerExpressionEvaluator;
import flash.tools.debugger.expression.DebuggerValue;
import flash.tools.debugger.expression.NoSuchVariableException;
import flash.tools.debugger.expression.PlayerFaultException;
import flash.tools.debugger.expression.ValueExp;
import java.util.HashSet;
import org.apache.flex.compiler.tree.ASTNodeID;
import org.apache.flex.compiler.tree.as.IASNode;

class DebuggerExpression
implements ValueExp {
    private static final HashSet<ASTNodeID> ASSIGN_OPRATORS = new HashSet();
    private IASNode m_programNode;
    private boolean m_lookupMembers = false;

    DebuggerExpression() {
    }

    public IASNode getProgramNode() {
        return this.m_programNode;
    }

    public void setProgramNode(IASNode iASNode) {
        this.m_programNode = iASNode;
    }

    @Override
    public boolean isLookupMembers() {
        return this.m_lookupMembers;
    }

    public void setLookupMembers(boolean bl) {
        this.m_lookupMembers = bl;
    }

    @Override
    public boolean containsAssignment() {
        return this.containsAssignment(this.m_programNode);
    }

    private boolean containsAssignment(IASNode iASNode) {
        if (ASSIGN_OPRATORS.contains((Object)iASNode.getNodeID())) {
            return true;
        }
        for (int i = 0; i < iASNode.getChildCount(); ++i) {
            if (!this.containsAssignment(iASNode.getChild(i))) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object evaluate(Context context) throws NumberFormatException, NoSuchVariableException, PlayerFaultException, PlayerDebugException {
        DebuggerValue debuggerValue;
        block9: {
            DebuggerExpressionEvaluator debuggerExpressionEvaluator = new DebuggerExpressionEvaluator();
            debuggerValue = debuggerExpressionEvaluator.evaluate(context, this.m_programNode);
            if (!this.isLookupMembers()) break block9;
            Object object = context.lookupMembers(debuggerValue.debuggerValue);
            return object;
        }
        try {
            Object object = debuggerValue.debuggerValue;
            return object;
        }
        catch (Exception exception) {
            if (exception.getCause() instanceof NumberFormatException) {
                throw (NumberFormatException)exception.getCause();
            }
            if (exception.getCause() instanceof NoSuchVariableException) {
                throw (NoSuchVariableException)exception.getCause();
            }
            if (exception.getCause() instanceof PlayerFaultException) {
                throw (PlayerFaultException)exception.getCause();
            }
            if (exception.getCause() instanceof PlayerDebugException) {
                throw (PlayerDebugException)exception.getCause();
            }
            exception.printStackTrace();
            throw new PlayerDebugException(exception.getLocalizedMessage());
        }
    }

    static {
        ASSIGN_OPRATORS.add(ASTNodeID.Op_AssignId);
        ASSIGN_OPRATORS.add(ASTNodeID.Op_LeftShiftAssignID);
        ASSIGN_OPRATORS.add(ASTNodeID.Op_RightShiftAssignID);
        ASSIGN_OPRATORS.add(ASTNodeID.Op_UnsignedRightShiftAssignID);
        ASSIGN_OPRATORS.add(ASTNodeID.Op_MultiplyAssignID);
        ASSIGN_OPRATORS.add(ASTNodeID.Op_DivideAssignID);
        ASSIGN_OPRATORS.add(ASTNodeID.Op_ModuloAssignID);
        ASSIGN_OPRATORS.add(ASTNodeID.Op_BitwiseAndAssignID);
        ASSIGN_OPRATORS.add(ASTNodeID.Op_BitwiseXorAssignID);
        ASSIGN_OPRATORS.add(ASTNodeID.Op_BitwiseOrAssignID);
        ASSIGN_OPRATORS.add(ASTNodeID.Op_AddAssignID);
        ASSIGN_OPRATORS.add(ASTNodeID.Op_SubtractAssignID);
        ASSIGN_OPRATORS.add(ASTNodeID.Op_LogicalAndAssignID);
        ASSIGN_OPRATORS.add(ASTNodeID.Op_LogicalOrAssignID);
    }
}

