/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.base.Preconditions;
import com.google.common.truth.FailureStrategy;
import com.google.common.truth.Platform;
import com.google.common.truth.Subject;
import java.util.List;

public abstract class AbstractArraySubject<S extends AbstractArraySubject<S, T>, T>
extends Subject<AbstractArraySubject<S, T>, T> {
    AbstractArraySubject(FailureStrategy failureStrategy, T subject) {
        super(failureStrategy, subject);
    }

    public void isEmpty() {
        if (!this.listRepresentation().isEmpty()) {
            this.fail("is empty");
        }
    }

    public void isNotEmpty() {
        if (this.listRepresentation().isEmpty()) {
            this.fail("is not empty");
        }
    }

    public void hasLength(int length) {
        Preconditions.checkArgument((length >= 0 ? 1 : 0) != 0, (Object)"length (%s) must be >= 0");
        if (this.listRepresentation().size() != length) {
            this.fail("has length", (Object)length);
        }
    }

    @Override
    public S named(String name) {
        return (S)((AbstractArraySubject)super.named(name));
    }

    abstract String underlyingType();

    abstract List<?> listRepresentation();

    @Override
    protected String getDisplaySubject() {
        return this.internalCustomName() == null ? "<(" + this.underlyingType() + "[]) " + this.listRepresentation() + ">" : "\"" + this.internalCustomName() + "\"";
    }

    void failWithBadType(Object expected) {
        String expectedType = expected.getClass().isArray() ? expected.getClass().getComponentType().getName() + "[]" : expected.getClass().getName();
        this.failWithRawMessage("Incompatible types compared. expected: %s, actual: %s[]", Platform.compressType(expectedType), this.underlyingType());
    }
}

