/*
 * Decompiled with CFR 0.152.
 */
package macromedia.asc.semantics;

import java.util.HashSet;
import java.util.LinkedList;
import macromedia.asc.embedding.avmplus.InstanceBuilder;
import macromedia.asc.semantics.ObjectValue;
import macromedia.asc.semantics.ObjectValueWalker;
import macromedia.asc.semantics.ReferenceValue;
import macromedia.asc.semantics.TypeValue;

public final class InterfaceWalker
extends ObjectValueWalker {
    private LinkedList<TypeValue> queue = new LinkedList();
    private HashSet<TypeValue> set = new HashSet();
    private ObjectValue nextInterface = null;
    private boolean superInterfaces = false;

    public InterfaceWalker(ObjectValue startObj) {
        this(startObj, true);
    }

    public InterfaceWalker(ObjectValue startObj, boolean superInterfaces) {
        this.superInterfaces = superInterfaces;
        this.queue.add(startObj instanceof TypeValue ? (TypeValue)startObj : startObj.type.getTypeValue());
        this.processQueue();
        if (this.nextInterface == startObj) {
            this.nextInterface = null;
        }
    }

    public boolean hasNext() {
        this.processQueue();
        return this.nextInterface != null;
    }

    public ObjectValue next() {
        ObjectValue returnValue = this.nextInterface;
        this.nextInterface = null;
        return returnValue;
    }

    public void clear() {
        this.set.clear();
        this.queue.clear();
        this.nextInterface = null;
    }

    private void processQueue() {
        while (this.nextInterface == null && !this.queue.isEmpty()) {
            TypeValue type = this.queue.removeFirst();
            if (!type.resolved) continue;
            if (type.baseclass != null && !type.isInterface()) {
                this.queue.add(type.baseclass);
            }
            InstanceBuilder ibui = (InstanceBuilder)type.prototype.builder;
            if (ibui.interface_refs != null && (this.superInterfaces || !type.isInterface())) {
                int size = ibui.interface_refs.size();
                for (int i = 0; i < size; ++i) {
                    ReferenceValue ref = (ReferenceValue)ibui.interface_refs.get(i);
                    this.queue.add((TypeValue)ref.slot.getObjectValue());
                }
            }
            if (!type.isInterface() || this.set.contains(type)) continue;
            this.nextInterface = type.prototype;
            this.set.add(type);
        }
    }
}

