/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.io;

import flash.util.FileUtils;
import flex2.compiler.io.VirtualFile;
import flex2.compiler.io.ZipFileHolder;
import flex2.compiler.swc.zip.ZipEntry;
import flex2.compiler.util.MimeMappings;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class VirtualZipFile
implements VirtualFile {
    private String mimeType;
    private String name;
    private String nameInZip;
    private byte[] bytes;
    private ZipFileHolder zipFile;

    public VirtualZipFile(ZipFileHolder zipFileHolder, String mimeType, String name, String nameInZip) {
        this.zipFile = zipFileHolder;
        this.mimeType = mimeType;
        this.name = name;
        this.nameInZip = nameInZip;
    }

    public void close() {
        this.bytes = null;
    }

    public InputStream getInputStream() throws IOException {
        return new ByteArrayInputStream(this.toByteArray());
    }

    public byte[] toByteArray() throws IOException {
        if (this.bytes == null) {
            try {
                this.readBytes();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (this.bytes == null || this.bytes.length == 0) {
                this.zipFile.close();
                this.readBytes();
            }
        }
        return this.bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void readBytes() throws IOException {
        InputStream stream = null;
        try {
            ZipEntry zipEntry = this.zipFile.getEntry(this.nameInZip);
            stream = this.zipFile.getZipFile().getInputStream(zipEntry);
            this.bytes = FileUtils.toByteArray((InputStream)stream);
            Object var4_3 = null;
            if (stream == null) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (stream == null) throw throwable;
            try {
                stream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            stream.close();
            return;
        }
        catch (IOException iOException) {}
    }

    public long getLastModified() {
        ZipEntry zipEntry = this.zipFile.getEntry(this.nameInZip);
        return zipEntry.getTime();
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public String getName() {
        return this.name;
    }

    public String getNameForReporting() {
        return this.getName();
    }

    public String getParent() {
        return this.zipFile.getPath();
    }

    public boolean isDirectory() {
        return false;
    }

    public String getURL() {
        return "jar:file://" + this.getName().replaceAll("\\$", "!/");
    }

    public long size() {
        ZipEntry zipEntry = this.zipFile.getEntry(this.nameInZip);
        return zipEntry.getSize();
    }

    public VirtualFile resolve(String relative) {
        int separator = this.nameInZip.lastIndexOf("/");
        if (separator != -1) {
            relative = FileUtils.addPathComponents((String)this.nameInZip.substring(0, separator), (String)relative, (char)'/');
        }
        ZipEntry zipEntry = this.zipFile.getEntry(relative);
        VirtualZipFile result = null;
        if (zipEntry != null) {
            String name = zipEntry.getName();
            result = new VirtualZipFile(this.zipFile, MimeMappings.getMimeType(zipEntry.getName()), this.zipFile.getPath() + "$" + name, name);
        }
        return result;
    }

    public boolean equals(Object obj) {
        return obj == this;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean isTextBased() {
        return false;
    }
}

