/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler;

import flex2.compiler.CompilationUnit;
import flex2.compiler.CompilerAPI;
import flex2.compiler.Source;
import flex2.compiler.util.QName;
import flex2.compiler.util.QNameMap;
import flex2.tools.oem.ApplicationCache;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ResourceContainer {
    private Map<String, Source> name2source = new LinkedHashMap<String, Source>();
    private QNameMap<Source> qname2source = new QNameMap();
    private ApplicationCache applicationCache;

    public Source addResource(Source s) {
        CompilationUnit u;
        Source old = this.name2source.get(s.getName());
        CompilationUnit compilationUnit = u = old != null ? old.getCompilationUnit() : null;
        if (u == null || u != null && !u.isDone() || old.getLastModified() != s.getLastModified() || old.isUpdated(s)) {
            s.setOwner(this);
            this.name2source.put(s.getName(), s);
            return s;
        }
        return old.copy();
    }

    public Source findSource(String name) {
        CompilationUnit cachedCompilationUnit;
        Source cachedSource;
        if (this.applicationCache != null && (cachedSource = this.applicationCache.getSource(name)) != null && !cachedSource.isUpdated() && (cachedCompilationUnit = cachedSource.getCompilationUnit()) != null && cachedCompilationUnit.hasTypeInfo) {
            Source source = cachedSource.copy();
            cachedSource.reused();
            this.name2source.put(name, source);
            return source;
        }
        return this.checkSource(this.name2source.get(name));
    }

    Source findSource(String namespaceURI, String localPart) {
        CompilationUnit cachedCompilationUnit;
        String className;
        Source cachedSource;
        assert (localPart.indexOf(46) == -1 && localPart.indexOf(47) == -1 && localPart.indexOf(58) == -1) : "findSource(" + namespaceURI + "," + localPart + ") has bad localPart";
        if (this.applicationCache != null && (cachedSource = this.applicationCache.getSource(className = CompilerAPI.constructClassName(namespaceURI, localPart))) != null && !cachedSource.isUpdated() && (cachedCompilationUnit = cachedSource.getCompilationUnit()) != null && cachedCompilationUnit.hasTypeInfo && cachedCompilationUnit.isDone()) {
            Source source = cachedSource.copy();
            cachedSource.reused();
            this.name2source.put(source.getName(), source);
            this.qname2source.put(namespaceURI, localPart, source);
            return source;
        }
        return this.checkSource(this.qname2source.get(namespaceURI, localPart));
    }

    private Source checkSource(Source s) {
        CompilationUnit u;
        CompilationUnit compilationUnit = u = s != null ? s.getCompilationUnit() : null;
        if (!(u != null && !u.isDone() || s != null && s.isUpdated() || u == null)) {
            s = s.copy();
            assert (s != null);
        }
        return s;
    }

    public void refresh() {
        this.qname2source.clear();
        for (Source s : this.name2source.values()) {
            CompilationUnit u = s.getCompilationUnit();
            if (u == null) continue;
            int size = u.topLevelDefinitions.size();
            for (int j = 0; j < size; ++j) {
                QName qName = (QName)u.topLevelDefinitions.get(j);
                this.qname2source.put(qName, s);
            }
        }
    }

    public Map<String, Source> sources() {
        HashMap<String, Source> result = new HashMap<String, Source>(this.qname2source.size());
        for (Map.Entry entry : this.qname2source.entrySet()) {
            result.put(((QName)entry.getKey()).toString(), (Source)entry.getValue());
        }
        return result;
    }

    public void setApplicationCache(ApplicationCache applicationCache) {
        this.applicationCache = applicationCache;
    }
}

