/*
 * Decompiled with CFR 0.152.
 */
package adobe.abc;

import java.io.PrintWriter;
import java.util.Stack;

public class TraceManager {
    private Stack<TraceElement> activeElements;
    private StringBuffer indentBuffer = new StringBuffer();
    private PrintWriter sink;
    private boolean enabled = true;

    public TraceManager() {
        this.activeElements = new Stack();
    }

    public void enable(PrintWriter sink) {
        this.sink = sink;
    }

    private boolean isEnabled() {
        return this.enabled && this.sink != null;
    }

    public void disable() {
        if (this.isEnabled() && this.activeElements.size() > 0) {
            this.finishCurrentElement();
        }
        this.enabled = false;
    }

    public void enable() {
        this.enabled = true;
    }

    public int pushPhase(String phaseName) {
        return this.pushElement(phaseName, false);
    }

    public int pushElement(String elementName, boolean popOnNext) {
        if (0 == this.activeElements.size()) {
            this.println("<?xml version='1.0' encoding='utf-8' ?>");
        } else {
            this.finishCurrentElement();
        }
        int result = this.activeElements.size();
        this.activeElements.push(new TraceElement(elementName, popOnNext));
        this.indentBuffer.append(' ');
        StringBuffer output = this.getIndentedBuffer();
        output.append("<");
        output.append(elementName);
        this.print(output.toString());
        return result;
    }

    TraceElement popElement() {
        TraceElement finished_element = this.activeElements.pop();
        if (this.isEnabled()) {
            if (finished_element.hasBody) {
                StringBuffer output = this.getIndentedBuffer();
                output.append("</");
                output.append(finished_element.phaseName);
                output.append(">");
                this.println(output.toString());
            } else {
                this.println("/>");
            }
            this.sink.flush();
        }
        this.indentBuffer.deleteCharAt(0);
        return finished_element;
    }

    private StringBuffer getIndentedBuffer() {
        return new StringBuffer(this.indentBuffer);
    }

    private void finishCurrentElement() {
        if (this.activeElements.peek().popOnNext) {
            this.popElement();
        } else if (!this.activeElements.peek().hasBody) {
            this.println(">");
            this.activeElements.peek().setHasBody(true);
        }
    }

    public void unwind(int mark) {
        while (this.activeElements.size() > mark) {
            this.popElement();
        }
    }

    public void traceEntry(String tagName) {
        this.pushElement(tagName, true);
    }

    public void traceEntry(String tagName, String attrName, String attrValue) {
        this.traceEntry(tagName);
        this.addAttr(attrName, attrValue);
    }

    public void traceEntry(String tagName, String attrValue) {
        this.traceEntry(tagName, "value", attrValue);
    }

    public void traceEntry(String tagName, int attrValue) {
        this.traceEntry(tagName, Integer.toHexString(attrValue));
    }

    public void addAttr(String attrName, String attrValue) {
        if (this.isEnabled()) {
            String xml_escaped_value = attrValue.replaceAll("&", "&amp;");
            xml_escaped_value = xml_escaped_value.replaceAll("<", "&lt;");
            xml_escaped_value = xml_escaped_value.replaceAll(">", "&gt;");
            xml_escaped_value = xml_escaped_value.replaceAll("\"", "&quot;");
            xml_escaped_value = xml_escaped_value.replaceAll("\r", "\\r");
            this.print(" " + attrName + "=\"" + xml_escaped_value + "\"");
        }
    }

    public void addAttr(String attrName, int attrValue) {
        this.print(" " + attrName + "=\"" + attrValue + "\"");
    }

    public void addAttr(String attrName, Object attr) {
        if (this.isEnabled()) {
            String attrValue;
            if (attr != null) {
                attrValue = attr.toString();
                if (attrValue.replaceAll("\\s", "").equals("null")) {
                    attrValue = "0x" + Integer.toHexString(attr.hashCode());
                }
            } else {
                attrValue = "null";
            }
            this.addAttr(attrName, attrValue);
        }
    }

    void println(String s) {
        if (this.isEnabled()) {
            this.sink.println(s);
        }
    }

    void print(String s) {
        if (this.isEnabled()) {
            this.sink.print(s);
        }
    }

    void flush() {
        if (this.isEnabled()) {
            this.sink.flush();
        }
    }

    private class TraceElement {
        String phaseName;
        boolean hasBody = false;
        boolean popOnNext = false;

        TraceElement(String phaseName) {
            this.phaseName = phaseName;
        }

        TraceElement(String entryName, boolean popOnNext) {
            this.phaseName = entryName;
            this.popOnNext = popOnNext;
        }

        void setHasBody(boolean has_body) {
            this.hasBody = has_body;
        }
    }
}

