/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.upnp.basedriver.importer.core;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.apache.felix.upnp.basedriver.Activator;
import org.apache.felix.upnp.basedriver.importer.core.OSGiDeviceInfo;
import org.apache.felix.upnp.basedriver.importer.core.event.message.FirstMessage;
import org.apache.felix.upnp.basedriver.importer.core.event.message.ListenerModified;
import org.apache.felix.upnp.basedriver.importer.core.event.message.ListenerUnRegistration;
import org.apache.felix.upnp.basedriver.importer.core.event.message.StateChanged;
import org.apache.felix.upnp.basedriver.importer.core.event.structs.NotifierQueue;
import org.apache.felix.upnp.basedriver.importer.core.event.structs.SubscriptionQueue;
import org.apache.felix.upnp.basedriver.importer.core.upnp.UPnPDeviceImpl;
import org.apache.felix.upnp.basedriver.importer.core.upnp.UPnPServiceImpl;
import org.apache.felix.upnp.basedriver.importer.util.ParseUSN;
import org.apache.felix.upnp.basedriver.util.Converter;
import org.cybergarage.http.HTTPRequest;
import org.cybergarage.upnp.ControlPoint;
import org.cybergarage.upnp.Device;
import org.cybergarage.upnp.DeviceList;
import org.cybergarage.upnp.Service;
import org.cybergarage.upnp.ServiceList;
import org.cybergarage.upnp.ServiceStateTable;
import org.cybergarage.upnp.StateVariable;
import org.cybergarage.upnp.device.NotifyListener;
import org.cybergarage.upnp.device.SearchResponseListener;
import org.cybergarage.upnp.event.NotifyRequest;
import org.cybergarage.upnp.event.Property;
import org.cybergarage.upnp.event.PropertyList;
import org.cybergarage.upnp.ssdp.SSDPPacket;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.upnp.UPnPDevice;
import org.osgi.service.upnp.UPnPEventListener;
import org.osgi.service.upnp.UPnPService;
import org.osgi.service.upnp.UPnPStateVariable;

public class MyCtrlPoint
extends ControlPoint
implements NotifyListener,
SearchResponseListener,
ServiceListener {
    private BundleContext context;
    private Hashtable devices;
    private SubscriptionQueue subQueue;
    private NotifierQueue notifierQueue;
    private final String UPNP_EVENT_LISTENER_FLTR = "(objectClass=" + (class$org$osgi$service$upnp$UPnPEventListener == null ? (class$org$osgi$service$upnp$UPnPEventListener = MyCtrlPoint.class$("org.osgi.service.upnp.UPnPEventListener")) : class$org$osgi$service$upnp$UPnPEventListener).getName() + ")";
    private final String UPNP_DEVICE_FLTR = "(objectClass=" + (class$org$osgi$service$upnp$UPnPDevice == null ? (class$org$osgi$service$upnp$UPnPDevice = MyCtrlPoint.class$("org.osgi.service.upnp.UPnPDevice")) : class$org$osgi$service$upnp$UPnPDevice).getName() + ")";
    private final String EXPORT_FLTR = "(UPnP.export=*)";
    private final String IMPORT_FLTR = "(UPnP.device.imported=*)";
    static /* synthetic */ Class class$org$osgi$service$upnp$UPnPEventListener;
    static /* synthetic */ Class class$org$osgi$service$upnp$UPnPDevice;

    public MyCtrlPoint(BundleContext context, SubscriptionQueue subQueue, NotifierQueue notifierQueue) {
        this.context = context;
        this.devices = new Hashtable();
        this.addNotifyListener(this);
        this.addSearchResponseListener(this);
        try {
            context.addServiceListener((ServiceListener)this, this.UPNP_EVENT_LISTENER_FLTR);
        }
        catch (InvalidSyntaxException e) {
            e.printStackTrace();
        }
        this.subQueue = subQueue;
        this.notifierQueue = notifierQueue;
    }

    public void httpRequestRecieved(HTTPRequest httpReq) {
        Activator.logger.DEBUG("[Importer] httpRequestRecieved event");
        Activator.logger.PACKET(httpReq.toString());
        if (httpReq.isNotifyRequest()) {
            Activator.logger.DEBUG("[Importer] Notify Request");
            NotifyRequest notifyReq = new NotifyRequest(httpReq);
            String uuid = notifyReq.getSID();
            long seq = notifyReq.getSEQ();
            PropertyList props = notifyReq.getPropertyList();
            this.newEventArrived(uuid, seq, props);
            httpReq.returnOK();
            return;
        }
        Activator.logger.DEBUG("BAD Request");
        httpReq.returnBadRequest();
    }

    public void removeExpiredDevices() {
        DeviceList devList = this.getDeviceList();
        int devCnt = devList.size();
        for (int n = 0; n < devCnt; ++n) {
            Device dev = devList.getDevice(n);
            if (!dev.isExpired()) continue;
            Activator.logger.DEBUG("[Importer] Expired device:" + dev.getFriendlyName());
            this.removeDevice(dev);
            this.removeOSGiExpireDevice(dev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deviceNotifyReceived(SSDPPacket ssdpPacket) {
        UPnPDevice dev;
        Activator.logger.DEBUG("[Importer] deviceNotifyReceived");
        Activator.logger.PACKET(ssdpPacket.toString());
        String usn = ssdpPacket.getUSN();
        ParseUSN parseUSN = new ParseUSN(usn);
        String udn = parseUSN.getUDN();
        ServiceReference[] refs = null;
        String filter = "(&" + this.UPNP_DEVICE_FLTR + "(UPnP.export=*)" + ")";
        try {
            refs = this.context.getServiceReferences((class$org$osgi$service$upnp$UPnPDevice == null ? (class$org$osgi$service$upnp$UPnPDevice = MyCtrlPoint.class$("org.osgi.service.upnp.UPnPDevice")) : class$org$osgi$service$upnp$UPnPDevice).getName(), filter);
        }
        catch (InvalidSyntaxException e) {
            e.printStackTrace();
        }
        if (refs != null) {
            for (int i = 0; i < refs.length; ++i) {
                dev = (UPnPDevice)this.context.getService(refs[i]);
                Dictionary dic = dev.getDescriptions(null);
                if (!((String)dic.get("UPnP.device.UDN")).equals(udn)) continue;
                return;
            }
        }
        if (ssdpPacket.isAlive()) {
            Activator.logger.DEBUG("[Importer] ssdpPacket.isAlive");
            if (this.devices.containsKey(udn)) {
                Activator.logger.DEBUG("[Importer] Device already discovered");
                if (parseUSN.isService()) {
                    this.doServiceUpdating(udn, parseUSN.getServiceType());
                }
            } else {
                this.doDeviceRegistration(udn);
            }
        } else if (ssdpPacket.isByeBye()) {
            Activator.logger.DEBUG("[Importer] ssdpPacket.isByeBye");
            Hashtable hashtable = this.devices;
            synchronized (hashtable) {
                if (this.devices.containsKey(udn)) {
                    if (parseUSN.isDevice()) {
                        Activator.logger.DEBUG("[Importer] parseUSN.isDevice ...unregistering all the children devices ");
                        dev = ((OSGiDeviceInfo)this.devices.get(udn)).getOSGiDevice();
                        this.removeOSGiandUPnPDeviceHierarchy((UPnPDeviceImpl)dev);
                    } else if (parseUSN.isService()) {
                        Activator.logger.DEBUG("[Importer] parseUSN.isService ...registering modified device again ");
                        UPnPDeviceImpl device = ((OSGiDeviceInfo)this.devices.get(udn)).getOSGiDevice();
                        ServiceRegistration registar = ((OSGiDeviceInfo)this.devices.get(udn)).getRegistration();
                        String[] oldServicesID = (String[])device.getDescriptions(null).get("UPnP.service.id");
                        String[] oldServiceType = (String[])device.getDescriptions(null).get("UPnP.service.type");
                        Device cyberDevice = this.findDeviceCtrl(this, udn);
                        Vector<String> vec = new Vector<String>();
                        for (int i = 0; i < oldServiceType.length; ++i) {
                            Service ser = cyberDevice.getService(oldServicesID[i]);
                            if (ser.getServiceType().equals(parseUSN.getServiceType())) continue;
                            vec.add(oldServicesID[i]);
                        }
                        String[] actualServicesID = new String[vec.size()];
                        actualServicesID = vec.toArray(new String[0]);
                        String[] actualServiceType = new String[oldServiceType.length - 1];
                        vec.clear();
                        for (int i = 0; i < oldServiceType.length; ++i) {
                            if (oldServiceType[i].equals(parseUSN.getServiceType())) continue;
                            vec.add(oldServiceType[i]);
                        }
                        actualServiceType = vec.toArray(new String[0]);
                        this.unregisterUPnPDevice(registar);
                        device.setProperty("UPnP.service.id", actualServicesID);
                        device.setProperty("UPnP.service.type", actualServiceType);
                        this.registerUPnPDevice(null, device, device.getDescriptions(null));
                        this.searchForListener(cyberDevice);
                    }
                }
            }
        }
    }

    public synchronized void removeOSGiandUPnPDeviceHierarchy(UPnPDeviceImpl dev) {
        String udn = (String)dev.getDescriptions(null).get("UPnP.device.UDN");
        if (!this.devices.containsKey(udn)) {
            Activator.logger.INFO("Device " + dev.getDescriptions(null).get("UPnP.device.friendlyName") + "(" + udn + ") already removed");
            return;
        }
        String[] childrenUDN = (String[])dev.getDescriptions(null).get("UPnP.device.childrenUDN");
        if (childrenUDN == null) {
            this.unregisterUPnPDevice(((OSGiDeviceInfo)this.devices.get(udn)).getRegistration());
            Activator.logger.INFO("Device " + dev.getDescriptions(null).get("UPnP.device.friendlyName") + "(" + udn + ") deleted");
            this.devices.remove(udn);
            return;
        }
        for (int i = 0; i < childrenUDN.length; ++i) {
            if (this.devices.get(childrenUDN[i]) == null) continue;
            this.removeOSGiandUPnPDeviceHierarchy(((OSGiDeviceInfo)this.devices.get(childrenUDN[i])).getOSGiDevice());
        }
        this.unregisterUPnPDevice(((OSGiDeviceInfo)this.devices.get(udn)).getRegistration());
        Activator.logger.INFO("Device " + dev.getDescriptions(null).get("UPnP.device.friendlyName") + "(" + udn + ") deleted");
        this.devices.remove(udn);
    }

    public synchronized void removeOSGiExpireDevice(Device dev) {
        this.removeOSGiandUPnPDeviceHierarchy(((OSGiDeviceInfo)this.devices.get(dev.getUDN())).getOSGiDevice());
    }

    public void registerUPnPDevice(Device dev, UPnPDeviceImpl upnpDev, Dictionary prop) {
        if (prop == null && upnpDev == null) {
            UPnPDeviceImpl newDevice = new UPnPDeviceImpl(dev, this.context);
            ServiceRegistration registration = this.context.registerService((class$org$osgi$service$upnp$UPnPDevice == null ? (class$org$osgi$service$upnp$UPnPDevice = MyCtrlPoint.class$("org.osgi.service.upnp.UPnPDevice")) : class$org$osgi$service$upnp$UPnPDevice).getName(), (Object)newDevice, newDevice.getDescriptions(null));
            OSGiDeviceInfo deviceInfo = new OSGiDeviceInfo(newDevice, registration);
            String udn = (String)newDevice.getDescriptions(null).get("UPnP.device.UDN");
            this.devices.put(udn, deviceInfo);
        } else {
            ServiceRegistration registration = this.context.registerService((class$org$osgi$service$upnp$UPnPDevice == null ? (class$org$osgi$service$upnp$UPnPDevice = MyCtrlPoint.class$("org.osgi.service.upnp.UPnPDevice")) : class$org$osgi$service$upnp$UPnPDevice).getName(), (Object)upnpDev, prop);
            OSGiDeviceInfo deviceInfo = new OSGiDeviceInfo(upnpDev, registration);
            this.devices.put(upnpDev.getDescriptions(null).get("UPnP.device.UDN"), deviceInfo);
        }
    }

    public void unregisterUPnPDevice(ServiceRegistration registration) {
        registration.unregister();
    }

    public Device findDeviceCtrl(ControlPoint ctrl, String udn) {
        DeviceList devList = this.getDeviceList();
        Device dev = null;
        for (int i = 0; i < devList.size() && dev == null; ++i) {
            if (devList.getDevice(i).getUDN().equals(udn)) {
                dev = devList.getDevice(i);
                return dev;
            }
            dev = this.findDevice(udn, devList.getDevice(i));
        }
        return dev;
    }

    public Device findDevice(String udn, Device dev) {
        DeviceList devList = dev.getDeviceList();
        Device aux = null;
        for (int i = 0; i < devList.size(); ++i) {
            if (devList.getDevice(i).getUDN().equals(udn)) {
                return devList.getDevice(i);
            }
            aux = this.findDevice(udn, devList.getDevice(i));
            if (aux == null) continue;
            return aux;
        }
        return null;
    }

    public void deviceSearchResponseReceived(SSDPPacket ssdpPacket) {
        Activator.logger.DEBUG("[Importer] deviceSearchResponseReceived");
        Activator.logger.PACKET(ssdpPacket.toString());
        String usn = ssdpPacket.getUSN();
        ParseUSN parseUSN = new ParseUSN(usn);
        String udn = parseUSN.getUDN();
        ServiceReference[] refs = null;
        String filter = "(&" + this.UPNP_DEVICE_FLTR + "(UPnP.export=*)" + ")";
        try {
            refs = this.context.getServiceReferences((class$org$osgi$service$upnp$UPnPDevice == null ? (class$org$osgi$service$upnp$UPnPDevice = MyCtrlPoint.class$("org.osgi.service.upnp.UPnPDevice")) : class$org$osgi$service$upnp$UPnPDevice).getName(), filter);
        }
        catch (InvalidSyntaxException e) {
            e.printStackTrace();
        }
        if (refs != null) {
            for (int i = 0; i < refs.length; ++i) {
                UPnPDevice dev = (UPnPDevice)this.context.getService(refs[i]);
                Dictionary dic = dev.getDescriptions(null);
                if (!((String)dic.get("UPnP.device.UDN")).equals(udn)) continue;
                return;
            }
        }
        if (this.devices.containsKey(udn)) {
            Activator.logger.DEBUG("[Importer] Device already discovered");
            if (parseUSN.isService()) {
                this.doServiceUpdating(udn, parseUSN.getServiceType());
            }
        } else {
            this.doDeviceRegistration(udn);
        }
    }

    public void serviceChanged(ServiceEvent event) {
        Activator.logger.DEBUG("[Importer] serviceChanged");
        Activator.logger.DEBUG("Event::" + event.toString());
        if (event.getType() == 1) {
            ServiceReference serRef = event.getServiceReference();
            Object obj = serRef.getProperty("upnp.filter");
            ServiceReference[] devicesRefs = null;
            if (obj != null) {
                Filter filter = (Filter)obj;
                String filtra = filter.toString();
                String newfilter = "(&" + filtra + "(UPnP.device.imported=*)" + ")";
                try {
                    devicesRefs = this.context.getServiceReferences((class$org$osgi$service$upnp$UPnPDevice == null ? (class$org$osgi$service$upnp$UPnPDevice = MyCtrlPoint.class$("org.osgi.service.upnp.UPnPDevice")) : class$org$osgi$service$upnp$UPnPDevice).getName(), newfilter);
                }
                catch (InvalidSyntaxException e) {
                    e.printStackTrace();
                }
                if (devicesRefs != null) {
                    Hashtable dic = new Hashtable();
                    for (int i = 0; i < devicesRefs.length; ++i) {
                        UPnPDevice device = (UPnPDevice)this.context.getService(devicesRefs[i]);
                        ((Dictionary)dic).put("UPnP.device.UDN", device.getDescriptions(null).get("UPnP.device.UDN"));
                        ((Dictionary)dic).put("UPnP.device.type", device.getDescriptions(null).get("UPnP.device.type"));
                        UPnPService[] services = device.getServices();
                        if (services != null) {
                            for (int j = 0; j < services.length; ++j) {
                                ((Dictionary)dic).put("UPnP.service.id", services[j].getId());
                                ((Dictionary)dic).put("UPnP.service.type", services[j].getType());
                                UPnPStateVariable[] stateVars = services[j].getStateVariables();
                                boolean hasEventedVars = false;
                                for (int k = 0; k < stateVars.length && !hasEventedVars; ++k) {
                                    hasEventedVars = stateVars[k].sendsEvents();
                                    if (!hasEventedVars || !filter.match(dic)) continue;
                                    UPnPEventListener listener = (UPnPEventListener)this.context.getService(serRef);
                                    FirstMessage msg = new FirstMessage(((UPnPServiceImpl)services[j]).getCyberService(), listener);
                                    this.subQueue.enqueue(msg);
                                }
                            }
                        }
                        this.context.ungetService(devicesRefs[i]);
                    }
                }
            } else {
                try {
                    String newfilter = "(!(UPnP.export=*))";
                    devicesRefs = this.context.getServiceReferences((class$org$osgi$service$upnp$UPnPDevice == null ? (class$org$osgi$service$upnp$UPnPDevice = MyCtrlPoint.class$("org.osgi.service.upnp.UPnPDevice")) : class$org$osgi$service$upnp$UPnPDevice).getName(), newfilter);
                }
                catch (InvalidSyntaxException e) {
                    e.printStackTrace();
                }
                if (devicesRefs != null) {
                    for (int i = 0; i < devicesRefs.length; ++i) {
                        UPnPDevice device = (UPnPDevice)this.context.getService(devicesRefs[i]);
                        UPnPService[] services = device.getServices();
                        if (services != null) {
                            for (int j = 0; j < services.length; ++j) {
                                UPnPStateVariable[] stateVars = services[j].getStateVariables();
                                boolean bool = false;
                                for (int k = 0; k < stateVars.length && !(bool = stateVars[k].sendsEvents()); ++k) {
                                }
                                if (!bool) continue;
                                UPnPEventListener listener = (UPnPEventListener)this.context.getService(serRef);
                                FirstMessage msg = new FirstMessage(((UPnPServiceImpl)services[j]).getCyberService(), listener);
                                this.subQueue.enqueue(msg);
                            }
                        }
                        this.context.ungetService(devicesRefs[i]);
                    }
                }
            }
        } else if (event.getType() == 2) {
            Vector<Service> newServices = new Vector<Service>();
            ServiceReference serRef = event.getServiceReference();
            Filter filter = (Filter)serRef.getProperty("upnp.filter");
            UPnPEventListener listener = (UPnPEventListener)this.context.getService(serRef);
            ServiceReference[] devicesRefs = null;
            if (filter != null) {
                try {
                    String filtra = filter.toString();
                    String newfilter = "(&" + filtra + "(!" + "(UPnP.export=*)" + ")" + ")";
                    devicesRefs = this.context.getServiceReferences((class$org$osgi$service$upnp$UPnPDevice == null ? (class$org$osgi$service$upnp$UPnPDevice = MyCtrlPoint.class$("org.osgi.service.upnp.UPnPDevice")) : class$org$osgi$service$upnp$UPnPDevice).getName(), newfilter);
                }
                catch (InvalidSyntaxException e) {
                    e.printStackTrace();
                }
                if (devicesRefs != null) {
                    Hashtable dic = new Hashtable();
                    for (int i = 0; i < devicesRefs.length; ++i) {
                        UPnPDevice device = (UPnPDevice)this.context.getService(devicesRefs[i]);
                        ((Dictionary)dic).put("UPnP.device.UDN", device.getDescriptions(null).get("UPnP.device.UDN"));
                        ((Dictionary)dic).put("UPnP.device.type", device.getDescriptions(null).get("UPnP.device.type"));
                        UPnPService[] services = device.getServices();
                        if (services != null) {
                            for (int j = 0; j < services.length; ++j) {
                                boolean bool;
                                ((Dictionary)dic).put("UPnP.service.id", services[j].getId());
                                ((Dictionary)dic).put("UPnP.service.type", services[j].getType());
                                UPnPStateVariable[] stateVars = services[j].getStateVariables();
                                boolean hasEventedVars = false;
                                for (int k = 0; k < stateVars.length && !(hasEventedVars = stateVars[k].sendsEvents()); ++k) {
                                }
                                if (!hasEventedVars || !(bool = filter.match(dic))) continue;
                                newServices.add(((UPnPServiceImpl)services[j]).getCyberService());
                            }
                        }
                        this.context.ungetService(devicesRefs[i]);
                    }
                    ListenerModified msg = new ListenerModified(newServices, listener);
                    this.subQueue.enqueue(msg);
                }
            } else {
                try {
                    String newfilter = "(!(UPnP.export=*))";
                    devicesRefs = this.context.getServiceReferences((class$org$osgi$service$upnp$UPnPDevice == null ? (class$org$osgi$service$upnp$UPnPDevice = MyCtrlPoint.class$("org.osgi.service.upnp.UPnPDevice")) : class$org$osgi$service$upnp$UPnPDevice).getName(), newfilter);
                }
                catch (InvalidSyntaxException e) {
                    e.printStackTrace();
                }
                if (devicesRefs != null) {
                    for (int i = 0; i < devicesRefs.length; ++i) {
                        UPnPDevice device = (UPnPDevice)this.context.getService(devicesRefs[i]);
                        UPnPService[] services = device.getServices();
                        if (services != null) {
                            for (int j = 0; j < services.length; ++j) {
                                UPnPStateVariable[] stateVars = services[j].getStateVariables();
                                boolean hasEventedVars = false;
                                for (int k = 0; k < stateVars.length && !(hasEventedVars = stateVars[k].sendsEvents()); ++k) {
                                }
                                if (!hasEventedVars) continue;
                                newServices.add(((UPnPServiceImpl)services[j]).getCyberService());
                            }
                        }
                        this.context.ungetService(devicesRefs[i]);
                    }
                    this.subQueue.enqueue(new ListenerModified(newServices, listener));
                }
            }
        } else if (event.getType() == 4) {
            UPnPEventListener listener = (UPnPEventListener)this.context.getService(event.getServiceReference());
            if (listener != null) {
                ListenerUnRegistration msg = new ListenerUnRegistration(listener);
                this.subQueue.enqueue(msg);
            }
            this.context.ungetService(event.getServiceReference());
        }
    }

    public Service serviceFromSid(String sid) {
        Enumeration e = this.devices.elements();
        Service cyberService = null;
        while (e.hasMoreElements()) {
            int i;
            OSGiDeviceInfo deviceinfo = (OSGiDeviceInfo)e.nextElement();
            UPnPDeviceImpl device = deviceinfo.getOSGiDevice();
            UPnPService[] services = device.getServices();
            UPnPServiceImpl[] servicesImpl = new UPnPServiceImpl[services.length];
            for (i = 0; i < servicesImpl.length; ++i) {
                servicesImpl[i] = (UPnPServiceImpl)services[i];
            }
            for (i = 0; i < servicesImpl.length; ++i) {
                cyberService = servicesImpl[i].getCyberService();
                boolean bool = cyberService.isSubscribed();
                if (!bool || !cyberService.getSID().equals(sid)) continue;
                return cyberService;
            }
        }
        return null;
    }

    public void newEventArrived(String uuid, long seq, PropertyList props) {
        Activator.logger.DEBUG("[Importer] newEventArrived");
        Service service = this.serviceFromSid(uuid);
        if (service != null) {
            int size = props.size();
            Hashtable<String, Object> hash = new Hashtable<String, Object>();
            for (int i = 0; i < size; ++i) {
                Object valueObj;
                Property prop = props.getProperty(i);
                String varName = prop.getName();
                String varValue = prop.getValue();
                String upnpType = service.getStateVariable(varName).getDataType();
                try {
                    valueObj = Converter.parseString(varValue, upnpType);
                }
                catch (Exception e) {
                    Activator.logger.ERROR("[Importer] Bad data value in Notify event: var name=" + varName + " value=" + varValue + " type=" + upnpType + "\n" + e);
                    return;
                }
                hash.put(varName, valueObj);
            }
            Device device = service.getDevice();
            StateChanged msg = new StateChanged(uuid, seq, hash, device, service);
            this.notifierQueue.enqueue(msg);
        }
    }

    public void doServiceUpdating(String udn, String serviceType) {
        Activator.logger.DEBUG("[Importer] check for service updating");
        OSGiDeviceInfo deviceinfo = (OSGiDeviceInfo)this.devices.get(udn);
        UPnPDeviceImpl device = deviceinfo.getOSGiDevice();
        boolean isSerPresent = device.existServiceType(serviceType);
        if (!isSerPresent) {
            ServiceRegistration registar = ((OSGiDeviceInfo)this.devices.remove(udn)).getRegistration();
            String[] oldServicesID = (String[])device.getDescriptions(null).get("UPnP.service.id");
            String[] oldServicesType = (String[])device.getDescriptions(null).get("UPnP.service.type");
            Device cyberDevice = this.findDeviceCtrl(this, udn);
            ServiceList serviceList = cyberDevice.getServiceList();
            ArrayList<String> newServicesID = new ArrayList<String>();
            for (int i = 0; i < serviceList.size(); ++i) {
                if (!serviceList.getService(i).getServiceType().equals(serviceType)) continue;
                newServicesID.add(serviceList.getService(i).getServiceID());
            }
            String[] currentServicesID = new String[oldServicesID.length + newServicesID.size()];
            int endOld = 1;
            for (int i = 0; i < oldServicesID.length; ++i) {
                currentServicesID[i] = oldServicesID[i];
                ++endOld;
            }
            int j = 0;
            while (endOld < currentServicesID.length) {
                currentServicesID[endOld] = (String)newServicesID.get(j);
                ++j;
                ++endOld;
            }
            String[] currentServicesType = new String[oldServicesType.length + 1];
            for (int i = 0; i < oldServicesType.length; ++i) {
                currentServicesType[i] = oldServicesType[i];
            }
            currentServicesType[currentServicesType.length - 1] = serviceType;
            this.unregisterUPnPDevice(registar);
            device.setProperty("UPnP.service.id", currentServicesID);
            device.setProperty("UPnP.service.type", currentServicesType);
            this.registerUPnPDevice(null, device, device.getDescriptions(null));
            this.searchForListener(cyberDevice);
        }
    }

    public void doDeviceRegistration(String udn, boolean checkDouble) {
        if (checkDouble) {
            try {
                ServiceReference[] refs = Activator.bc.getServiceReferences((class$org$osgi$service$upnp$UPnPDevice == null ? (class$org$osgi$service$upnp$UPnPDevice = MyCtrlPoint.class$("org.osgi.service.upnp.UPnPDevice")) : class$org$osgi$service$upnp$UPnPDevice).getName(), "(UPnP.device.UDN=" + udn + ")");
                if (refs != null) {
                    return;
                }
            }
            catch (InvalidSyntaxException invalidSyntaxException) {
                // empty catch block
            }
        }
        this.doDeviceRegistration(udn);
    }

    public synchronized void doDeviceRegistration(String udn) {
        Device dev = this.findDeviceCtrl(this, udn);
        if (dev == null) {
            Activator.logger.INFO("Cyberlink notified packet from UDN:" + udn + ", but Device instance doesn't exist in Cyberlink structs! It will be Ignored");
        } else if (!this.devices.containsKey(udn)) {
            Activator.logger.INFO("[Importer] registering UPnPDevice:" + dev.getFriendlyName() + "(" + dev.getUDN() + ")");
            this.registerUPnPDevice(dev, null, null);
            this.searchForListener(dev);
            Iterator i = dev.getDeviceList().iterator();
            while (i.hasNext()) {
                Device d = (Device)i.next();
                this.doDeviceRegistration(d.getUDN(), true);
            }
        } else if (this.devices.containsKey(udn)) {
            Activator.logger.INFO("[Importer] UPnPDevice UDN::" + dev.getFriendlyName() + "(" + dev.getUDN() + ") already registered Skipping");
        }
    }

    public void searchForListener(Device device) {
        Activator.logger.DEBUG("[Importer] searching for UPnPEventListener");
        ServiceReference[] listeners = null;
        try {
            listeners = this.context.getServiceReferences((class$org$osgi$service$upnp$UPnPEventListener == null ? (class$org$osgi$service$upnp$UPnPEventListener = MyCtrlPoint.class$("org.osgi.service.upnp.UPnPEventListener")) : class$org$osgi$service$upnp$UPnPEventListener).getName(), null);
        }
        catch (InvalidSyntaxException e) {
            e.printStackTrace();
        }
        if (listeners != null) {
            int j;
            int i;
            String deviceID = device.getUDN();
            String deviceType = device.getDeviceType();
            Hashtable<String, String> hash = new Hashtable<String, String>();
            hash.put("UPnP.device.UDN", deviceID);
            hash.put("UPnP.device.type", deviceType);
            ServiceList services = device.getServiceList();
            Vector<Service> eventedSers = new Vector<Service>();
            block2: for (i = 0; i < services.size(); ++i) {
                Service service = (Service)services.elementAt(i);
                ServiceStateTable vars = service.getServiceStateTable();
                for (j = 0; j < vars.size(); ++j) {
                    StateVariable var = (StateVariable)vars.elementAt(j);
                    if (!var.isSendEvents()) continue;
                    eventedSers.add(service);
                    continue block2;
                }
            }
            for (i = 0; i < listeners.length; ++i) {
                Service ser;
                UPnPEventListener listener = (UPnPEventListener)this.context.getService(listeners[i]);
                Filter filter = (Filter)listeners[i].getProperty("upnp.filter");
                if (filter == null) {
                    for (j = 0; j < eventedSers.size(); ++j) {
                        ser = (Service)eventedSers.elementAt(j);
                        this.subQueue.enqueue(new FirstMessage(ser, listener));
                    }
                    continue;
                }
                for (j = 0; j < eventedSers.size(); ++j) {
                    ser = (Service)eventedSers.elementAt(j);
                    String serviceID = ser.getServiceID();
                    String serviceType = ser.getServiceType();
                    hash.put("UPnP.service.id", serviceID);
                    hash.put("UPnP.service.type", serviceType);
                    boolean bool = filter.match(hash);
                    if (!bool) continue;
                    this.subQueue.enqueue(new FirstMessage(ser, listener));
                }
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

