/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.handlers.event;

import org.apache.felix.ipojo.parser.ParseUtils;

public class EventUtil {
    public static final String TOPIC_SEPARATOR = ",";
    public static final String TOPIC_TOKEN_SEPARATOR = "/";
    private static final String TOKEN_ALPHABET = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789_-";

    public static final boolean matches(String topic, String topicPattern) {
        if (topicPattern.equals("*")) {
            return true;
        }
        int star = topicPattern.indexOf("*");
        if (star > 0) {
            return topic.startsWith(topicPattern.substring(0, star - 1));
        }
        return topic.equals(topicPattern);
    }

    public static final boolean matches(String topic, String[] topicPatterns) {
        int n = topicPatterns.length;
        for (int i = 0; i < n; ++i) {
            if (!EventUtil.matches(topic, topicPatterns[i])) continue;
            return true;
        }
        return false;
    }

    public static final boolean isValidTopicScope(String topicScope) {
        if (topicScope.equals("*")) {
            return true;
        }
        String topicWithoutWildcard = topicScope.endsWith("/*") ? topicScope.substring(0, topicScope.length() - 2) : topicScope;
        return EventUtil.isValidTopic(topicWithoutWildcard);
    }

    public static final boolean isValidTopic(String topic) {
        if (topic.startsWith(TOPIC_TOKEN_SEPARATOR) || topic.endsWith(TOPIC_TOKEN_SEPARATOR)) {
            return false;
        }
        String[] tokens = ParseUtils.split((String)topic, (String)TOPIC_TOKEN_SEPARATOR);
        if (tokens.length < 1) {
            return false;
        }
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (EventUtil.isValidToken(token)) continue;
            return false;
        }
        return true;
    }

    private static boolean isValidToken(String token) {
        int length = token.length();
        if (length < 1) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (TOKEN_ALPHABET.indexOf(token.charAt(i)) != -1) continue;
            return false;
        }
        return true;
    }
}

