/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.atomos.utils.core.plugins.finaliser.shade;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.zip.Adler32;

public class ShadePreHolder {
    private String name;
    private final Map<Long, List<JarFile>> source = new HashMap<Long, List<JarFile>>();

    private ShadePreHolder() {
    }

    public ShadePreHolder(String name) {
        this();
        this.name = name;
    }

    void add(JarFile jarFile) {
        byte[] bytes;
        JarEntry entry = jarFile.getJarEntry(this.name);
        try {
            bytes = jarFile.getInputStream(entry).readAllBytes();
        }
        catch (IOException e) {
            bytes = new byte[]{};
        }
        Adler32 checksum = new Adler32();
        checksum.update(bytes, 0, bytes.length);
        long checksumVal = checksum.getValue();
        List list = this.source.computeIfAbsent(checksumVal, k -> new ArrayList());
        list.add(jarFile);
    }

    List<JarFile> all() {
        return this.source.entrySet().stream().flatMap(c -> ((List)c.getValue()).stream()).collect(Collectors.toList());
    }

    boolean allSameChecksum() {
        return this.source.size() == 1;
    }

    JarFile any() {
        return (JarFile)this.source.entrySet().stream().map(c -> ((List)c.getValue()).stream().findAny()).findAny().get().get();
    }

    public String getName() {
        return this.name;
    }

    public Map<Long, List<JarFile>> getSource() {
        return Map.copyOf(this.source);
    }

    long size() {
        return this.source.entrySet().stream().flatMap(c -> ((List)c.getValue()).stream()).count();
    }
}

