/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.jsf2.controls;

import java.io.IOException;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.html.HtmlInputTextarea;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseId;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.exceptions.InvalidArgumentException;
import org.apache.empire.exceptions.UnexpectedReturnValueException;
import org.apache.empire.jsf2.controls.InputControl;
import org.apache.empire.jsf2.controls.InputControlManager;
import org.apache.empire.jsf2.utils.StyleClass;

public class TextAreaInputControl
extends InputControl {
    public static final String NAME = "textarea";
    public static final String FORMAT_COLS = "cols:";
    public static final String FORMAT_COLS_ATTRIBUTE = "format:cols";
    public static final String FORMAT_ROWS = "rows:";
    public static final String FORMAT_ROWS_ATTRIBUTE = "format:rows";
    private Class<? extends HtmlInputTextarea> inputComponentClass;

    public TextAreaInputControl(String name, Class<? extends HtmlInputTextarea> inputComponentClass) {
        super(name);
        this.inputComponentClass = inputComponentClass;
    }

    public TextAreaInputControl() {
        this(NAME, HtmlInputTextarea.class);
    }

    @Override
    public void renderValue(UIComponent comp, String tagName, StyleClass styleClass, String tooltip, InputControl.ValueInfo vi, FacesContext context) throws IOException {
        if (styleClass != null) {
            int rows;
            styleClass.add(NAME);
            int cols = this.getFormatInteger(vi, FORMAT_COLS, FORMAT_COLS_ATTRIBUTE);
            if (cols > 0) {
                styleClass.add("cols-" + String.valueOf(cols));
            }
            if ((rows = this.getFormatInteger(vi, FORMAT_ROWS, FORMAT_ROWS_ATTRIBUTE)) > 0) {
                styleClass.add("rows-" + String.valueOf(rows));
            }
        }
        super.renderValue(comp, tagName, styleClass, tooltip, vi, context);
    }

    @Override
    protected void createInputComponents(UIComponent parent, InputControl.InputInfo ii, FacesContext context, List<UIComponent> compList) {
        int rows;
        if (!compList.isEmpty()) {
            throw new InvalidArgumentException("compList", compList);
        }
        HtmlInputTextarea input = InputControlManager.createComponent(context, this.inputComponentClass);
        this.copyAttributes(parent, ii, (UIInput)input);
        int cols = this.getFormatInteger(ii, FORMAT_COLS, FORMAT_COLS_ATTRIBUTE);
        if (cols > 0) {
            input.setCols(cols);
            input.setStyleClass(input.getStyleClass() + " cols-" + String.valueOf(cols));
        }
        if ((rows = this.getFormatInteger(ii, FORMAT_ROWS, FORMAT_ROWS_ATTRIBUTE)) > 0) {
            input.setRows(rows);
            input.setStyleClass(input.getStyleClass() + " rows-" + String.valueOf(rows));
        }
        compList.add((UIComponent)input);
        this.updateInputState(compList, ii, context, PhaseId.RENDER_RESPONSE);
    }

    @Override
    protected void updateInputState(List<UIComponent> compList, InputControl.InputInfo ii, FacesContext context, PhaseId phaseId) {
        UIComponent comp = compList.get(0);
        if (!(comp instanceof HtmlInputTextarea)) {
            throw new UnexpectedReturnValueException((Object)comp.getClass().getName(), "compList.get(0)");
        }
        HtmlInputTextarea input = (HtmlInputTextarea)comp;
        InputControl.DisabledType disabled = ii.getDisabled();
        input.setReadonly(disabled == InputControl.DisabledType.READONLY);
        input.setDisabled(disabled == InputControl.DisabledType.DISABLED);
        if (phaseId == PhaseId.RENDER_RESPONSE) {
            this.setInputStyleClass((UIInput)input, ii);
            this.setInputValue((UIInput)input, ii);
        }
    }

    @Override
    public String formatValue(Object value, InputControl.ValueInfo vi, boolean escapeHtml) {
        String strVal = super.formatValue(value, vi, escapeHtml);
        if (!escapeHtml) {
            return strVal;
        }
        if (strVal.indexOf("\r\n") > 0) {
            strVal = StringUtils.replace((String)strVal, (String)"\r\n", (String)"<BR/>\n");
        } else if (strVal.indexOf(10) > 0) {
            strVal = StringUtils.replace((String)strVal, (String)"\n", (String)"<BR/>\n");
        }
        return strVal;
    }

    @Override
    protected Object parseInputValue(String value, InputControl.InputInfo ii) {
        if (!this.hasFormatOption(ii, "notrim")) {
            value = value.trim();
        }
        return value;
    }
}

