/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.jsf2.utils;

import javax.el.ValueExpression;
import javax.el.VariableMapper;
import javax.faces.FacesWrapper;
import org.apache.empire.commons.ClassUtils;
import org.apache.empire.commons.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValueExpressionUnwrapper {
    private static final Logger log = LoggerFactory.getLogger(ValueExpressionUnwrapper.class);
    private static ValueExpressionUnwrapper instance = null;

    public static synchronized ValueExpressionUnwrapper getInstance() {
        if (instance == null) {
            instance = new ValueExpressionUnwrapper();
        }
        return instance;
    }

    public static synchronized void setInstance(ValueExpressionUnwrapper instance) {
        ValueExpressionUnwrapper.instance = instance;
    }

    protected ValueExpressionUnwrapper() {
        log.debug("Instance of {} created", (Object)this.getClass().getName());
    }

    public ValueExpression unwrap(ValueExpression ve, String exprPrefix) {
        String expression;
        if (ve != null && !ve.isLiteralText() && (expression = ve.getExpressionString()).startsWith(exprPrefix)) {
            ValueExpression veImpl = ve;
            if (veImpl instanceof FacesWrapper) {
                veImpl = (ValueExpression)((FacesWrapper)veImpl).getWrapped();
            }
            if (veImpl.getClass().getName().equals("org.apache.el.ValueExpressionImpl")) {
                Object node = ClassUtils.invokeSimplePrivateMethod((Object)veImpl, (String)"getNode");
                if (node != null) {
                    String image = StringUtils.toString((Object)ClassUtils.invokeSimpleMethod((Object)node, (String)"getImage"));
                    if (StringUtils.isNotEmpty((String)image)) {
                        VariableMapper varMapper = (VariableMapper)ClassUtils.getPrivateFieldValue((Object)veImpl, (String)"varMapper");
                        if (varMapper != null) {
                            ve = varMapper.resolveVariable(image);
                            log.debug("EL-Expression \"{}\" has been resolved to variable \"{}\"", (Object)expression, (Object)(ve != null ? ve.getExpressionString() : null));
                        } else {
                            log.debug("EL-Expression \"{}\" has been resolved to NULL.", (Object)expression);
                            ve = null;
                        }
                    } else {
                        log.info("EL-Expression \"{}\" has unsupported Node type {}", (Object)expression, (Object)node.getClass().getName());
                    }
                } else {
                    log.warn("Unexpected: ValueExpressionImpl has no Node. Expression \"{}\" remains unchanged.");
                }
            } else {
                log.warn("Unexpected ValueExpression-Implementation: {}", (Object)ve.getClass().getName());
                log.warn("ValueExpression unwrapping does not work!");
            }
        }
        return ve;
    }
}

