/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.List;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.ResultColumnDescriptor;
import org.apache.derby.iapi.sql.ResultDescription;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.ConstantExpressionVisitor;
import org.apache.derby.impl.sql.compile.CursorNode;
import org.apache.derby.impl.sql.compile.FromBaseTable;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.HasNodeVisitor;
import org.apache.derby.impl.sql.compile.ParameterNode;
import org.apache.derby.impl.sql.compile.QueryTreeNode;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.ScrollInsensitiveResultSetNode;
import org.apache.derby.impl.sql.compile.StatementNode;
import org.apache.derby.impl.sql.compile.StaticMethodCallNode;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

abstract class DMLStatementNode
extends StatementNode {
    ResultSetNode resultSet;

    DMLStatementNode(ResultSetNode resultSet, ContextManager cm) {
        super(cm);
        this.resultSet = resultSet;
    }

    @Override
    void printSubNodes(int depth) {
        super.printSubNodes(depth);
        if (this.resultSet != null) {
            this.printLabel(depth, "resultSet: ");
            this.resultSet.treePrint(depth + 1);
        }
    }

    ResultSetNode getResultSetNode() {
        return this.resultSet;
    }

    QueryTreeNode bind(DataDictionary dataDictionary) throws StandardException {
        this.getCompilerContext().pushCurrentPrivType(this.getPrivType());
        try {
            this.bindTables(dataDictionary);
            this.bindExpressions();
        }
        finally {
            this.getCompilerContext().popCurrentPrivType();
        }
        return this;
    }

    QueryTreeNode bindResultSetsWithTables(DataDictionary dataDictionary) throws StandardException {
        this.bindTables(dataDictionary);
        this.bindExpressionsWithTables();
        return this;
    }

    protected void bindTables(DataDictionary dataDictionary) throws StandardException {
        boolean doJOO = this.getOptimizerFactory().doJoinOrderOptimization();
        ContextManager cm = this.getContextManager();
        this.resultSet = this.resultSet.bindNonVTITables(dataDictionary, new FromList(doJOO, cm));
        this.resultSet = this.resultSet.bindVTITables(new FromList(doJOO, cm));
    }

    protected void bindExpressions() throws StandardException {
        FromList fromList = new FromList(this.getOptimizerFactory().doJoinOrderOptimization(), this.getContextManager());
        this.resultSet.bindExpressions(fromList);
        SanityManager.ASSERT(fromList.size() == 0, "fromList.size() is expected to be 0, not " + fromList.size() + " on return from RS.bindExpressions()");
    }

    protected void bindExpressionsWithTables() throws StandardException {
        FromList fromList = new FromList(this.getOptimizerFactory().doJoinOrderOptimization(), this.getContextManager());
        this.resultSet.bindExpressionsWithTables(fromList);
        SanityManager.ASSERT(fromList.size() == 0, "fromList.size() is expected to be 0, not " + fromList.size() + " on return from RS.bindExpressions()");
    }

    @Override
    int activationKind() {
        List<ParameterNode> parameterList = this.getCompilerContext().getParameterList();
        if (parameterList != null && !parameterList.isEmpty()) {
            return 2;
        }
        return 1;
    }

    @Override
    public void optimizeStatement() throws StandardException {
        this.resultSet = this.resultSet.preprocess(this.getCompilerContext().getNumTables(), null, null);
        this.accept(new ConstantExpressionVisitor());
        this.resultSet = this.resultSet.optimize(this.getDataDictionary(), null, 1.0);
        this.resultSet = this.resultSet.modifyAccessPaths();
        if (this instanceof CursorNode) {
            ResultSetNode siChild = this.resultSet;
            ResultColumnList siRCList = this.resultSet.getResultColumns();
            ResultColumnList childRCList = siRCList.copyListAndObjects();
            this.resultSet.setResultColumns(childRCList);
            siRCList.genVirtualColumnNodes(this.resultSet, childRCList);
            this.resultSet = new ScrollInsensitiveResultSetNode(this.resultSet, siRCList, null, this.getContextManager());
            if (siChild.getReferencedTableMap() != null) {
                this.resultSet.setReferencedTableMap((JBitSet)siChild.getReferencedTableMap().clone());
            }
        }
    }

    @Override
    public ResultDescription makeResultDescription() {
        ResultColumnDescriptor[] colDescs = this.resultSet.makeResultDescriptors();
        String statementType = this.statementToString();
        return this.getExecutionFactory().getResultDescription(colDescs, statementType);
    }

    void generateParameterValueSet(ActivationClassBuilder acb) throws StandardException {
        int numberOfParameters;
        List<ParameterNode> parameterList = this.getCompilerContext().getParameterList();
        int n = numberOfParameters = parameterList == null ? 0 : parameterList.size();
        if (numberOfParameters <= 0) {
            return;
        }
        ParameterNode.generateParameterValueSet(acb, numberOfParameters, parameterList);
    }

    @Override
    public boolean isAtomic() throws StandardException {
        HasNodeVisitor visitor = new HasNodeVisitor(FromBaseTable.class, StaticMethodCallNode.class);
        this.accept(visitor);
        return visitor.hasNode();
    }

    @Override
    void acceptChildren(Visitor v) throws StandardException {
        super.acceptChildren(v);
        if (this.resultSet != null) {
            this.resultSet = (ResultSetNode)this.resultSet.accept(v);
        }
    }

    int getPrivType() {
        return 0;
    }
}

