/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.tools;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.apache.derby.iapi.tools.i18n.LocalizedResource;

public class SignatureChecker {
    private static final String WILDCARD = "%";
    private static final String[] SYSTEM_SCHEMAS = new String[]{"SQLJ", "SYSCS_UTIL", "SYSIBM"};
    private final ParsedArgs _parsedArgs;
    private final ArrayList<SQLRoutine> _procedures = new ArrayList();
    private final ArrayList<SQLRoutine> _functions = new ArrayList();
    private final boolean _debugging = false;
    private static LocalizedResource _messageFormatter;

    private SignatureChecker(ParsedArgs parsedArgs) {
        this._parsedArgs = parsedArgs;
    }

    public static void main(String[] args) {
        ParsedArgs parsedArgs = new ParsedArgs(args);
        if (!parsedArgs.isValid()) {
            SignatureChecker.printUsage();
            System.exit(1);
        } else {
            SignatureChecker me = new SignatureChecker(parsedArgs);
            me.execute();
        }
    }

    private void execute() {
        try {
            Connection conn = this.getJ2SEConnection();
            if (conn == null) {
                SignatureChecker.println(SignatureChecker.formatMessage("SC_NO_CONN", new Object[0]));
            } else {
                this.matchSignatures(conn);
                conn.close();
            }
        }
        catch (SQLException t) {
            SignatureChecker.printThrowable(t);
        }
    }

    private void matchSignatures(Connection conn) throws SQLException {
        this.matchProcedures(conn);
        this.matchFunctions(conn);
    }

    private void matchProcedures(Connection conn) throws SQLException {
        DatabaseMetaData dbmd = conn.getMetaData();
        this.findProcedures(dbmd);
        this.countProcedureArgs(dbmd);
        int count = this._procedures.size();
        for (int i = 0; i < count; ++i) {
            SQLRoutine procedure = this.getProcedure(i);
            StringBuilder buffer = new StringBuilder();
            int argCount = procedure.getArgCount();
            buffer.append("call ");
            buffer.append(procedure.getQualifiedName());
            buffer.append("( ");
            for (int k = 0; k < argCount; ++k) {
                if (k > 0) {
                    buffer.append(", ");
                }
                buffer.append(" ? ");
            }
            buffer.append(" )");
            this.checkSignature(conn, buffer.toString(), this.makeReadableSignature(procedure));
        }
    }

    private void matchFunctions(Connection conn) throws SQLException {
        DatabaseMetaData dbmd = conn.getMetaData();
        this.findFunctions(dbmd);
        this.countFunctionArgs(dbmd);
        int count = this._functions.size();
        for (int i = 0; i < count; ++i) {
            SQLRoutine function = this.getFunction(i);
            StringBuilder query = new StringBuilder();
            int argCount = function.getArgCount();
            if (function.isTableFunction()) {
                query.append("select * from table( ");
            } else {
                query.append("values(  ");
            }
            query.append(function.getQualifiedName());
            query.append("( ");
            for (int k = 0; k < argCount; ++k) {
                if (k > 0) {
                    query.append(", ");
                }
                query.append(" ? ");
            }
            query.append(" ) )");
            if (function.isTableFunction()) {
                query.append(" s");
            }
            this.checkSignature(conn, query.toString(), this.makeReadableSignature(function));
        }
    }

    private String makeReadableSignature(SQLRoutine routine) {
        StringBuilder signature = new StringBuilder();
        int argCount = routine.getArgCount();
        signature.append(routine.getQualifiedName());
        signature.append("( ");
        for (int k = 0; k < argCount; ++k) {
            if (k > 0) {
                signature.append(", ");
            }
            signature.append(" ");
            signature.append(routine.getArgType(k));
            signature.append(" ");
        }
        signature.append(" )");
        return signature.toString();
    }

    private void findProcedures(DatabaseMetaData dbmd) throws SQLException {
        ResultSet rs = dbmd.getProcedures(null, null, WILDCARD);
        while (rs.next()) {
            String schema = rs.getString(2);
            String name = rs.getString(3);
            if (this.isSystemSchema(schema)) continue;
            this.putProcedure(schema, name);
        }
        rs.close();
    }

    private void countProcedureArgs(DatabaseMetaData dbmd) throws SQLException {
        int count = this._procedures.size();
        for (int i = 0; i < count; ++i) {
            SQLRoutine procedure = this.getProcedure(i);
            ResultSet rs = dbmd.getProcedureColumns(null, procedure.getSchema(), procedure.getName(), WILDCARD);
            while (rs.next()) {
                procedure.addArg(rs.getString(7));
            }
            rs.close();
        }
    }

    private void findFunctions(DatabaseMetaData dbmd) throws SQLException {
        try {
            ResultSet rs = dbmd.getFunctions(null, null, WILDCARD);
            while (rs.next()) {
                String schema = rs.getString(2);
                String name = rs.getString(3);
                short functionType = rs.getShort(5);
                if (this.isSystemSchema(schema)) continue;
                boolean isTableFunction = functionType == 2;
                this.putFunction(schema, name, isTableFunction);
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new SQLException(e.getMessage());
        }
    }

    private void countFunctionArgs(DatabaseMetaData dbmd) throws SQLException {
        int count = this._functions.size();
        for (int i = 0; i < count; ++i) {
            SQLRoutine function = this.getFunction(i);
            ResultSet rs = dbmd.getFunctionColumns(null, function.getSchema(), function.getName(), WILDCARD);
            while (rs.next()) {
                short columnType = rs.getShort(5);
                if (columnType == 4 || columnType == 5) continue;
                function.addArg(rs.getString(7));
            }
            rs.close();
        }
    }

    private void checkSignature(Connection conn, String query, String readableSignature) {
        try {
            PreparedStatement ps = this.prepareStatement(conn, query);
            ps.close();
            SignatureChecker.println(SignatureChecker.formatMessage("SC_FOUND_MATCH", readableSignature));
        }
        catch (SQLException se) {
            SignatureChecker.println(SignatureChecker.formatMessage("SC_UNRESOLVABLE", readableSignature, se.getMessage()));
        }
    }

    private Connection getJ2SEConnection() throws SQLException {
        try {
            Class.forName("org.apache.derby.jdbc.EmbeddedDriver");
            Class.forName("org.apache.derby.jdbc.ClientDriver");
            Class.forName("java.sql.DriverManager");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            return DriverManager.getConnection(this._parsedArgs.getJ2seConnectionUrl());
        }
        catch (SQLException t) {
            SignatureChecker.printThrowable(t);
            return null;
        }
    }

    private PreparedStatement prepareStatement(Connection conn, String text) throws SQLException {
        return conn.prepareStatement(text);
    }

    private static void printUsage() {
        SignatureChecker.println(SignatureChecker.formatMessage("SC_USAGE", new Object[0]));
    }

    private static void printThrowable(Throwable t) {
        t.printStackTrace();
    }

    private static void println(String text) {
        System.out.println(text);
    }

    private boolean isSystemSchema(String schema) {
        int count = SYSTEM_SCHEMAS.length;
        for (int i = 0; i < count; ++i) {
            if (!SYSTEM_SCHEMAS[i].equals(schema)) continue;
            return true;
        }
        return false;
    }

    private void putProcedure(String schema, String name) {
        this._procedures.add(new SQLRoutine(this, schema, name, false));
    }

    private SQLRoutine getProcedure(int idx) {
        return this._procedures.get(idx);
    }

    private void putFunction(String schema, String name, boolean isTableFunction) {
        this._functions.add(new SQLRoutine(this, schema, name, isTableFunction));
    }

    private SQLRoutine getFunction(int idx) {
        return this._functions.get(idx);
    }

    private static String formatMessage(String key, Object ... args) {
        return SignatureChecker.getMessageFormatter().getTextMessage(key, args);
    }

    private static LocalizedResource getMessageFormatter() {
        if (_messageFormatter == null) {
            _messageFormatter = LocalizedResource.getInstance();
        }
        return _messageFormatter;
    }

    static class ParsedArgs {
        private boolean _isValid = false;
        private String _j2seConnectionUrl;

        public ParsedArgs(String[] args) {
            this.parseArgs(args);
        }

        public boolean isValid() {
            return this._isValid;
        }

        public String getJ2seConnectionUrl() {
            return this._j2seConnectionUrl;
        }

        private void parseArgs(String[] args) {
            if (args == null) {
                return;
            }
            if (args.length != 1) {
                return;
            }
            this._j2seConnectionUrl = args[0];
            this._isValid = true;
        }
    }

    class SQLRoutine {
        private final String _schema;
        private final String _name;
        private final boolean _isTableFunction;
        private final ArrayList<String> _argList = new ArrayList();

        public SQLRoutine(SignatureChecker this$0, String schema, String name, boolean isTableFunction) {
            this._schema = schema;
            this._name = name;
            this._isTableFunction = isTableFunction;
        }

        public void addArg(String typeName) {
            this._argList.add(typeName);
        }

        public String getSchema() {
            return this._schema;
        }

        public String getName() {
            return this._name;
        }

        public int getArgCount() {
            return this._argList.size();
        }

        public String getArgType(int idx) {
            return this._argList.get(idx);
        }

        public boolean isTableFunction() {
            return this._isTableFunction;
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder();
            buffer.append("SQLRoutine( ");
            buffer.append(this._schema);
            buffer.append(", ");
            buffer.append(this._name);
            buffer.append(", ");
            buffer.append("isTableFunction = ");
            buffer.append(this._isTableFunction);
            buffer.append(", ");
            buffer.append(" argCount = ");
            buffer.append(this.getArgCount());
            buffer.append(" )");
            return buffer.toString();
        }

        private String doubleQuote(String raw) {
            return "\"" + raw + "\"";
        }

        public String getQualifiedName() {
            return this.doubleQuote(this._schema) + "." + this.doubleQuote(this._name);
        }
    }
}

