/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbc4;

import java.lang.reflect.Method;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.transaction.xa.XAResource;
import junit.framework.Test;
import org.apache.derby.iapi.jdbc.BrokeredCallableStatement;
import org.apache.derby.iapi.jdbc.BrokeredPreparedStatement;
import org.apache.derby.iapi.jdbc.BrokeredStatement;
import org.apache.derbyTesting.functionTests.tests.jdbc4.StatementTest;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.J2EEDataSource;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class XA40Test
extends BaseJDBCTestCase {
    private XADataSource xads = null;
    private XAConnection xac = null;
    private XAResource xar = null;
    private Connection con = null;

    public XA40Test(String name) {
        super(name);
    }

    public void setUp() throws SQLException {
        this.xads = J2EEDataSource.getXADataSource();
        this.xac = this.xads.getXAConnection();
        this.xar = this.xac.getXAResource();
        this.con = this.xac.getConnection();
        XA40Test.assertFalse((String)"Connection must be open initially", (boolean)this.con.isClosed());
        this.con.setAutoCommit(false);
    }

    @Override
    protected void tearDown() throws Exception {
        if (this.con != null && !this.con.isClosed()) {
            this.con.rollback();
            this.con.close();
        }
        if (this.xac != null) {
            this.xac.close();
        }
        this.con = null;
        this.xads = null;
        this.xac = null;
        this.xar = null;
        super.tearDown();
    }

    public void testStatementPoolable() throws SQLException {
        Statement s = this.con.createStatement();
        if (XA40Test.usingEmbedded()) {
            XA40Test.assertTrue((String)("s must be an instance of BrokeredStatement, but is " + String.valueOf(s.getClass())), (boolean)(s instanceof BrokeredStatement));
        }
        XA40Test.assertFalse((String)"Statement must not be poolable by default", (boolean)s.isPoolable());
        s.setPoolable(true);
        XA40Test.assertTrue((String)"Statement must be poolable", (boolean)s.isPoolable());
        s.setPoolable(false);
        XA40Test.assertFalse((String)"Statement cannot be poolable", (boolean)s.isPoolable());
    }

    public void testPreparedStatementPoolable() throws SQLException {
        PreparedStatement ps = this.con.prepareStatement("CREATE TABLE foo(i int)");
        if (XA40Test.usingEmbedded()) {
            XA40Test.assertTrue((String)("ps must be an instance of BrokeredPreparedStatement, but is " + String.valueOf(ps.getClass())), (boolean)(ps instanceof BrokeredPreparedStatement));
        }
        XA40Test.assertTrue((String)"PreparedStatement must be poolable by default", (boolean)ps.isPoolable());
        ps.setPoolable(false);
        XA40Test.assertFalse((String)"PreparedStatement cannot be poolable", (boolean)ps.isPoolable());
        ps.setPoolable(true);
        XA40Test.assertTrue((String)"PreparedStatement must be poolable", (boolean)ps.isPoolable());
    }

    public void testCallableStatementPoolable() throws SQLException {
        CallableStatement cs = this.con.prepareCall("CALL SYSCS_UTIL.SYSCS_BACKUP_DATABASE(?)");
        if (XA40Test.usingEmbedded()) {
            XA40Test.assertTrue((String)("cs must be an instance of BrokeredCallableStatement, but is " + String.valueOf(cs.getClass())), (boolean)(cs instanceof BrokeredCallableStatement));
        }
        XA40Test.assertTrue((String)"CallableStatement must be poolable by default", (boolean)cs.isPoolable());
        cs.setPoolable(false);
        XA40Test.assertFalse((String)"CallableStatement cannot be poolable", (boolean)cs.isPoolable());
        cs.setPoolable(true);
        XA40Test.assertTrue((String)"CallableStatement must be poolable", (boolean)cs.isPoolable());
    }

    public void testLargeUpdate_jdbc4_2() throws Exception {
        StatementTest.largeUpdate_jdbc4_2(this.con);
    }

    public void test_registerOutParameter_jdbc4_2() throws Exception {
        if (JDBC.vmSupportsJDBC42()) {
            Class<?> klass = Class.forName("org.apache.derbyTesting.functionTests.tests.jdbc4.PreparedStatementTest42");
            Method method = klass.getMethod("registerObjectTest", Connection.class);
            method.invoke(null, this.con);
        }
    }

    public static Test suite() {
        return TestConfiguration.defaultSuite(XA40Test.class);
    }
}

