/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Random;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;

public class largeCodeGen
extends BaseJDBCTestCase {
    private static boolean TEST_QUERY_EXECUTION = true;

    public largeCodeGen(String string) {
        super(string);
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite();
        if (largeCodeGen.usingEmbedded()) {
            baseTestSuite.addTestSuite(largeCodeGen.class);
            return new CleanDatabaseTestSetup((Test)baseTestSuite);
        }
        return baseTestSuite;
    }

    protected void setUp() throws SQLException {
        this.getConnection().setAutoCommit(false);
        Statement statement = this.createStatement();
        String string = "create table t0 (si smallint,i int, bi bigint, r real, f float, d double precision, n5_2 numeric(5,2), dec10_3 decimal(10,3), ch20 char(3),vc varchar(20), lvc long varchar)";
        statement.executeUpdate(string);
        statement.executeUpdate("insert into t0 values(2,3,4,5.3,5.3,5.3,31.13,123456.123, 'one','one','one')");
        statement.close();
        this.commit();
    }

    @Override
    protected void tearDown() throws Exception {
        Statement statement = this.createStatement();
        statement.execute("DROP TABLE T0");
        statement.close();
        this.commit();
        super.tearDown();
    }

    private boolean checkT0Query(String string, StringBuffer stringBuffer, int n, int n2) {
        try {
            PreparedStatement preparedStatement = this.prepareStatement(stringBuffer.toString());
            if (TEST_QUERY_EXECUTION) {
                for (int i = 1; i <= n; ++i) {
                    preparedStatement.setInt(i, n2);
                }
                ResultSet resultSet = preparedStatement.executeQuery();
                resultSet.next();
                largeCodeGen.checkRowData(resultSet);
                resultSet.close();
            }
            preparedStatement.close();
            this.commit();
            return false;
        }
        catch (SQLException sQLException) {
            largeCodeGen.assertSQLState("42ZA0", sQLException);
            return true;
        }
    }

    public void testLogicalOperators() throws SQLException {
        int n = 0;
        for (int i = 700; i <= 10000 && !this.logicalOperators(i); i += 100) {
            n = i;
        }
        largeCodeGen.assertEquals((String)"logical operators change from previous limit", (int)800, (int)n);
    }

    private boolean logicalOperators(int n) throws SQLException {
        String string = "(si = ? AND si = ? )";
        String string2 = "Logical operators with " + n + " parameters";
        StringBuffer stringBuffer = new StringBuffer(n * 20 + 512);
        stringBuffer.append("SELECT * FROM T0 WHERE " + string);
        for (int i = 2; i < n; i += 2) {
            stringBuffer.append(" OR " + string);
        }
        return this.checkT0Query(string2, stringBuffer, n, 2);
    }

    public void testInClause() throws SQLException {
        largeCodeGen.assertFalse((String)"IN clause with 3400 parameters ", (boolean)this.inClause(3400));
        int n = 0;
        for (int i = 97000; i <= 200000 && !this.inClause(i); i += 1000) {
            n = i;
        }
        largeCodeGen.assertEquals((String)"IN clause change from previous limit", (int)98000, (int)n);
    }

    private boolean inClause(int n) throws SQLException {
        String string = "IN clause with " + n + " parameters";
        StringBuffer stringBuffer = new StringBuffer(n * 20 + 512);
        stringBuffer.append("SELECT * FROM T0 WHERE SI IN (");
        for (int i = 1; i < n; ++i) {
            stringBuffer.append("?, ");
        }
        stringBuffer.append("?)");
        return this.checkT0Query(string, stringBuffer, n, 2);
    }

    public void testUnions() throws SQLException {
        int n;
        String string = "v0";
        Statement statement = this.createStatement();
        StringBuffer stringBuffer = new StringBuffer("create view " + string + " as select * from t0 ");
        for (n = 1; n < 100; ++n) {
            stringBuffer.append(" UNION ALL (SELECT * FROM t0 )");
        }
        statement.executeUpdate(stringBuffer.toString());
        this.commit();
        n = 0;
        for (int i = 1000; i <= 1000 && !this.largeUnionSelect(string, i); i += 1000) {
            n = i;
        }
        this.createStatement().executeUpdate("DROP VIEW " + string);
        largeCodeGen.assertEquals((String)"UNION operators change from previous limit", (int)1000, (int)n);
    }

    private boolean largeUnionSelect(String string, int n) throws SQLException {
        String string2 = " UNION ALL (SELECT * FROM " + string + ")";
        StringBuffer stringBuffer = new StringBuffer(n / 100 * string2.length() + 512);
        stringBuffer.append("select * from t0 ");
        for (int i = 1; i < n / 100; ++i) {
            stringBuffer.append(string2);
        }
        try {
            String string3 = stringBuffer.toString();
            PreparedStatement preparedStatement = this.prepareStatement(string3);
            if (TEST_QUERY_EXECUTION) {
                ResultSet resultSet = preparedStatement.executeQuery();
                int n2 = 0;
                while (resultSet.next()) {
                    if (++n2 % 100 != 0) continue;
                    largeCodeGen.checkRowData(resultSet);
                }
                resultSet.close();
                this.commit();
            }
            preparedStatement.close();
            return false;
        }
        catch (SQLException sQLException) {
            largeCodeGen.assertSQLState("42ZA0", sQLException);
            return true;
        }
    }

    private static void checkRowData(ResultSet resultSet) throws SQLException {
        String[] stringArray = new String[]{"2", "3", "4", "5.3", "5.3", "5.3", "31.13", "123456.123", "one", "one", "one"};
        for (int i = 1; i <= 11; ++i) {
            largeCodeGen.assertEquals((String)"Result set data value: ", (String)stringArray[i - 1], (String)resultSet.getString(i));
        }
    }

    public void testInsertValues() throws SQLException {
        int n = 0;
        for (int i = 1500; i <= 1700 && !this.insertValues(i); i += 200) {
            n = i;
        }
        largeCodeGen.assertEquals((String)"INSERT VALUES change from previous limit", (int)1700, (int)n);
    }

    private boolean insertValues(int n) throws SQLException {
        Random random = new Random(3457245435L);
        StringBuffer stringBuffer = new StringBuffer("INSERT INTO T0(SI,I,BI,R,F,D,N5_2,DEC10_3,CH20,VC,LVC) VALUES\n");
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append('(');
            stringBuffer.append((short)random.nextInt());
            stringBuffer.append(',');
            stringBuffer.append(i);
            stringBuffer.append(',');
            stringBuffer.append(random.nextLong());
            stringBuffer.append(',');
            stringBuffer.append(random.nextFloat());
            stringBuffer.append(',');
            stringBuffer.append(random.nextFloat());
            stringBuffer.append(',');
            stringBuffer.append(random.nextDouble());
            stringBuffer.append(',');
            stringBuffer.append("462.54");
            stringBuffer.append(',');
            stringBuffer.append("9324324.34");
            stringBuffer.append(',');
            stringBuffer.append('\'');
            stringBuffer.append("c");
            stringBuffer.append(random.nextInt() % 10);
            stringBuffer.append('\'');
            stringBuffer.append(',');
            stringBuffer.append('\'');
            stringBuffer.append("vc");
            stringBuffer.append(random.nextInt() % 1000000);
            stringBuffer.append('\'');
            stringBuffer.append(',');
            stringBuffer.append('\'');
            stringBuffer.append("lvc");
            stringBuffer.append(random.nextInt());
            stringBuffer.append('\'');
            stringBuffer.append(')');
            stringBuffer.append('\n');
        }
        try {
            PreparedStatement preparedStatement = this.prepareStatement(stringBuffer.toString());
            largeCodeGen.assertEquals((String)"Incorrect update count", (int)n, (int)preparedStatement.executeUpdate());
            preparedStatement.close();
            this.rollback();
            return false;
        }
        catch (SQLException sQLException) {
            largeCodeGen.assertSQLState("42ZA0", sQLException);
            return true;
        }
    }
}

