/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.tools;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.tests.tools.ImportExportBaseTest;
import org.apache.derbyTesting.functionTests.util.streams.LoopingAlphabetReader;
import org.apache.derbyTesting.functionTests.util.streams.LoopingAlphabetStream;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.SupportFilesSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class ImportExportLobTest
extends ImportExportBaseTest {
    String fileName = SupportFilesSetup.getReadWrite("books.del").getPath();
    String lobsFileName = SupportFilesSetup.getReadWrite("books_lobs.dat").getPath();
    String lobsFileName2 = SupportFilesSetup.getReadWrite("unql_books_lobs.dat").getPath();

    public ImportExportLobTest(String string) throws SQLException {
        super(string);
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite(ImportExportLobTest.class);
        baseTestSuite.addTest(TestConfiguration.clientServerSuite(ImportExportLobTest.class));
        Object object = baseTestSuite;
        object = new SupportFilesSetup((Test)object);
        return new CleanDatabaseTestSetup((Test)object){

            @Override
            protected void decorateSQL(Statement statement) throws SQLException {
                statement.execute("CREATE TABLE BOOKS(id int,name varchar(30),content clob, pic blob )");
                ImportExportLobTest.loadData(statement);
                statement.execute("CREATE TABLE BOOKS_IMP(id int,name varchar(30),content clob,pic blob )");
                statement.execute("CREATE TABLE hex_tab(id int,C1 varchar(20),C2 varchar(20),C3 varchar(20))");
                statement.execute("CREATE TABLE derby_2925_lob(id int,name varchar(30), content clob,pic blob)");
            }
        };
    }

    protected void setUp() throws SQLException {
        Statement statement = this.createStatement();
        statement.executeUpdate("DELETE FROM BOOKS_IMP");
        statement.close();
        SupportFilesSetup.deleteFile(this.fileName);
        SupportFilesSetup.deleteFile(this.lobsFileName);
    }

    public void testImportTableExportTable() throws SQLException, IOException {
        this.doExportTable("APP", "BOOKS", this.fileName, null, null, null);
        this.doImportTable("APP", "BOOKS_IMP", this.fileName, null, null, null, 0);
        this.verifyData(" * ");
    }

    public void testImportDataExportQuery() throws SQLException, IOException {
        this.doExportQuery("select * from BOOKS", this.fileName, null, null, null);
        this.doImportData(null, "BOOKS_IMP", null, null, this.fileName, null, null, null, 0);
        this.verifyData(" * ");
        this.doImportData(null, "BOOKS_IMP", "PIC, CONTENT, NAME, ID", "4, 3, 2, 1", this.fileName, null, null, null, 1);
        this.verifyData("PIC, CONTENT, NAME, ID");
        SupportFilesSetup.deleteFile(this.fileName);
        this.doExportQuery("select * from BOOKS_IMP", this.fileName, ";", "%", null);
        this.doImportData(null, "BOOKS_IMP", null, null, this.fileName, ";", "%", null, 1);
    }

    public void testImportDataExportQueryWithFewColumns() throws SQLException, IOException {
        this.doExportQuery("select id, name, content, pic from BOOKS", this.fileName, null, null, null);
        this.doImportData(null, "BOOKS_IMP", "ID,PIC", "1 , 4", this.fileName, null, null, null, 0);
        this.verifyData("ID,PIC");
        this.doImportData(null, "BOOKS_IMP", "ID, PIC, NAME", "1, 4, 2", this.fileName, null, null, null, 1);
        this.verifyData("ID, PIC, NAME");
        this.doImportData(null, "BOOKS_IMP", "ID, CONTENT, NAME", "1, 3, 2", this.fileName, null, null, null, 1);
        this.verifyData("ID, CONTENT, NAME");
        SupportFilesSetup.deleteFile(this.fileName);
        this.doExportQuery("select id, name, content, pic from BOOKS", this.fileName, "$", "!", null);
        this.doImportData(null, "BOOKS_IMP", "ID,PIC", "1 , 4", this.fileName, "$", "!", null, 0);
    }

    public void testImportWithInvalidHexStrings() throws SQLException {
        Statement statement = this.createStatement();
        statement.executeUpdate("insert into hex_tab values(1, 'row 1', 'clob 1', 'B1C201DA')");
        statement.executeUpdate("insert into hex_tab values(2, 'row 2', 'clob2 ', 'B1C201A')");
        statement.executeUpdate("insert into hex_tab values(3, '', 'clobs 3', '3122A1F20Z')");
        statement.executeUpdate("insert into hex_tab values(4, 'row \"4', '3122A1F20Z', 'B1C2\"01DA')");
        statement.close();
        this.doExportTable("APP", "HEX_TAB", this.fileName, null, null, null);
        SupportFilesSetup.deleteFile(this.fileName);
        try {
            this.doExportQuery("select * from hex_tab where id <= 2", this.fileName, null, null, null);
            this.doImportTable("APP", "BOOKS_IMP", this.fileName, null, null, null, 0);
            ImportExportLobTest.fail((String)"import did not fail on data with invalid hex string");
        }
        catch (SQLException sQLException) {
            ImportExportLobTest.assertSQLState("XIE0N", sQLException);
        }
        SupportFilesSetup.deleteFile(this.fileName);
        try {
            this.doExportQuery("select * from hex_tab where id = 3", this.fileName, null, null, null);
            this.doImportData(null, "BOOKS_IMP", "ID, PIC", "1,4", this.fileName, null, null, null, 1);
            ImportExportLobTest.fail((String)"import did not fail on data with invalid hex strings");
        }
        catch (SQLException sQLException) {
            ImportExportLobTest.assertSQLState("XIE0N", sQLException);
        }
        SupportFilesSetup.deleteFile(this.fileName);
        try {
            this.doExportQuery("select * from hex_tab where id = 4", this.fileName, null, null, null);
            this.doImportData(null, "BOOKS_IMP", "ID, PIC", "1,4", this.fileName, null, null, null, 1);
            ImportExportLobTest.fail((String)"import did not fail on data with invalid hex strings");
        }
        catch (SQLException sQLException) {
            ImportExportLobTest.assertSQLState("XIE0N", sQLException);
        }
    }

    public void testImportTableExportTableLobsInExtFile() throws SQLException, IOException {
        this.doExportTableLobsToExtFile("APP", "BOOKS", this.fileName, null, null, null, this.lobsFileName);
        this.doImportTableLobsFromExtFile("APP", "BOOKS_IMP", this.fileName, null, null, null, 0);
        this.verifyData(" * ");
    }

    public void testImportTableExportTableLobsInUnqalifiedExtFile() throws SQLException, IOException {
        SupportFilesSetup.deleteFile(this.lobsFileName2);
        this.doExportTableLobsToExtFile("APP", "BOOKS", this.fileName, "\t", "|", "UTF-16", this.lobsFileName2);
        if (JDBC.vmSupportsJDBC3()) {
            this.doImportTableLobsFromExtFile("APP", "BOOKS_IMP", this.fileName, "\t", "|", "UTF-16", 0);
            this.verifyData(" * ");
        }
    }

    public void testImportDataExportQueryLobsInExtFile() throws SQLException, IOException {
        this.doExportQueryLobsToExtFile("select * from BOOKS", this.fileName, null, null, "8859_1", this.lobsFileName);
        this.doImportDataLobsFromExtFile(null, "BOOKS_IMP", null, null, this.fileName, null, null, "8859_1", 0);
        this.verifyData(" * ");
        this.doImportDataLobsFromExtFile(null, "BOOKS_IMP", "PIC, CONTENT, NAME, ID", "4, 3, 2, 1", this.fileName, null, null, "8859_1", 1);
        this.verifyData("PIC, CONTENT, NAME, ID");
        SupportFilesSetup.deleteFile(this.fileName);
        SupportFilesSetup.deleteFile(this.lobsFileName);
        this.doExportQueryLobsToExtFile("select * from BOOKS_IMP", this.fileName, ";", "%", null, this.lobsFileName);
        this.doImportDataLobsFromExtFile(null, "BOOKS_IMP", null, null, this.fileName, ";", "%", null, 1);
    }

    public void testImportDataExportQueryWithFewColsLobsInExtFile() throws SQLException, IOException {
        this.doExportQueryLobsToExtFile("select id, name, content, pic from BOOKS", this.fileName, null, null, null, this.lobsFileName);
        this.doImportDataLobsFromExtFile(null, "BOOKS_IMP", "ID,PIC", "1 , 4", this.fileName, null, null, null, 0);
        this.verifyData("ID,PIC");
        this.doImportDataLobsFromExtFile(null, "BOOKS_IMP", "ID, PIC, NAME", "1, 4, 2", this.fileName, null, null, null, 1);
        this.verifyData("ID, PIC, NAME");
        this.doImportDataLobsFromExtFile(null, "BOOKS_IMP", "ID, CONTENT, NAME", "1, 3, 2", this.fileName, null, null, null, 1);
        this.verifyData("ID, CONTENT, NAME");
        SupportFilesSetup.deleteFile(this.fileName);
        SupportFilesSetup.deleteFile(this.lobsFileName);
        this.doExportQueryLobsToExtFile("select id, name, content, pic from BOOKS", this.fileName, "$", "!", null, this.lobsFileName);
        this.doImportDataLobsFromExtFile(null, "BOOKS_IMP", "ID,PIC", "1 , 4", this.fileName, "$", "!", null, 0);
    }

    public void testImportExportInvalideDelimiters() throws SQLException, IOException {
        try {
            this.doExportTableLobsToExtFile("APP", "BOOKS", this.fileName, null, "9", null, this.lobsFileName);
            ImportExportLobTest.fail();
        }
        catch (SQLException sQLException) {
            ImportExportLobTest.assertSQLState("XIE0J", sQLException);
        }
        SupportFilesSetup.deleteFile(this.fileName);
        SupportFilesSetup.deleteFile(this.lobsFileName);
        try {
            this.doExportQueryLobsToExtFile("select * from BOOKS", this.fileName, "|", "f", null, this.lobsFileName);
            ImportExportLobTest.fail();
        }
        catch (SQLException sQLException) {
            ImportExportLobTest.assertSQLState("XIE0J", sQLException);
        }
        SupportFilesSetup.deleteFile(this.fileName);
        SupportFilesSetup.deleteFile(this.lobsFileName);
        this.doExportQueryLobsToExtFile("select * from BOOKS where id < 10", this.fileName, null, null, null, this.lobsFileName);
        try {
            this.doImportTableLobsFromExtFile("APP", "BOOKS_IMP", this.fileName, "2", null, null, 0);
            ImportExportLobTest.fail();
        }
        catch (SQLException sQLException) {
            ImportExportLobTest.assertSQLState("XIE0J", sQLException);
        }
        try {
            this.doImportDataLobsFromExtFile(null, "BOOKS_IMP", null, null, this.fileName, null, "c", null, 1);
            ImportExportLobTest.fail();
        }
        catch (SQLException sQLException) {
            ImportExportLobTest.assertSQLState("XIE0J", sQLException);
        }
    }

    public void testImportTableExportWithInvalidLobFileName() throws SQLException, IOException {
        try {
            this.doExportTableLobsToExtFile("APP", "BOOKS", this.fileName, null, null, null, null);
            ImportExportLobTest.fail();
        }
        catch (SQLException sQLException) {
            ImportExportLobTest.assertSQLState("XIE0Q", sQLException);
        }
        SupportFilesSetup.deleteFile(this.fileName);
        this.doExportTableLobsToExtFile("APP", "BOOKS", this.fileName, null, null, null, this.lobsFileName);
        SupportFilesSetup.deleteFile(this.lobsFileName);
        try {
            this.doImportTableLobsFromExtFile("APP", "BOOKS_IMP", this.fileName, null, null, null, 0);
            ImportExportLobTest.fail();
        }
        catch (SQLException sQLException) {
            ImportExportLobTest.assertSQLState("XIE0P", sQLException);
        }
    }

    public void testDerby2955ExportQueryLobs() throws SQLException {
        this.doExportTableLobsToExtFile("APP", "DERBY_2925_LOB", this.fileName, "\t", "|", "UTF-16", this.lobsFileName);
        try {
            this.doExportTableLobsToExtFile("APP", "DERBY_2925_LOB", this.fileName, "\t", "|", "UTF-16", this.lobsFileName);
            ImportExportLobTest.fail((String)"export should have failed as the data file exists.");
        }
        catch (SQLException sQLException) {
            ImportExportLobTest.assertSQLState("XIE0S", sQLException);
        }
        SupportFilesSetup.deleteFile(this.fileName);
        SupportFilesSetup.deleteFile(this.lobsFileName);
        this.doExportTableLobsToExtFile("APP", "DERBY_2925_LOB", this.fileName, "\t", "|", "UTF-16", this.lobsFileName);
        SupportFilesSetup.deleteFile(this.fileName);
        try {
            this.doExportTableLobsToExtFile("APP", "DERBY_2925_LOB", this.fileName, "\t", "|", "UTF-16", this.lobsFileName);
            ImportExportLobTest.fail((String)"export should have failed as the data file exists.");
        }
        catch (SQLException sQLException) {
            ImportExportLobTest.assertSQLState("XIE0T", sQLException);
        }
    }

    private void verifyData(String string) throws SQLException, IOException {
        Statement statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT " + string + " FROM BOOKS order by id");
        Statement statement2 = this.createStatement();
        ResultSet resultSet2 = statement2.executeQuery("SELECT " + string + " FROM BOOKS_IMP order by id");
        JDBC.assertSameContents(resultSet, resultSet2);
        statement.close();
        statement2.close();
    }

    private static void loadData(Statement statement) throws SQLException {
        statement.executeUpdate("insert into books values (1, 'book 1', 'clob 1',cast(X'3743640ADE12337610' as blob))");
        statement.executeUpdate("insert into books values (2, 'book 2', 'clob 2',  cast (X'' as blob))");
        statement.executeUpdate("insert into books values (3, 'book 3', '', cast(X'42' as blob))");
        statement.executeUpdate("insert into books values (4, 'book 4', 'clob 4',  cast (X'3233445578990122558820' as blob))");
        statement.executeUpdate("insert into books values (5, null, 'clob 5',cast(X'3843640ADE12337610' as blob))");
        statement.executeUpdate("insert into books values (6,  'book  6', null,  cast(X'3843640ADE12337610' as blob))");
        statement.executeUpdate("insert into books values (7,  'book  7',  'clob 7' , null)");
        statement.executeUpdate("insert into books values (8, '', null,  cast (X'3843640ADE12' as blob))");
        statement.executeUpdate("insert into books values (9, 'book  9', null,  cast (X'' as blob))");
        statement.executeUpdate("insert into books values (10, 'book ;10', '%asdadasdasd', cast (X'222C23B90A' as blob))");
        statement.executeUpdate("insert into books values (11, '212C3B24', '2422412221',   cast (X'212421222C23B90A2124' as blob))");
        statement.executeUpdate("insert into books values(12, 'Transaction Processing' , 'This books covers \"Transaction\" \"processing\" concepts',cast (X'144594322143423214ab35f2e54e' as blob))");
        statement.executeUpdate("insert into books values(13, 'effective java' ,'describes how to write \" quality java \" code', cast (X'124594322143423214ab35f2e34c' as blob))");
        Connection connection = statement.getConnection();
        String string = "insert into books values(? , ? , ? , ?)";
        PreparedStatement preparedStatement = connection.prepareStatement(string);
        int n = 0;
        int n2 = 14;
        for (int i = 0; i < 17; ++i) {
            preparedStatement.setInt(1, n2++);
            preparedStatement.setString(2, "book" + i);
            int n3 = 1024 * i;
            LoopingAlphabetReader loopingAlphabetReader = new LoopingAlphabetReader(n3);
            preparedStatement.setCharacterStream(3, (Reader)loopingAlphabetReader, n3);
            LoopingAlphabetStream loopingAlphabetStream = new LoopingAlphabetStream(n += 1024 * i);
            preparedStatement.setBinaryStream(4, (InputStream)loopingAlphabetStream, n);
            preparedStatement.executeUpdate();
            if (i % 10 != 0) continue;
            connection.commit();
        }
        preparedStatement.close();
        connection.commit();
    }
}

