/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.net.URL;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import junit.framework.Test;
import org.apache.derby.catalog.SystemProcedures;
import org.apache.derbyTesting.functionTests.tests.lang.GeneratedColumnsHelper;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.SupportFilesSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class DBOAccessTest
extends GeneratedColumnsHelper {
    private static final String TEST_DBO = "TEST_DBO";
    private static final String JANET = "JANET";
    private static final String[] LEGAL_USERS = new String[]{"TEST_DBO", "JANET"};
    private static final String TEST_LOG_FILE = "sys_vti_test_derby.tstlog";
    private static final String ONLY_DBO = "4251D";
    private static final String HIDDEN_COLUMN = "4251E";
    private static final String NULL_BACKUP_DIRECTORY = "XSRS6";
    private static final String FIRST_CREDENTIALS = "4251K";
    private static final String MISSING_OBJECT = "X0X13";
    private static final String MISSING_TABLE = "42X05";
    private static final String NO_SUCH_TABLE = "XIE0M";
    private static final String UNKNOWN_USER = "XK001";
    private static final String SQLJ_INVALID_JAR = "46001";
    private static final String SYSCS_SET_DATABASE_PROPERTY = "SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY";
    private static final String SYSCS_GET_DATABASE_PROPERTY = "SYSCS_UTIL.SYSCS_GET_DATABASE_PROPERTY";
    private static final String SYSCS_FREEZE_DATABASE = "SYSCS_UTIL.SYSCS_FREEZE_DATABASE";
    private static final String SYSCS_UNFREEZE_DATABASE = "SYSCS_UTIL.SYSCS_UNFREEZE_DATABASE";
    private static final String SYSCS_CHECKPOINT_DATABASE = "SYSCS_UTIL.SYSCS_CHECKPOINT_DATABASE";
    private static final String SYSCS_BACKUP_DATABASE = "SYSCS_UTIL.SYSCS_BACKUP_DATABASE";
    private static final String SYSCS_BACKUP_DATABASE_NOWAIT = "SYSCS_UTIL.SYSCS_BACKUP_DATABASE_NOWAIT";
    private static final String SYSCS_BACKUP_DATABASE_AND_ENABLE_LOG_ARCHIVE_MODE = "SYSCS_UTIL.SYSCS_BACKUP_DATABASE_AND_ENABLE_LOG_ARCHIVE_MODE";
    private static final String SYSCS_BACKUP_DATABASE_AND_ENABLE_LOG_ARCHIVE_MODE_NOWAIT = "SYSCS_UTIL.SYSCS_BACKUP_DATABASE_AND_ENABLE_LOG_ARCHIVE_MODE_NOWAIT";
    private static final String SYSCS_DISABLE_LOG_ARCHIVE_MODE = "SYSCS_UTIL.SYSCS_DISABLE_LOG_ARCHIVE_MODE";
    private static final String SYSCS_CHECK_TABLE = "SYSCS_UTIL.SYSCS_CHECK_TABLE";
    private static final String INSTALL_JAR = "SQLJ.INSTALL_JAR";
    private static final String REPLACE_JAR = "SQLJ.REPLACE_JAR";
    private static final String REMOVE_JAR = "SQLJ.REMOVE_JAR";
    private static final String SYSCS_EXPORT_TABLE = "SYSCS_UTIL.SYSCS_EXPORT_TABLE";
    private static final String SYSCS_IMPORT_TABLE = "SYSCS_UTIL.SYSCS_IMPORT_TABLE";
    private static final String SYSCS_IMPORT_TABLE_LOBS_FROM_EXTFILE = "SYSCS_UTIL.SYSCS_IMPORT_TABLE_LOBS_FROM_EXTFILE";
    private static final String SYSCS_IMPORT_DATA = "SYSCS_UTIL.SYSCS_IMPORT_DATA";
    private static final String SYSCS_IMPORT_DATA_LOBS_FROM_EXTFILE = "SYSCS_UTIL.SYSCS_IMPORT_DATA_LOBS_FROM_EXTFILE";
    private static final String SYSCS_BULK_INSERT = "SYSCS_UTIL.SYSCS_BULK_INSERT";
    private static final String SYSCS_RELOAD_SECURITY_POLICY = "SYSCS_UTIL.SYSCS_RELOAD_SECURITY_POLICY";
    private static final String SYSCS_SET_USER_ACCESS = "SYSCS_UTIL.SYSCS_SET_USER_ACCESS";
    private static final String SYSCS_GET_USER_ACCESS = "SYSCS_UTIL.SYSCS_GET_USER_ACCESS";
    private static final String SYSCS_INVALIDATE_STORED_STATEMENTS = "SYSCS_UTIL.SYSCS_INVALIDATE_STORED_STATEMENTS";
    private static final String SYSCS_EMPTY_STATEMENT_CACHE = "SYSCS_UTIL.SYSCS_EMPTY_STATEMENT_CACHE";
    private static final String SYSCS_SET_XPLAIN_MODE = "SYSCS_UTIL.SYSCS_SET_XPLAIN_MODE";
    private static final String SYSCS_GET_XPLAIN_MODE = "SYSCS_UTIL.SYSCS_GET_XPLAIN_MODE";
    private static final String SYSCS_SET_XPLAIN_SCHEMA = "SYSCS_UTIL.SYSCS_SET_XPLAIN_SCHEMA";
    private static final String SYSCS_GET_XPLAIN_SCHEMA = "SYSCS_UTIL.SYSCS_GET_XPLAIN_SCHEMA";
    private static final String SYSCS_CREATE_USER = "SYSCS_UTIL.SYSCS_CREATE_USER";
    private static final String SYSCS_RESET_PASSWORD = "SYSCS_UTIL.SYSCS_RESET_PASSWORD";
    private static final String SYSCS_DROP_USER = "SYSCS_UTIL.SYSCS_DROP_USER";

    public DBOAccessTest(String name) {
        super(name);
    }

    public boolean authorizationIsOn() {
        return true;
    }

    public static Test suite() {
        String[] testFiles = new String[]{"functionTests/tests/lang/sys_vti_test_derby.tstlog"};
        Object authorizedRun = TestConfiguration.embeddedSuite(DBOAccessTest.class);
        authorizedRun = DatabasePropertyTestSetup.builtinAuthentication(authorizedRun, LEGAL_USERS, "authorizationOnDBOAccessTest");
        authorizedRun = new SupportFilesSetup((Test)authorizedRun, testFiles);
        authorizedRun = TestConfiguration.sqlAuthorizationDecorator(authorizedRun);
        Object unauthorizedRun = TestConfiguration.embeddedSuite(NoAuthorization.class);
        unauthorizedRun = new SupportFilesSetup((Test)unauthorizedRun, testFiles);
        BaseTestSuite suite = new BaseTestSuite();
        suite.addTest((Test)authorizedRun);
        suite.addTest((Test)unauthorizedRun);
        return suite;
    }

    public void test_5395() throws Exception {
        DBOAccessTest.println("authorizationIsOn() = " + this.authorizationIsOn());
        Connection dboConnection = this.openUserConnection(TEST_DBO);
        Connection janetConnection = this.openUserConnection(JANET);
        this.minion_5395(dboConnection, true);
        this.minion_5395(janetConnection, !this.authorizationIsOn());
    }

    private void minion_5395(Connection conn, boolean shouldSucceed) throws Exception {
        this.vet_5395(conn, shouldSucceed, "select * from syscs_diag.statement_cache");
        this.vet_5395(conn, shouldSucceed, "select * from syscs_diag.transaction_table");
        this.vet_5395(conn, shouldSucceed, "select * from table( syscs_diag.error_log_reader( ) ) s");
        this.vet_5395(conn, shouldSucceed, "select * from table( syscs_diag.statement_duration() ) s");
        URL logURL = SupportFilesSetup.getReadOnlyURL(TEST_LOG_FILE);
        String vtiArg = "'" + logURL.getFile() + "'";
        this.vet_5395(conn, shouldSucceed, "select * from table( syscs_diag.error_log_reader( " + vtiArg + " ) ) s");
        this.vet_5395(conn, shouldSucceed, "select * from table( syscs_diag.statement_duration( " + vtiArg + " ) ) s");
    }

    private void vet_5395(Connection conn, boolean shouldSucceed, String query) throws Exception {
        if (shouldSucceed) {
            this.goodStatement(conn, query);
        } else {
            this.expectCompilationError(conn, ONLY_DBO, query);
        }
    }

    public void testSYSUSERS() throws Exception {
        DBOAccessTest.println("testSYSUSERS authorizationIsOn() = " + this.authorizationIsOn());
        Connection dboConnection = this.openUserConnection(TEST_DBO);
        Connection janetConnection = this.openUserConnection(JANET);
        this.goodStatement(dboConnection, "create view v2 as select username, hashingscheme, lastmodified from sys.sysusers");
        if (this.authorizationIsOn()) {
            this.goodStatement(dboConnection, "grant select on v2 to public");
        }
        this.goodStatement(dboConnection, "create view v3 as select username, hashingscheme, lastmodified from sys.sysusers where password is null");
        if (this.authorizationIsOn()) {
            this.goodStatement(dboConnection, "grant select on v3 to public");
        }
        this.vetDBO_OKProbes(dboConnection, true);
        this.vetDBO_OKProbes(janetConnection, !this.authorizationIsOn());
        this.vetUnauthorizedProbes(dboConnection, !this.authorizationIsOn(), HIDDEN_COLUMN);
        this.vetUnauthorizedProbes(janetConnection, !this.authorizationIsOn(), ONLY_DBO);
    }

    private void vetDBO_OKProbes(Connection conn, boolean shouldSucceed) throws Exception {
        this.vetUserProbes(conn, shouldSucceed, "select count(*) from sys.sysusers", ONLY_DBO);
        this.vetUserProbes(conn, shouldSucceed, "select username, hashingscheme, lastmodified from sys.sysusers", ONLY_DBO);
        this.vetUserProbes(conn, shouldSucceed, "select username from sys.sysusers", ONLY_DBO);
        this.vetUserProbes(conn, shouldSucceed, "select username, lastmodified from sys.sysusers", ONLY_DBO);
        this.vetUserProbes(conn, shouldSucceed, "select username, lastmodified from sys.sysusers where username = 'FRED'", ONLY_DBO);
        this.vetUserProbes(conn, shouldSucceed, "select count(*) from test_dbo.v2", ONLY_DBO);
        this.vetUserProbes(conn, shouldSucceed, "select * from test_dbo.v2", ONLY_DBO);
        this.vetUserProbes(conn, shouldSucceed, "select username, hashingscheme, lastmodified from test_dbo.v2", ONLY_DBO);
        this.vetUserProbes(conn, shouldSucceed, "select username from test_dbo.v2", ONLY_DBO);
    }

    private void vetUnauthorizedProbes(Connection conn, boolean shouldSucceed, String expectedSQLState) throws Exception {
        this.vetUserProbes(conn, shouldSucceed, "select * from sys.sysusers", expectedSQLState);
        this.vetUserProbes(conn, shouldSucceed, "select * from sys.sysusers where username='foo'", expectedSQLState);
        this.vetUserProbes(conn, shouldSucceed, "select password from sys.sysusers", expectedSQLState);
        this.vetUserProbes(conn, shouldSucceed, "select username, password from sys.sysusers", expectedSQLState);
        this.vetUserProbes(conn, shouldSucceed, "select username from sys.sysusers where password = 'foo'", expectedSQLState);
        this.vetUserProbes(conn, shouldSucceed, "select username, lastmodified from sys.sysusers where password is not null", expectedSQLState);
        this.vetUserProbes(conn, shouldSucceed, "select * from test_dbo.v3", expectedSQLState);
    }

    private void vetUserProbes(Connection conn, boolean shouldSucceed, String query, String expectedSQLState) throws Exception {
        if (shouldSucceed) {
            this.goodStatement(conn, query);
        } else {
            this.expectCompilationError(conn, expectedSQLState, query);
        }
    }

    public void test_6616() throws Exception {
        Connection dboConnection = this.openUserConnection(TEST_DBO);
        Connection janetConnection = this.openUserConnection(JANET);
        this.goodStatement(dboConnection, "create procedure runSystemRoutine( routineName varchar( 32672 ) )\nlanguage java parameter style java modifies sql data\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.DBOAccessTest.runSystemRoutine'\n");
        if (this.authorizationIsOn()) {
            this.goodStatement(dboConnection, "grant execute on procedure runSystemRoutine to public");
        }
        this.vet6616(dboConnection, janetConnection, SYSCS_SET_DATABASE_PROPERTY, false);
        this.vet6616(dboConnection, janetConnection, SYSCS_GET_DATABASE_PROPERTY, true);
        this.vet6616(dboConnection, janetConnection, SYSCS_FREEZE_DATABASE, false);
        this.vet6616(dboConnection, janetConnection, SYSCS_UNFREEZE_DATABASE, false);
        this.vet6616(dboConnection, janetConnection, SYSCS_CHECKPOINT_DATABASE, false);
        this.vet6616(dboConnection, janetConnection, SYSCS_BACKUP_DATABASE, false);
        this.vet6616(dboConnection, janetConnection, SYSCS_BACKUP_DATABASE_NOWAIT, false);
        this.vet6616(dboConnection, janetConnection, SYSCS_BACKUP_DATABASE_AND_ENABLE_LOG_ARCHIVE_MODE, false);
        this.vet6616(dboConnection, janetConnection, SYSCS_BACKUP_DATABASE_AND_ENABLE_LOG_ARCHIVE_MODE_NOWAIT, false);
        this.vet6616(dboConnection, janetConnection, SYSCS_DISABLE_LOG_ARCHIVE_MODE, false);
        this.vet6616(dboConnection, janetConnection, SYSCS_CHECK_TABLE, true);
        this.vet6616(dboConnection, janetConnection, INSTALL_JAR, false);
        this.vet6616(dboConnection, janetConnection, REPLACE_JAR, false);
        this.vet6616(dboConnection, janetConnection, REMOVE_JAR, false);
        this.vet6616(dboConnection, janetConnection, SYSCS_EXPORT_TABLE, false);
        this.vet6616(dboConnection, janetConnection, SYSCS_IMPORT_TABLE, false);
        this.vet6616(dboConnection, janetConnection, SYSCS_IMPORT_TABLE_LOBS_FROM_EXTFILE, false);
        this.vet6616(dboConnection, janetConnection, SYSCS_IMPORT_DATA, false);
        this.vet6616(dboConnection, janetConnection, SYSCS_IMPORT_DATA_LOBS_FROM_EXTFILE, false);
        this.vet6616(dboConnection, janetConnection, SYSCS_BULK_INSERT, false);
        this.vet6616(dboConnection, janetConnection, SYSCS_RELOAD_SECURITY_POLICY, false);
        this.vet6616(dboConnection, janetConnection, SYSCS_SET_USER_ACCESS, false);
        this.vet6616(dboConnection, janetConnection, SYSCS_GET_USER_ACCESS, true);
        this.vet6616(dboConnection, janetConnection, SYSCS_INVALIDATE_STORED_STATEMENTS, false);
        this.vet6616(dboConnection, janetConnection, SYSCS_EMPTY_STATEMENT_CACHE, false);
        this.vet6616(dboConnection, janetConnection, SYSCS_SET_XPLAIN_MODE, false);
        this.vet6616(dboConnection, janetConnection, SYSCS_GET_XPLAIN_MODE, true);
        this.vet6616(dboConnection, janetConnection, SYSCS_SET_XPLAIN_SCHEMA, false);
        this.vet6616(dboConnection, janetConnection, SYSCS_GET_XPLAIN_SCHEMA, true);
        this.vet6616(dboConnection, janetConnection, SYSCS_CREATE_USER, false);
        this.vet6616(dboConnection, janetConnection, SYSCS_RESET_PASSWORD, false);
        this.vet6616(dboConnection, janetConnection, SYSCS_DROP_USER, false);
    }

    private void vet6616(Connection dboConnection, Connection janetConnection, String routineName, boolean isFunction) throws Exception {
        this.vet6616(dboConnection, true, routineName);
        this.vet6616(janetConnection, !this.authorizationIsOn(), routineName);
        if (this.authorizationIsOn()) {
            boolean isFreeze = SYSCS_FREEZE_DATABASE.equals(routineName);
            String routineType = isFunction ? "function" : "procedure";
            this.goodStatement(dboConnection, "grant execute on " + routineType + " " + routineName + " to public");
            if (isFreeze) {
                this.goodStatement(dboConnection, "grant execute on " + routineType + " SYSCS_UTIL.SYSCS_UNFREEZE_DATABASE to public");
            }
            this.vet6616(janetConnection, true, routineName);
            this.goodStatement(dboConnection, "revoke execute on " + routineType + " " + routineName + " from public restrict");
            if (isFreeze) {
                this.goodStatement(dboConnection, "revoke execute on " + routineType + " SYSCS_UTIL.SYSCS_UNFREEZE_DATABASE from public restrict");
            }
        }
    }

    private void vet6616(Connection conn, boolean shouldSucceed, String routineName) throws Exception {
        CallableStatement cs = conn.prepareCall("call test_dbo.runSystemRoutine( ? )");
        cs.setString(1, routineName);
        try {
            cs.execute();
            if (!shouldSucceed) {
                DBOAccessTest.fail((String)(routineName + " should have failed!"));
            }
        }
        catch (SQLException se) {
            if (shouldSucceed) {
                DBOAccessTest.fail(routineName + " should have succeeded", se);
            }
            DBOAccessTest.assertSQLState("42504", se);
        }
    }

    public static void runSystemRoutine(String routineName) throws Exception {
        if (SYSCS_SET_DATABASE_PROPERTY.equals(routineName)) {
            SystemProcedures.SYSCS_SET_DATABASE_PROPERTY((String)"foo.bar.wibble", (String)"wibble.bar.foo");
        } else if (SYSCS_GET_DATABASE_PROPERTY.equals(routineName)) {
            SystemProcedures.SYSCS_GET_DATABASE_PROPERTY((String)"la.dee.dah");
        } else if (SYSCS_FREEZE_DATABASE.equals(routineName)) {
            SystemProcedures.SYSCS_FREEZE_DATABASE();
            SystemProcedures.SYSCS_UNFREEZE_DATABASE();
        } else if (SYSCS_UNFREEZE_DATABASE.equals(routineName)) {
            SystemProcedures.SYSCS_UNFREEZE_DATABASE();
        } else if (SYSCS_CHECKPOINT_DATABASE.equals(routineName)) {
            SystemProcedures.SYSCS_CHECKPOINT_DATABASE();
        } else if (SYSCS_BACKUP_DATABASE.equals(routineName)) {
            try {
                SystemProcedures.SYSCS_BACKUP_DATABASE(null);
                DBOAccessTest.fail();
            }
            catch (SQLException se) {
                DBOAccessTest.vetError(NULL_BACKUP_DIRECTORY, se);
            }
        } else if (SYSCS_BACKUP_DATABASE_NOWAIT.equals(routineName)) {
            try {
                SystemProcedures.SYSCS_BACKUP_DATABASE_NOWAIT(null);
                DBOAccessTest.fail();
            }
            catch (SQLException se) {
                DBOAccessTest.vetError(NULL_BACKUP_DIRECTORY, se);
            }
        } else if (SYSCS_BACKUP_DATABASE_AND_ENABLE_LOG_ARCHIVE_MODE.equals(routineName)) {
            try {
                SystemProcedures.SYSCS_BACKUP_DATABASE_AND_ENABLE_LOG_ARCHIVE_MODE(null, (short)0);
                DBOAccessTest.fail();
            }
            catch (SQLException se) {
                DBOAccessTest.vetError(NULL_BACKUP_DIRECTORY, se);
            }
        } else if (SYSCS_BACKUP_DATABASE_AND_ENABLE_LOG_ARCHIVE_MODE_NOWAIT.equals(routineName)) {
            try {
                SystemProcedures.SYSCS_BACKUP_DATABASE_AND_ENABLE_LOG_ARCHIVE_MODE_NOWAIT(null, (short)0);
                DBOAccessTest.fail();
            }
            catch (SQLException se) {
                DBOAccessTest.vetError(NULL_BACKUP_DIRECTORY, se);
            }
        } else if (SYSCS_DISABLE_LOG_ARCHIVE_MODE.equals(routineName)) {
            SystemProcedures.SYSCS_DISABLE_LOG_ARCHIVE_MODE((short)0);
        } else if (SYSCS_CHECK_TABLE.equals(routineName)) {
            SystemProcedures.SYSCS_CHECK_TABLE((String)"SYS", (String)"SYSTABLES");
        } else if (INSTALL_JAR.equals(routineName)) {
            try {
                SystemProcedures.INSTALL_JAR((String)SupportFilesSetup.getReadOnlyFileName("foo"), (String)"bar", (int)1);
                DBOAccessTest.fail();
            }
            catch (SQLException se) {
                DBOAccessTest.vetError(SQLJ_INVALID_JAR, se);
            }
        } else if (REPLACE_JAR.equals(routineName)) {
            try {
                SystemProcedures.REPLACE_JAR((String)SupportFilesSetup.getReadOnlyFileName("foo"), (String)"bar");
                DBOAccessTest.fail();
            }
            catch (SQLException se) {
                DBOAccessTest.vetError(SQLJ_INVALID_JAR, se);
            }
        } else if (REMOVE_JAR.equals(routineName)) {
            try {
                SystemProcedures.REMOVE_JAR((String)"test_dbo.foo", (int)0);
                DBOAccessTest.fail();
            }
            catch (SQLException se) {
                DBOAccessTest.vetError(MISSING_OBJECT, se);
            }
        } else if (SYSCS_EXPORT_TABLE.equals(routineName)) {
            try {
                SystemProcedures.SYSCS_EXPORT_TABLE((String)TEST_DBO, (String)"BAR", (String)SupportFilesSetup.getReadWriteFileName("WIBBLE"), null, null, null);
                DBOAccessTest.fail();
            }
            catch (SQLException se) {
                DBOAccessTest.vetError(MISSING_TABLE, se);
            }
        } else if (SYSCS_IMPORT_TABLE.equals(routineName)) {
            try {
                SystemProcedures.SYSCS_IMPORT_TABLE((String)TEST_DBO, (String)"BAR", (String)SupportFilesSetup.getReadWriteFileName("WIBBLE"), null, null, null, (short)1);
                DBOAccessTest.fail();
            }
            catch (SQLException se) {
                DBOAccessTest.vetError(NO_SUCH_TABLE, se);
            }
        } else if (SYSCS_IMPORT_TABLE_LOBS_FROM_EXTFILE.equals(routineName)) {
            try {
                SystemProcedures.SYSCS_IMPORT_TABLE_LOBS_FROM_EXTFILE((String)TEST_DBO, (String)"BAR", (String)"WIBBLE", null, null, null, (short)1);
                DBOAccessTest.fail();
            }
            catch (SQLException se) {
                DBOAccessTest.vetError(NO_SUCH_TABLE, se);
            }
        } else if (SYSCS_IMPORT_DATA.equals(routineName)) {
            try {
                SystemProcedures.SYSCS_IMPORT_DATA((String)TEST_DBO, (String)"BAR", null, (String)"1,3,4", (String)"WIBBLE", null, null, null, (short)1);
                DBOAccessTest.fail();
            }
            catch (SQLException se) {
                DBOAccessTest.vetError(NO_SUCH_TABLE, se);
            }
        } else if (SYSCS_IMPORT_DATA_LOBS_FROM_EXTFILE.equals(routineName)) {
            try {
                SystemProcedures.SYSCS_IMPORT_DATA_LOBS_FROM_EXTFILE((String)TEST_DBO, (String)"BAR", null, (String)"1,3,4", (String)"WIBBLE", null, null, null, (short)1);
                DBOAccessTest.fail();
            }
            catch (SQLException se) {
                DBOAccessTest.vetError(NO_SUCH_TABLE, se);
            }
        } else if (SYSCS_BULK_INSERT.equals(routineName)) {
            try {
                SystemProcedures.SYSCS_BULK_INSERT((String)TEST_DBO, (String)"BAR", (String)"WIBBLE", (String)"wombat");
                DBOAccessTest.fail();
            }
            catch (SQLException se) {
                DBOAccessTest.vetError("42X01", se);
            }
        } else if (SYSCS_RELOAD_SECURITY_POLICY.equals(routineName)) {
            SystemProcedures.SYSCS_RELOAD_SECURITY_POLICY();
        } else if (SYSCS_SET_USER_ACCESS.equals(routineName)) {
            SystemProcedures.SYSCS_SET_USER_ACCESS((String)"FOO", (String)"FULLACCESS");
        } else if (SYSCS_GET_USER_ACCESS.equals(routineName)) {
            SystemProcedures.SYSCS_GET_USER_ACCESS((String)"FOO");
        } else if (SYSCS_INVALIDATE_STORED_STATEMENTS.equals(routineName)) {
            SystemProcedures.SYSCS_INVALIDATE_STORED_STATEMENTS();
        } else if (SYSCS_EMPTY_STATEMENT_CACHE.equals(routineName)) {
            SystemProcedures.SYSCS_EMPTY_STATEMENT_CACHE();
        } else if (SYSCS_SET_XPLAIN_MODE.equals(routineName)) {
            SystemProcedures.SYSCS_SET_XPLAIN_MODE((int)0);
        } else if (SYSCS_GET_XPLAIN_MODE.equals(routineName)) {
            SystemProcedures.SYSCS_GET_XPLAIN_MODE();
        } else if (SYSCS_SET_XPLAIN_SCHEMA.equals(routineName)) {
            SystemProcedures.SYSCS_SET_XPLAIN_SCHEMA((String)"");
        } else if (SYSCS_GET_XPLAIN_SCHEMA.equals(routineName)) {
            SystemProcedures.SYSCS_GET_XPLAIN_SCHEMA();
        } else if (SYSCS_CREATE_USER.equals(routineName)) {
            try {
                SystemProcedures.SYSCS_CREATE_USER((String)"foo", (String)"bar");
                DBOAccessTest.fail();
            }
            catch (SQLException se) {
                DBOAccessTest.vetError(FIRST_CREDENTIALS, se);
            }
        } else if (SYSCS_RESET_PASSWORD.equals(routineName)) {
            try {
                SystemProcedures.SYSCS_RESET_PASSWORD((String)"foo", (String)"bar");
                DBOAccessTest.fail();
            }
            catch (SQLException se) {
                DBOAccessTest.vetError(UNKNOWN_USER, se);
            }
        } else if (SYSCS_DROP_USER.equals(routineName)) {
            try {
                SystemProcedures.SYSCS_DROP_USER((String)"foo");
                DBOAccessTest.fail();
            }
            catch (SQLException se) {
                DBOAccessTest.vetError(UNKNOWN_USER, se);
            }
        } else {
            throw new Exception("Unknown routine name: " + routineName);
        }
    }

    private static void vetError(String sqlState, SQLException se) throws SQLException {
        if (!sqlState.equals(se.getSQLState())) {
            throw se;
        }
        DBOAccessTest.println("Caught expected error: " + sqlState);
    }

    public static final class NoAuthorization
    extends DBOAccessTest {
        public NoAuthorization(String name) {
            super(name);
        }

        @Override
        public boolean authorizationIsOn() {
            return false;
        }
    }
}

