/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.store;

import java.io.PrintStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.derby.tools.JDBCDisplayUtil;
import org.apache.derby.tools.ij;
import org.apache.derbyTesting.functionTests.tests.store.MaxLogNumber;

public class MaxLogNumberRecovery
extends MaxLogNumber {
    MaxLogNumberRecovery() {
    }

    private void runTest(Connection connection) throws SQLException {
        block4: {
            this.logMessage("Begin MaxLogNumberRecovery Test");
            this.verifyData(connection, 100);
            boolean bl = false;
            try {
                this.insert(connection, 110, 1, 11);
                this.update(connection, 110, 2, 5);
                this.update(connection, 110, 3, 5);
                this.verifyData(connection, 210);
            }
            catch (SQLException sQLException) {
                SQLException sQLException2;
                SQLException sQLException3 = sQLException;
                while (sQLException2 != null) {
                    if ("XSLAK".equals(sQLException2.getSQLState())) {
                        bl = true;
                        break;
                    }
                    sQLException2 = sQLException2.getNextException();
                }
                if (bl) break block4;
                throw sQLException3;
            }
        }
        this.logMessage("End MaxLogNumberRecovery Test");
    }

    private static void setSystemProperty(final String string, final String string2) {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                System.setProperty(string, string2);
                return null;
            }
        });
    }

    public static void main(String[] stringArray) throws Throwable {
        MaxLogNumberRecovery maxLogNumberRecovery = new MaxLogNumberRecovery();
        ij.getPropertyArg((String[])stringArray);
        MaxLogNumberRecovery.setSystemProperty("derby.stream.error.extendedDiagSeverityLevel", "50000");
        Connection connection = ij.startJBMS();
        connection.setAutoCommit(false);
        try {
            maxLogNumberRecovery.runTest(connection);
        }
        catch (SQLException sQLException) {
            JDBCDisplayUtil.ShowSQLException((PrintStream)System.out, (SQLException)sQLException);
            sQLException.printStackTrace(System.out);
        }
    }
}

