/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Locale;
import java.util.Properties;
import junit.extensions.TestSetup;
import junit.framework.Test;
import org.apache.derby.optional.api.LuceneIndexDescriptor;
import org.apache.derby.optional.api.LuceneUtils;
import org.apache.derbyTesting.functionTests.tests.lang.GeneratedColumnsHelper;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.SecurityManagerSetup;
import org.apache.derbyTesting.junit.TestConfiguration;
import org.apache.lucene.analysis.Analyzer;

public class LuceneCoarseAuthorizationTest
extends GeneratedColumnsHelper {
    private static final String RUTH = "RUTH";
    private static final String READ_ONLY_USER = "READONLYUSER";
    private static final String READ_WRITE_USER = "READWRITEUSER";
    private static final String[] LEGAL_USERS = new String[]{"RUTH", "READONLYUSER", "READWRITEUSER"};
    public static final String ENGLISH_ANALYZER = "org.apache.derbyTesting.functionTests.tests.lang.LuceneCoarseAuthorizationTest.getEnglishAnalyzer";
    public static final String STANDARD_ANALYZER = "org.apache.derbyTesting.functionTests.tests.lang.LuceneCoarseAuthorizationTest.getStandardAnalyzer";
    private static final String LOAD_TOOL = "call syscs_util.syscs_register_tool( 'luceneSupport', true )";
    private static final String UNLOAD_TOOL = "call syscs_util.syscs_register_tool( 'luceneSupport', false )";
    private static final String INDEX_POEMS = "call LuceneSupport.createIndex( 'ruth', 'poems', 'poemText', 'org.apache.derbyTesting.functionTests.tests.lang.LuceneCoarseAuthorizationTest.getEnglishAnalyzer' )";
    private static final String UPDATE_POEMS_INDEX = "call LuceneSupport.updateIndex( 'ruth', 'poems', 'poemText', 'org.apache.derbyTesting.functionTests.tests.lang.LuceneCoarseAuthorizationTest.getStandardAnalyzer' )";
    private static final String DROP_POEMS_INDEX = "call LuceneSupport.dropIndex( 'ruth', 'poems', 'poemText' )";
    private static final String ILLEGAL_FOR_READONLY = "25502";

    public LuceneCoarseAuthorizationTest(String string) {
        super(string);
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = (BaseTestSuite)TestConfiguration.embeddedSuite(LuceneCoarseAuthorizationTest.class);
        Test test = SecurityManagerSetup.noSecurityManager((Test)baseTestSuite);
        Test test2 = DatabasePropertyTestSetup.builtinAuthentication(test, LEGAL_USERS, "LuceneCoarsePermissions");
        DatabasePropertyTestSetup databasePropertyTestSetup = new DatabasePropertyTestSetup(test2, LuceneCoarseAuthorizationTest.makeProperties());
        TestSetup testSetup = TestConfiguration.singleUseDatabaseDecorator((Test)databasePropertyTestSetup);
        return testSetup;
    }

    private static Properties makeProperties() {
        Properties properties = new Properties();
        properties.setProperty("derby.database.fullAccessUsers", "RUTH,READWRITEUSER");
        properties.setProperty("derby.database.readOnlyAccessUsers", READ_ONLY_USER);
        return properties;
    }

    public void test_001_basic() throws Exception {
        Connection connection = this.openUserConnection(RUTH);
        Connection connection2 = this.openUserConnection(READ_ONLY_USER);
        Connection connection3 = this.openUserConnection(READ_WRITE_USER);
        LuceneCoarseAuthorizationTest.createSchema(connection);
        this.expectExecutionError(connection2, ILLEGAL_FOR_READONLY, LOAD_TOOL);
        this.goodStatement(connection3, LOAD_TOOL);
        this.expectExecutionError(connection2, ILLEGAL_FOR_READONLY, INDEX_POEMS);
        this.goodStatement(connection3, INDEX_POEMS);
        String string = "select p.originalAuthor, i.score\nfrom ruth.poems p, table ( ruth.poems__poemText( 'star', 1000, null ) ) i\nwhere p.poemID = i.poemID and p.versionStamp = i.versionStamp\norder by i.score desc\n";
        String[][] stringArray = new String[][]{{"Walt Whitman", "0.26756266"}, {"Lord Byron", "0.22933942"}, {"John Milton", "0.22933942"}};
        this.assertResults(connection2, string, stringArray, false);
        this.assertResults(connection3, string, stringArray, false);
        String string2 = "select schemaName, tableName, columnName, indexDescriptorMaker from table( LuceneSupport.listIndexes() ) l";
        String[][] stringArray2 = new String[][]{{RUTH, "POEMS", "POEMTEXT", ENGLISH_ANALYZER}};
        this.assertResults(connection2, string2, stringArray2, false);
        this.assertResults(connection3, string2, stringArray2, false);
        this.expectExecutionError(connection2, ILLEGAL_FOR_READONLY, UPDATE_POEMS_INDEX);
        this.goodStatement(connection3, UPDATE_POEMS_INDEX);
        String[][] stringArray3 = new String[][]{{"Walt Whitman", "0.3304931"}, {"John Milton", "0.2832798"}};
        this.assertResults(connection2, string, stringArray3, false);
        this.assertResults(connection3, string, stringArray3, false);
        String[][] stringArray4 = new String[][]{{RUTH, "POEMS", "POEMTEXT", STANDARD_ANALYZER}};
        this.assertResults(connection2, string2, stringArray4, false);
        this.assertResults(connection3, string2, stringArray4, false);
        this.expectExecutionError(connection2, ILLEGAL_FOR_READONLY, DROP_POEMS_INDEX);
        this.goodStatement(connection3, DROP_POEMS_INDEX);
        this.expectExecutionError(connection2, ILLEGAL_FOR_READONLY, UNLOAD_TOOL);
        this.goodStatement(connection3, UNLOAD_TOOL);
        LuceneCoarseAuthorizationTest.dropSchema(connection);
    }

    public static LuceneIndexDescriptor getEnglishAnalyzer() throws Exception {
        return new EnglishIndexDescriptor();
    }

    public static LuceneIndexDescriptor getStandardAnalyzer() throws Exception {
        return new StandardIndexDescriptor();
    }

    public static void createSchema(Connection connection) throws Exception {
        LuceneCoarseAuthorizationTest.createPoemsTable(connection);
    }

    public static void dropSchema(Connection connection) throws Exception {
        connection.prepareStatement("drop table poems").execute();
    }

    public static void createPoemsTable(Connection connection) throws Exception {
        connection.prepareStatement("create table poems\n(\n    poemID int,\n    versionStamp int not null,\n    originalAuthor       varchar( 50 ),\n    lastEditor           varchar( 50 ),\n    poemText            clob,\n    constraint poemsKey primary key( poemID, versionStamp )\n)\n").execute();
        PreparedStatement preparedStatement = connection.prepareStatement("insert into poems values ( ?, ?, ?, ?, ? )");
        int n = 1;
        int n2 = 1;
        preparedStatement.setInt(1, n++);
        preparedStatement.setInt(2, n2++);
        preparedStatement.setString(3, "Geoffrey Chaucer");
        preparedStatement.setString(4, "Geoffrey Chaucer");
        preparedStatement.setString(5, "Whan that Aprill, with his shoures soote The droghte of March hath perced to the roote And bathed every veyne in swich licour, Of which vertu engendred is the flour;");
        preparedStatement.executeUpdate();
        preparedStatement.setInt(1, n++);
        preparedStatement.setInt(2, n2++);
        preparedStatement.setString(3, "Andrew Marvell");
        preparedStatement.setString(4, "Andrew Marvell");
        preparedStatement.setString(5, "Had we but world enough, and time, This coyness, lady, were no crime.");
        preparedStatement.executeUpdate();
        preparedStatement.setInt(1, n++);
        preparedStatement.setInt(2, n2++);
        preparedStatement.setString(3, "John Milton");
        preparedStatement.setString(4, "John Milton");
        preparedStatement.setString(5, "From morn to noon he fell, from noon to dewy eve, a summers day, and with the setting sun dropped from the ze4ith like a falling star on Lemnos, the Aegean isle");
        preparedStatement.executeUpdate();
        preparedStatement.setInt(1, n++);
        preparedStatement.setInt(2, n2++);
        preparedStatement.setString(3, "Lord Byron");
        preparedStatement.setString(4, "Lord Byron");
        preparedStatement.setString(5, "The Assyrian came down like the wolf on the fold, And his cohorts were gleaming in purple and gold; And the sheen of their spears was like stars on the sea, When the blue wave rolls nightly on deep Galilee.");
        preparedStatement.executeUpdate();
        preparedStatement.setInt(1, n++);
        preparedStatement.setInt(2, n2++);
        preparedStatement.setString(3, "Walt Whitman");
        preparedStatement.setString(4, "Walt Whitman");
        preparedStatement.setString(5, "When lilacs last in the dooryard bloomd, And the great star early droopd in the western sky in the night, I mournd, and yet shall mourn with ever-returning spring.");
        preparedStatement.executeUpdate();
        preparedStatement.close();
    }

    public static class StandardIndexDescriptor
    extends LuceneUtils.DefaultIndexDescriptor {
        public Analyzer getAnalyzer() throws SQLException {
            return LuceneUtils.standardAnalyzer();
        }
    }

    public static class EnglishIndexDescriptor
    extends LuceneUtils.DefaultIndexDescriptor {
        public Analyzer getAnalyzer() throws SQLException {
            return LuceneUtils.getAnalyzerForLocale((Locale)Locale.US);
        }
    }
}

