/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.store;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.util.Formatters;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.RuntimeStatisticsParser;
import org.apache.derbyTesting.junit.SQLUtilities;
import org.apache.derbyTesting.junit.SystemPropertyTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class HoldCursorExternalSortJDBC30Test
extends BaseJDBCTestCase {
    public HoldCursorExternalSortJDBC30Test(String string) {
        super(string);
    }

    public static Test suite() {
        Properties properties = new Properties();
        properties.put("derby.storage.sortBufferMax", "5");
        properties.put("derby.debug.true", "testSort");
        Test test = TestConfiguration.embeddedSuite(HoldCursorExternalSortJDBC30Test.class);
        return new CleanDatabaseTestSetup((Test)new SystemPropertyTestSetup(test, properties, true)){

            @Override
            protected void decorateSQL(Statement statement) throws SQLException {
                Connection connection = statement.getConnection();
                connection.setAutoCommit(false);
                statement.executeUpdate("create table foo (a int, data varchar(2000))");
                statement.executeUpdate("create table bar (a int, data varchar(2000))");
                PreparedStatement preparedStatement = connection.prepareStatement("insert into foo values(?,?), (?,?), (?,?), (?,?), (?,?), (?,?), (?,?), (?,?), (?,?), (?,?)");
                for (int i = 0; i <= 9; ++i) {
                    preparedStatement.setInt(i * 2 + 1, i + 1);
                    preparedStatement.setString(i * 2 + 2, Formatters.padString("" + (i + 1), 2000));
                }
                preparedStatement.executeUpdate();
                preparedStatement.close();
                statement.execute("INSERT INTO bar SELECT * FROM foo");
            }
        };
    }

    public void testOrder_Hold() throws SQLException {
        this.setAutoCommit(false);
        Statement statement = this.createStatement();
        statement.executeUpdate("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.language.bulkFetchDefault', '1')");
        Statement statement2 = this.createStatement(1004, 1007, 1);
        statement2.execute("CALL SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)");
        ResultSet resultSet = statement2.executeQuery("select * from foo order by a");
        statement.executeUpdate("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.language.bulkFetchDefault', '16')");
        boolean[] blArray = new boolean[]{true, false, false, false, true, false, false, false, true, false};
        for (int i = 0; i < 10; ++i) {
            HoldCursorExternalSortJDBC30Test.assertTrue((boolean)resultSet.next());
            HoldCursorExternalSortJDBC30Test.assertEquals((int)(i + 1), (int)resultSet.getInt("a"));
            HoldCursorExternalSortJDBC30Test.assertEquals((String)Formatters.padString("" + (i + 1), 2000), (String)resultSet.getString("data"));
            if (!blArray[i]) continue;
            this.commit();
        }
        HoldCursorExternalSortJDBC30Test.assertFalse((boolean)resultSet.next());
        resultSet.close();
        this.commit();
        RuntimeStatisticsParser runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement2);
        HoldCursorExternalSortJDBC30Test.assertTrue((boolean)runtimeStatisticsParser.usedExternalSort());
        statement2.close();
        statement.close();
    }

    public void testOrder_NoHold() throws SQLException {
        this.setAutoCommit(false);
        Statement statement = this.createStatement();
        statement.execute("CALL SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)");
        statement.executeUpdate("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.language.bulkFetchDefault', '1')");
        Statement statement2 = this.createStatement(1004, 1007, 2);
        statement2.execute("CALL SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)");
        ResultSet resultSet = statement2.executeQuery("select * from foo order by a");
        statement.executeUpdate("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.language.bulkFetchDefault', '16')");
        for (int i = 0; i < 10; ++i) {
            HoldCursorExternalSortJDBC30Test.assertTrue((boolean)resultSet.next());
            HoldCursorExternalSortJDBC30Test.assertEquals((int)(i + 1), (int)resultSet.getInt("a"));
            HoldCursorExternalSortJDBC30Test.assertEquals((String)Formatters.padString("" + (i + 1), 2000), (String)resultSet.getString("data"));
        }
        HoldCursorExternalSortJDBC30Test.assertFalse((boolean)resultSet.next());
        resultSet.close();
        this.commit();
        RuntimeStatisticsParser runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement2);
        HoldCursorExternalSortJDBC30Test.assertTrue((boolean)runtimeStatisticsParser.usedExternalSort());
        statement2.close();
        statement.close();
    }

    public void testOrderWthMultipleLevel() throws SQLException {
        String string;
        int n;
        this.setAutoCommit(false);
        Statement statement = this.createStatement();
        statement.addBatch("insert into bar select a + 100, data from bar");
        statement.addBatch("insert into bar select a + 10,  data from bar");
        statement.addBatch("insert into bar select a + 200, data from bar");
        statement.addBatch("insert into bar select a + 200, data from bar");
        statement.executeBatch();
        statement.executeUpdate("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.language.bulkFetchDefault', '1')");
        Statement statement2 = this.createStatement(1004, 1007, 1);
        statement2.execute("CALL SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)");
        ResultSet resultSet = statement2.executeQuery("select * from bar order by a");
        statement.executeUpdate("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.language.bulkFetchDefault', '16')");
        boolean[] blArray = new boolean[]{true, false, false, false, true, false, false, false, true, false, true, false, false, false, true, false, false, false, true, false};
        for (n = 0; n < 20; ++n) {
            HoldCursorExternalSortJDBC30Test.assertTrue((boolean)resultSet.next());
            string = "" + ((n + 1) % 10 == 0 ? 10 : (n + 1) % 10);
            HoldCursorExternalSortJDBC30Test.assertEquals((int)(n + 1), (int)resultSet.getInt("a"));
            HoldCursorExternalSortJDBC30Test.assertEquals((String)Formatters.padString(string, 2000), (String)resultSet.getString("data"));
            if (!blArray[n % 20]) continue;
            this.commit();
        }
        for (n = 100; n < 120; ++n) {
            HoldCursorExternalSortJDBC30Test.assertTrue((boolean)resultSet.next());
            string = "" + ((n + 1) % 10 == 0 ? 10 : (n + 1) % 10);
            HoldCursorExternalSortJDBC30Test.assertEquals((int)(n + 1), (int)resultSet.getInt("a"));
            HoldCursorExternalSortJDBC30Test.assertEquals((String)Formatters.padString(string, 2000), (String)resultSet.getString("data"));
            if (!blArray[n % 20]) continue;
            this.commit();
        }
        HoldCursorExternalSortJDBC30Test.assertTrue((boolean)resultSet.next());
        HoldCursorExternalSortJDBC30Test.assertEquals((int)201, (int)resultSet.getInt("a"));
        HoldCursorExternalSortJDBC30Test.assertEquals((String)Formatters.padString("1", 2000), (String)resultSet.getString("data"));
        this.commit();
        resultSet.close();
        RuntimeStatisticsParser runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement2);
        HoldCursorExternalSortJDBC30Test.assertTrue((boolean)runtimeStatisticsParser.usedExternalSort());
        statement.close();
        statement2.close();
    }
}

