/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.derbynet;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Locale;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.LocaleTestSetup;
import org.apache.derbyTesting.junit.NetworkServerTestSetup;
import org.apache.derbyTesting.junit.SecurityManagerSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class RuntimeInfoTest
extends BaseJDBCTestCase {
    private static String[] RuntimeinfoCmd = new String[]{"-Demma.verbosity.level=silent", "org.apache.derby.drda.NetworkServerControl", "runtimeinfo", "-p", String.valueOf(TestConfiguration.getCurrent().getPort())};
    private static String[] RuntimeinfoLocaleCmd = new String[]{"-Demma.verbosity.level=silent", "-Duser.language=err", "-Duser.country=DE", "org.apache.derby.drda.NetworkServerControl", "runtimeinfo", "-p", String.valueOf(TestConfiguration.getCurrent().getPort())};
    private static final String POLICY_FILE_NAME = "org/apache/derbyTesting/functionTests/tests/derbynet/RuntimeInfoTest.policy";
    private static final Locale englishLocale = new Locale("en", "US");
    private static final Locale germanLocale = new Locale("de", "DE");
    private static final String stdout_err_tags = "<[^<>]*STD.*>";
    private static final HashMap<Locale, HashMap<String, String>> outputs;

    public RuntimeInfoTest(String name) {
        super(name);
    }

    public static Test suite() {
        BaseTestSuite suite = new BaseTestSuite("RuntimeInfoTest");
        suite.addTest(RuntimeInfoTest.decorateTest(englishLocale, "testRunTests"));
        suite.addTest(RuntimeInfoTest.decorateTest(germanLocale, "testRunTests"));
        suite.addTest(RuntimeInfoTest.decorateTest(englishLocale, "testRuntimeInfoWithLongValues"));
        return suite;
    }

    public void testRunTests() throws Exception {
        this.x_testRuntimeInfoWithActiveConn();
        this.x_testRuntimeInfoLocale();
        this.x_testRuntimeInfoAfterConnClose();
    }

    public void x_testRuntimeInfoWithActiveConn() throws Exception {
        Process p = RuntimeInfoTest.execJavaCmd(RuntimeinfoCmd);
        String output = this.sed(RuntimeInfoTest.readProcessOutput(p));
        this.printIfVerbose("testRuntimeInfo", output);
        String expectedOutput = outputs.get(Locale.getDefault()).get("RuntimeInfoWithActiveConn").toString();
        RuntimeInfoTest.assertEquals((String)"Output doesn't match", (String)expectedOutput, (String)output);
    }

    public void x_testRuntimeInfoLocale() throws Exception {
        Connection conn1 = this.getConnection();
        Connection conn2 = this.openDefaultConnection();
        PreparedStatement ps = RuntimeInfoTest.prepareAndExecuteQuery(conn1, "SELECT count(*) from sys.systables");
        PreparedStatement ps2 = RuntimeInfoTest.prepareAndExecuteQuery(conn1, "VALUES(1)");
        Connection conn3 = this.openDefaultConnection();
        PreparedStatement ps3 = RuntimeInfoTest.prepareAndExecuteQuery(conn2, "SELECT count(*) from sys.systables");
        PreparedStatement ps4 = RuntimeInfoTest.prepareAndExecuteQuery(conn2, "VALUES(2)");
        Process p = RuntimeInfoTest.execJavaCmd(RuntimeinfoLocaleCmd);
        String output = this.sed(RuntimeInfoTest.readProcessOutput(p));
        this.printIfVerbose("testRuntimeInfoLocale", output);
        int matched = 0;
        String matchString = "\tSYSLH0001\tSELECT count(*) from sys.systables\n\tSYSLH0002\tVALUES(1)\n";
        String invertedMatchString = "\tSYSLH0002\tVALUES(1)\n\tSYSLH0001\tSELECT count(*) from sys.systables\n";
        matched = output.indexOf(matchString);
        if (matched == -1) {
            matched = output.indexOf(invertedMatchString);
            RuntimeInfoTest.assertTrue((matched != -1 ? 1 : 0) != 0);
        }
        matched = 0;
        matchString = "\tSYSLH0001\tSELECT count(*) from sys.systables\n\tSYSLH0002\tVALUES(2)\n";
        invertedMatchString = "\tSYSLH0002\tVALUES(2)\n\tSYSLH0001\tSELECT count(*) from sys.systables\n";
        matched = output.indexOf(matchString);
        if (matched == -1) {
            matched = output.indexOf(invertedMatchString);
            RuntimeInfoTest.assertTrue((matched != -1 ? 1 : 0) != 0);
        }
        matched = 0;
        matchString = outputs.get(Locale.getDefault()).get("RuntimeInfoLocaleString").toString();
        RuntimeInfoTest.assertTrue((output.indexOf(matchString) != -1 ? 1 : 0) != 0);
        ps.close();
        ps2.close();
        ps3.close();
        ps4.close();
        conn1.close();
        conn2.close();
        conn3.close();
    }

    public void x_testRuntimeInfoAfterConnClose() throws Exception {
        String expectedOutput = outputs.get(Locale.getDefault()).get("RuntimeInfoAfterConnClose");
        String s = null;
        int retriesLeft = 60;
        while (!expectedOutput.equals(s = this.sed(NetworkServerTestSetup.getNetworkServerControl(TestConfiguration.getCurrent().getPort()).getRuntimeInfo())) && --retriesLeft > 0) {
            RuntimeInfoTest.sleep(1000L);
        }
        NetworkServerTestSetup.getNetworkServerControl().shutdown();
        this.printIfVerbose("testRuntimeInfoMethod", s);
        RuntimeInfoTest.assertEquals((String)"Output doesn't match", (String)expectedOutput, (String)s);
    }

    public void testRuntimeInfoWithLongValues() throws Exception {
        for (int i = 0; i < 200; ++i) {
            RuntimeInfoTest.prepareAndExecuteQuery(this.openDefaultConnection(), "VALUES 'Hello, World! How are you today?',\n'Not that bad today, actually. Thanks for asking.'\n-- Let's add some more text to increase the output length.\n-- And even more here... The statement text, including this\n-- comment, will be included in the runtimeinfo output.\n");
        }
        String runtimeinfo = NetworkServerTestSetup.getNetworkServerControl().getRuntimeInfo();
        RuntimeInfoTest.println(runtimeinfo);
        RuntimeInfoTest.assertEquals((int)65535, (int)runtimeinfo.length());
    }

    public static PreparedStatement prepareAndExecuteQuery(Connection conn, String sql) throws SQLException {
        PreparedStatement ps = conn.prepareStatement(sql);
        ResultSet rs = ps.executeQuery();
        rs.next();
        return ps;
    }

    private String sed(String s) {
        HashMap<String, String> strings = outputs.get(Locale.getDefault());
        s = s.replaceAll(strings.get("sedMemorySearch"), strings.get("sedMemoryReplace"));
        s = s.replaceAll(strings.get("sedSessionNumberSearch"), strings.get("sedSessionNumberReplace"));
        s = s.replaceAll(stdout_err_tags, "");
        s = s.trim();
        return s;
    }

    private void printIfVerbose(String name, String s) {
        RuntimeInfoTest.println("\n\n>>>" + name + ">>>");
        RuntimeInfoTest.println(s);
        RuntimeInfoTest.println("<<<" + name + "<<<\n\n");
    }

    private static Test decorateTest(Locale serverLocale, String testName) {
        Object test = new RuntimeInfoTest(testName);
        test = TestConfiguration.clientServerDecorator((Test)test);
        test = TestConfiguration.singleUseDatabaseDecorator((Test)test);
        test = new LocaleTestSetup((Test)test, serverLocale);
        return new SecurityManagerSetup((Test)test, POLICY_FILE_NAME);
    }

    static {
        HashMap<String, String> englishOutputs = new HashMap<String, String>();
        englishOutputs.put("RuntimeInfoWithActiveConn", "--- Derby Network Server Runtime Information ---\n---------- Session Information ---------------\nSession # :##\n\n\n-------------------------------------------------------------\n# Connection Threads : 1\n# Active Sessions : 1\n# Waiting  Sessions : 0\n\nTotal Memory : #####\tFree Memory : #####");
        englishOutputs.put("RuntimeInfoAfterConnClose", "--- Derby Network Server Runtime Information ---\n---------- Session Information ---------------\nSession # :##\n\n\n-------------------------------------------------------------\n# Connection Threads : 4\n# Active Sessions : 1\n# Waiting  Sessions : 0\n\nTotal Memory : #####\tFree Memory : #####");
        englishOutputs.put("sedMemorySearch", "(?m)Memory : [0-9]*");
        englishOutputs.put("sedMemoryReplace", "Memory : #####");
        englishOutputs.put("sedSessionNumberSearch", "(?m)^(Session # :)\\d+");
        englishOutputs.put("sedSessionNumberReplace", "$1##");
        englishOutputs.put("RuntimeInfoLocaleString", "\tStmt ID\t\tSQLText\n\t-------------\t-----------\n\n\n\nSession");
        HashMap<String, String> germanOutputs = new HashMap<String, String>();
        germanOutputs.put("RuntimeInfoWithActiveConn", "--- Laufzeitinformationen zu Derby Network Server ---\n---------- Sessioninformationen ---------------\nSessionnummer:##\n\n\n-------------------------------------------------------------\nAnzahl Verbindungsthreads: 1\nAnzahl aktive Sessions: 1\nAnzahl wartende Sessions: 0\n\nSpeicher gesamt: #####\tFreier Speicher: #####");
        germanOutputs.put("RuntimeInfoAfterConnClose", "--- Laufzeitinformationen zu Derby Network Server ---\n---------- Sessioninformationen ---------------\nSessionnummer:##\n\n\n-------------------------------------------------------------\nAnzahl Verbindungsthreads: 4\nAnzahl aktive Sessions: 1\nAnzahl wartende Sessions: 0\n\nSpeicher gesamt: #####\tFreier Speicher: #####");
        germanOutputs.put("sedMemorySearch", "Speicher gesamt: [0-9]*\tFreier Speicher: [0-9]*");
        germanOutputs.put("sedMemoryReplace", "Speicher gesamt: #####\tFreier Speicher: #####");
        germanOutputs.put("sedSessionNumberSearch", "(?m)^(Sessionnummer:)\\d+");
        germanOutputs.put("sedSessionNumberReplace", "$1##");
        germanOutputs.put("RuntimeInfoLocaleString", "\tAnwsg-ID\t\tSQL-Text\n\t-------------\t-----------\n\n\n\nSessionnummer");
        outputs = new HashMap();
        outputs.put(englishLocale, englishOutputs);
        outputs.put(germanLocale, germanOutputs);
    }
}

