/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.compile.Visitable;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.impl.sql.compile.QueryTreeNode;

class QueryTreeNodeVector<E extends QueryTreeNode>
extends QueryTreeNode
implements Iterable<E> {
    private final ArrayList<E> v = new ArrayList();
    final Class<E> eltClass;

    QueryTreeNodeVector(Class<E> eltClass, ContextManager cm) {
        super(cm);
        this.eltClass = eltClass;
    }

    public final int size() {
        return this.v.size();
    }

    final E elementAt(int index) {
        return (E)((QueryTreeNode)this.v.get(index));
    }

    void addElement(E qt) {
        this.v.add(qt);
    }

    final E removeElementAt(int index) {
        return (E)((QueryTreeNode)this.v.remove(index));
    }

    final void removeElement(E qt) {
        this.v.remove(qt);
    }

    final int indexOf(E qt) {
        return this.v.indexOf(qt);
    }

    final void setElementAt(E qt, int index) {
        this.v.set(index, qt);
    }

    final void destructiveAppend(QueryTreeNodeVector<E> qtnv) {
        this.nondestructiveAppend(qtnv);
        qtnv.removeAllElements();
    }

    final void nondestructiveAppend(QueryTreeNodeVector<E> qtnv) {
        this.v.addAll(qtnv.v);
    }

    final void removeAllElements() {
        this.v.clear();
    }

    final void insertElementAt(E qt, int index) {
        this.v.add(index, qt);
    }

    @Override
    void printSubNodes(int depth) {
        for (int index = 0; index < this.size(); ++index) {
            QueryTreeNodeVector.debugPrint(QueryTreeNodeVector.formatNodeString("[" + index + "]:", depth));
            E elt = this.elementAt(index);
            ((QueryTreeNode)elt).treePrint(depth);
        }
    }

    @Override
    void acceptChildren(Visitor v) throws StandardException {
        super.acceptChildren(v);
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            Visitable vbl = ((QueryTreeNode)this.elementAt(index)).accept(v);
            this.setElementAt((QueryTreeNode)this.eltClass.cast(vbl), index);
        }
    }

    @Override
    public final Iterator<E> iterator() {
        return this.v.iterator();
    }
}

