/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.memory.internal;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermissions;
import org.apache.datasketches.memory.internal.Util;
import org.testng.Assert;
import org.testng.annotations.Test;

public class UtilTest {
    static final String LS = System.getProperty("line.separator");

    static final String getFileAttributes(File file) throws IOException {
        PosixFileAttributes attrs = Files.getFileAttributeView(file.toPath(), PosixFileAttributeView.class, new LinkOption[0]).readAttributes();
        String s = String.format("%s: %s %s %s%n", file.getPath(), attrs.owner().getName(), attrs.group().getName(), PosixFilePermissions.toString(attrs.permissions()));
        return s;
    }

    static final File setGettysburgAddressFileToReadOnly() {
        File file = Util.getResourceFile((String)"GettysburgAddress.txt");
        if (!file.setWritable(false)) {
            throw new IllegalStateException("File could not set Read-Only");
        }
        return file;
    }

    @Test
    public void resourceFileExits() {
        String shortFileName = "GettysburgAddress.txt";
        File file = Util.getResourceFile((String)"GettysburgAddress.txt");
        Assert.assertTrue((boolean)file.exists());
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void resourceFileNotFound() {
        String shortFileName = "GettysburgAddress.txt";
        Util.getResourceFile((String)"GettysburgAddress.txt123");
    }

    @Test
    public void resourceStringLikelyCorrect() {
        String str;
        String shortFileName = "GettysburgAddress.txt";
        File file = Util.getResourceFile((String)"GettysburgAddress.txt");
        try {
            str = Files.readString(file.toPath());
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        Assert.assertTrue((boolean)str.startsWith("Abraham Lincoln's Gettysburg Address:"));
    }

    @Test
    public void printlnTest() {
        UtilTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(Object o) {
        if (o == null) {
            UtilTest.print(LS);
        } else {
            UtilTest.print(o.toString() + LS);
        }
    }

    static void print(Object o) {
        if (o != null) {
            // empty if block
        }
    }
}

