/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.theta;

import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.theta.CompactThetaSketch;
import org.apache.datasketches.theta.DirectCompactSketch;
import org.apache.datasketches.theta.HashIterator;
import org.apache.datasketches.theta.HeapCompactHashIterator;

final class EmptyCompactSketch
extends CompactThetaSketch {
    private static final long EMPTY_SKETCH_MASK = 258385249304575L;
    private static final long EMPTY_SKETCH_TEST = 10995116475137L;
    static final byte[] EMPTY_COMPACT_SKETCH_ARR = new byte[]{1, 3, 3, 0, 0, 30, 0, 0};
    private static final EmptyCompactSketch EMPTY_COMPACT_SKETCH = new EmptyCompactSketch();

    private EmptyCompactSketch() {
    }

    static synchronized EmptyCompactSketch getInstance() {
        return EMPTY_COMPACT_SKETCH;
    }

    static synchronized EmptyCompactSketch getHeapInstance(MemorySegment srcSeg) {
        long pre0 = srcSeg.get(ValueLayout.JAVA_LONG_UNALIGNED, 0L);
        if (EmptyCompactSketch.testCandidatePre0(pre0)) {
            return EMPTY_COMPACT_SKETCH;
        }
        long maskedPre0 = pre0 & 0xEB0000FFFFFFL;
        throw new SketchesArgumentException("Input MemorySegment does not match required Preamble. MemorySegment Pre0: " + Long.toHexString(maskedPre0) + ", required Pre0: " + Long.toHexString(10995116475137L));
    }

    @Override
    public CompactThetaSketch compact(boolean dstOrdered, MemorySegment dstWSeg) {
        if (dstWSeg == null) {
            return EmptyCompactSketch.getInstance();
        }
        MemorySegment.copy(EMPTY_COMPACT_SKETCH_ARR, 0, dstWSeg, ValueLayout.JAVA_BYTE, 0L, 8);
        return new DirectCompactSketch(dstWSeg);
    }

    static boolean testCandidatePre0(long candidate) {
        return (candidate & 0xEB0000FFFFFFL) == 10995116475137L;
    }

    @Override
    public int getCurrentBytes() {
        return 8;
    }

    @Override
    public double getEstimate() {
        return 0.0;
    }

    @Override
    public int getRetainedEntries(boolean valid) {
        return 0;
    }

    @Override
    public long getThetaLong() {
        return Long.MAX_VALUE;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public boolean isOrdered() {
        return true;
    }

    @Override
    public HashIterator iterator() {
        return new HeapCompactHashIterator(new long[0]);
    }

    @Override
    public byte[] toByteArray() {
        return EMPTY_COMPACT_SKETCH_ARR;
    }

    @Override
    long[] getCache() {
        return new long[0];
    }

    @Override
    int getCompactPreambleLongs() {
        return 1;
    }

    @Override
    int getCurrentPreambleLongs() {
        return 1;
    }

    @Override
    short getSeedHash() {
        return 0;
    }
}

