/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.tuple.adouble;

import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.common.SketchesStateException;
import org.apache.datasketches.theta.UpdateSketch;
import org.apache.datasketches.theta.UpdateSketchBuilder;
import org.apache.datasketches.tuple.CompactSketch;
import org.apache.datasketches.tuple.Intersection;
import org.apache.datasketches.tuple.Sketch;
import org.apache.datasketches.tuple.Sketches;
import org.apache.datasketches.tuple.Summary;
import org.apache.datasketches.tuple.SummaryFactory;
import org.apache.datasketches.tuple.SummarySetOperations;
import org.apache.datasketches.tuple.TupleSketchIterator;
import org.apache.datasketches.tuple.UpdatableSketch;
import org.apache.datasketches.tuple.UpdatableSketchBuilder;
import org.apache.datasketches.tuple.adouble.DoubleSummary;
import org.apache.datasketches.tuple.adouble.DoubleSummaryFactory;
import org.apache.datasketches.tuple.adouble.DoubleSummarySetOperations;
import org.testng.Assert;
import org.testng.annotations.Test;

public class AdoubleIntersectionTest {
    private final DoubleSummary.Mode mode = DoubleSummary.Mode.Sum;

    @Test
    public void intersectionNotEmptyNoEntries() {
        UpdatableSketch sketch1 = new UpdatableSketchBuilder((SummaryFactory)new DoubleSummaryFactory(this.mode)).setSamplingProbability(0.01f).build();
        sketch1.update("a", (Object)1.0);
        Intersection intersection = new Intersection((SummarySetOperations)new DoubleSummarySetOperations(this.mode, this.mode));
        intersection.intersect((Sketch)sketch1);
        CompactSketch result = intersection.getResult();
        Assert.assertEquals((int)result.getRetainedEntries(), (int)0);
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((double)result.getEstimate(), (double)0.0);
        Assert.assertEquals((double)result.getLowerBound(1), (double)0.0, (double)1.0E-4);
        Assert.assertTrue((result.getUpperBound(1) > 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void intersectionExactWithEmpty() {
        UpdatableSketch sketch1 = new UpdatableSketchBuilder((SummaryFactory)new DoubleSummaryFactory(this.mode)).build();
        sketch1.update(1L, (Object)1.0);
        sketch1.update(2L, (Object)1.0);
        sketch1.update(3L, (Object)1.0);
        Sketch sketch2 = Sketches.createEmptySketch();
        Intersection intersection = new Intersection((SummarySetOperations)new DoubleSummarySetOperations(this.mode, this.mode));
        intersection.intersect((Sketch)sketch1);
        intersection.intersect(sketch2);
        CompactSketch result = intersection.getResult();
        Assert.assertEquals((int)result.getRetainedEntries(), (int)0);
        Assert.assertTrue((boolean)result.isEmpty());
        Assert.assertEquals((double)result.getEstimate(), (double)0.0);
        Assert.assertEquals((double)result.getLowerBound(1), (double)0.0);
        Assert.assertEquals((double)result.getUpperBound(1), (double)0.0);
    }

    @Test
    public void intersectionExactMode() {
        UpdatableSketch sketch1 = new UpdatableSketchBuilder((SummaryFactory)new DoubleSummaryFactory(this.mode)).build();
        sketch1.update(1L, (Object)1.0);
        sketch1.update(1L, (Object)1.0);
        sketch1.update(2L, (Object)1.0);
        sketch1.update(2L, (Object)1.0);
        UpdatableSketch sketch2 = new UpdatableSketchBuilder((SummaryFactory)new DoubleSummaryFactory(this.mode)).build();
        sketch2.update(2L, (Object)1.0);
        sketch2.update(2L, (Object)1.0);
        sketch2.update(3L, (Object)1.0);
        sketch2.update(3L, (Object)1.0);
        Intersection intersection = new Intersection((SummarySetOperations)new DoubleSummarySetOperations(this.mode, this.mode));
        intersection.intersect((Sketch)sketch1);
        intersection.intersect((Sketch)sketch2);
        CompactSketch result = intersection.getResult();
        Assert.assertEquals((int)result.getRetainedEntries(), (int)1);
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((double)result.getEstimate(), (double)1.0);
        Assert.assertEquals((double)result.getLowerBound(1), (double)1.0);
        Assert.assertEquals((double)result.getUpperBound(1), (double)1.0);
        TupleSketchIterator it = result.iterator();
        Assert.assertTrue((boolean)it.next());
        Assert.assertTrue((it.getHash() > 0L ? 1 : 0) != 0);
        Assert.assertEquals((double)((DoubleSummary)it.getSummary()).getValue(), (double)4.0);
        Assert.assertFalse((boolean)it.next());
        intersection.reset();
        sketch1 = null;
        try {
            intersection.intersect((Sketch)sketch1);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void intersectionDisjointEstimationMode() {
        int key = 0;
        UpdatableSketch sketch1 = new UpdatableSketchBuilder((SummaryFactory)new DoubleSummaryFactory(this.mode)).build();
        for (int i = 0; i < 8192; ++i) {
            sketch1.update((long)key++, (Object)1.0);
        }
        UpdatableSketch sketch2 = new UpdatableSketchBuilder((SummaryFactory)new DoubleSummaryFactory(this.mode)).build();
        for (int i = 0; i < 8192; ++i) {
            sketch2.update((long)key++, (Object)1.0);
        }
        Intersection intersection = new Intersection((SummarySetOperations)new DoubleSummarySetOperations(this.mode, this.mode));
        intersection.intersect((Sketch)sketch1);
        intersection.intersect((Sketch)sketch2);
        CompactSketch result = intersection.getResult();
        Assert.assertEquals((int)result.getRetainedEntries(), (int)0);
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((double)result.getEstimate(), (double)0.0);
        Assert.assertEquals((double)result.getLowerBound(1), (double)0.0);
        Assert.assertTrue((result.getUpperBound(1) > 0.0 ? 1 : 0) != 0);
        intersection.intersect((Sketch)sketch1);
        result = intersection.getResult();
        Assert.assertEquals((int)result.getRetainedEntries(), (int)0);
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((double)result.getEstimate(), (double)0.0);
        Assert.assertEquals((double)result.getLowerBound(1), (double)0.0);
        Assert.assertTrue((result.getUpperBound(1) > 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void intersectionEstimationMode() {
        int key = 0;
        UpdatableSketch sketch1 = new UpdatableSketchBuilder((SummaryFactory)new DoubleSummaryFactory(this.mode)).build();
        for (int i = 0; i < 8192; ++i) {
            sketch1.update((long)key++, (Object)1.0);
        }
        key -= 4096;
        UpdatableSketch sketch2 = new UpdatableSketchBuilder((SummaryFactory)new DoubleSummaryFactory(this.mode)).build();
        for (int i = 0; i < 8192; ++i) {
            sketch2.update((long)key++, (Object)1.0);
        }
        Intersection intersection = new Intersection((SummarySetOperations)new DoubleSummarySetOperations(this.mode, this.mode));
        intersection.intersect((Sketch)sketch1);
        intersection.intersect((Sketch)sketch2);
        CompactSketch result = intersection.getResult();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((double)result.getEstimate(), (double)4096.0, (double)122.88);
        Assert.assertTrue((result.getLowerBound(1) <= result.getEstimate() ? 1 : 0) != 0);
        Assert.assertTrue((result.getUpperBound(1) > result.getEstimate() ? 1 : 0) != 0);
        TupleSketchIterator it = result.iterator();
        while (it.next()) {
            Assert.assertEquals((double)((DoubleSummary)it.getSummary()).getValue(), (double)2.0);
        }
    }

    @Test
    public void checkExactIntersectionWithTheta() {
        int i;
        org.apache.datasketches.theta.Sketch thSkNull = null;
        UpdateSketch thSkEmpty = new UpdateSketchBuilder().build();
        UpdateSketch thSk10 = new UpdateSketchBuilder().build();
        UpdateSketch thSk15 = new UpdateSketchBuilder().build();
        for (i = 0; i < 10; ++i) {
            thSk10.update((long)i);
        }
        for (i = 0; i < 10; ++i) {
            thSk15.update((long)(i + 5));
        }
        DoubleSummary dsum = new DoubleSummaryFactory(this.mode).newSummary();
        Intersection intersection = new Intersection((SummarySetOperations)new DoubleSummarySetOperations(this.mode, this.mode));
        try {
            intersection.getResult();
            Assert.fail();
        }
        catch (SketchesStateException sketchesStateException) {
            // empty catch block
        }
        try {
            intersection.intersect(thSkNull, (Summary)dsum);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        intersection.intersect((org.apache.datasketches.theta.Sketch)thSkEmpty, (Summary)dsum);
        CompactSketch result = intersection.getResult();
        Assert.assertTrue((boolean)result.isEmpty());
        intersection.reset();
        intersection.intersect((org.apache.datasketches.theta.Sketch)thSk10, (Summary)dsum);
        result = intersection.getResult();
        Assert.assertEquals((double)result.getEstimate(), (double)10.0);
        intersection.reset();
        intersection.intersect((org.apache.datasketches.theta.Sketch)thSk10, (Summary)dsum);
        intersection.intersect((org.apache.datasketches.theta.Sketch)thSkEmpty, (Summary)dsum);
        result = intersection.getResult();
        Assert.assertTrue((boolean)result.isEmpty());
        intersection.reset();
        intersection.intersect((org.apache.datasketches.theta.Sketch)thSk10, (Summary)dsum);
        intersection.intersect((org.apache.datasketches.theta.Sketch)thSk15, (Summary)dsum);
        result = intersection.getResult();
        Assert.assertEquals((double)result.getEstimate(), (double)5.0);
        intersection.reset();
        dsum = null;
        try {
            intersection.intersect((org.apache.datasketches.theta.Sketch)thSk10, (Summary)dsum);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void checkExactIntersectionWithThetaDisjoint() {
        int i;
        UpdateSketch thSkA = new UpdateSketchBuilder().setLogNominalEntries(10).build();
        UpdateSketch thSkB = new UpdateSketchBuilder().setLogNominalEntries(10).build();
        int key = 0;
        for (i = 0; i < 32; ++i) {
            thSkA.update((long)key++);
        }
        for (i = 0; i < 32; ++i) {
            thSkB.update((long)key++);
        }
        DoubleSummary dsum = new DoubleSummaryFactory(this.mode).newSummary();
        Intersection intersection = new Intersection((SummarySetOperations)new DoubleSummarySetOperations(this.mode, this.mode));
        intersection.intersect((org.apache.datasketches.theta.Sketch)thSkA, (Summary)dsum);
        intersection.intersect((org.apache.datasketches.theta.Sketch)thSkB, (Summary)dsum);
        CompactSketch result = intersection.getResult();
        Assert.assertEquals((int)result.getRetainedEntries(), (int)0);
        intersection.intersect((org.apache.datasketches.theta.Sketch)thSkA, (Summary)dsum);
        result = intersection.getResult();
        Assert.assertEquals((int)result.getRetainedEntries(), (int)0);
        intersection.reset();
    }

    @Test
    public void checkEstimatingIntersectionWithThetaOverlapping() {
        int i;
        UpdateSketch thSkA = new UpdateSketchBuilder().setLogNominalEntries(4).build();
        UpdateSketch thSkB = new UpdateSketchBuilder().setLogNominalEntries(10).build();
        for (i = 0; i < 64; ++i) {
            thSkA.update((long)i);
        }
        for (i = 32; i < 96; ++i) {
            thSkB.update((long)i);
        }
        DoubleSummary dsum = new DoubleSummaryFactory(this.mode).newSummary();
        Intersection intersection = new Intersection((SummarySetOperations)new DoubleSummarySetOperations(this.mode, this.mode));
        intersection.intersect((org.apache.datasketches.theta.Sketch)thSkA, (Summary)dsum);
        intersection.intersect((org.apache.datasketches.theta.Sketch)thSkB, (Summary)dsum);
        CompactSketch result = intersection.getResult();
        Assert.assertEquals((int)result.getRetainedEntries(), (int)14);
        thSkB.reset();
        for (int i2 = 100; i2 < 164; ++i2) {
            thSkB.update((long)i2);
        }
        intersection.intersect((org.apache.datasketches.theta.Sketch)thSkB, (Summary)dsum);
        result = intersection.getResult();
        Assert.assertEquals((int)result.getRetainedEntries(), (int)0);
        intersection.intersect((org.apache.datasketches.theta.Sketch)thSkB, (Summary)dsum);
        result = intersection.getResult();
        Assert.assertEquals((int)result.getRetainedEntries(), (int)0);
    }

    @Test
    public void intersectionEmpty() {
        UpdatableSketch sketch = new UpdatableSketchBuilder((SummaryFactory)new DoubleSummaryFactory(this.mode)).build();
        Intersection intersection = new Intersection((SummarySetOperations)new DoubleSummarySetOperations(this.mode, this.mode));
        intersection.intersect((Sketch)sketch);
        CompactSketch result = intersection.getResult();
        Assert.assertEquals((int)result.getRetainedEntries(), (int)0);
        Assert.assertTrue((boolean)result.isEmpty());
        Assert.assertEquals((double)result.getEstimate(), (double)0.0);
        Assert.assertEquals((double)result.getLowerBound(1), (double)0.0);
        Assert.assertEquals((double)result.getUpperBound(1), (double)0.0);
    }
}

