/*
 * Decompiled with CFR 0.152.
 */
package os;

import java.io.Serializable;
import os.BasePath$;
import os.PathChunk$;
import os.RelPath;
import os.RelPath$;
import os.SubPath;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxesRunTime;

public interface PathChunk {
    public static <T> ArrayPathChunk<T> ArrayPathChunk(Object object, Function1<T, PathChunk> function1) {
        return PathChunk$.MODULE$.ArrayPathChunk(object, function1);
    }

    public static RelPathChunk RelPathChunk(RelPath relPath) {
        return PathChunk$.MODULE$.RelPathChunk(relPath);
    }

    public static <T> SeqPathChunk<T> SeqPathChunk(Seq<T> seq, Function1<T, PathChunk> function1) {
        return PathChunk$.MODULE$.SeqPathChunk(seq, function1);
    }

    public static StringPathChunk StringPathChunk(String string) {
        return PathChunk$.MODULE$.StringPathChunk(string);
    }

    public static StringPathChunkInternal StringPathChunkInternal(String string) {
        return PathChunk$.MODULE$.StringPathChunkInternal(string);
    }

    public static SubPathChunk SubPathChunk(SubPath subPath) {
        return PathChunk$.MODULE$.SubPathChunk(subPath);
    }

    public static SymbolPathChunk SymbolPathChunk(Symbol symbol) {
        return PathChunk$.MODULE$.SymbolPathChunk(symbol);
    }

    public static String[] segmentsFromString(String string) {
        return PathChunk$.MODULE$.segmentsFromString(string);
    }

    public static String[] segmentsFromStringLiteralValidation(String string) {
        return PathChunk$.MODULE$.segmentsFromStringLiteralValidation(string);
    }

    public static PathChunk stringToPathChunk(String string) {
        return PathChunk$.MODULE$.stringToPathChunk(string);
    }

    public Seq<String> segments();

    public int ups();

    public static class ArrayPathChunk<T>
    implements PathChunk {
        private final SeqPathChunk inner;

        public ArrayPathChunk(Object a, Function1<T, PathChunk> f) {
            Object object = Predef$.MODULE$.genericArrayOps(a);
            this.inner = PathChunk$.MODULE$.SeqPathChunk(ArrayOps$.MODULE$.toIndexedSeq$extension(object), f);
        }

        public SeqPathChunk<T> inner() {
            return this.inner;
        }

        @Override
        public Seq<String> segments() {
            return this.inner().segments();
        }

        @Override
        public int ups() {
            return this.inner().ups();
        }

        public String toString() {
            return this.inner().toString();
        }
    }

    public static class RelPathChunk
    implements PathChunk {
        private final RelPath r;

        public RelPathChunk(RelPath r) {
            this.r = r;
        }

        @Override
        public Seq<String> segments() {
            return this.r.segments();
        }

        @Override
        public int ups() {
            return this.r.ups();
        }

        public String toString() {
            return this.r.toString();
        }
    }

    public static class SeqPathChunk<T>
    implements PathChunk {
        private Nil$ segments0 = package$.MODULE$.Nil();
        private int ups0 = 0;
        private final Seq segments;
        private final int ups;

        public SeqPathChunk(Seq<T> a, Function1<T, PathChunk> f) {
            RelPath rel = (RelPath)((IterableOnceOps)a.map(f)).foldLeft((Object)RelPath$.MODULE$.rel(), (Function2 & Serializable)(x$1, x$2) -> {
                Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
                if (tuple2 != null) {
                    RelPath current = (RelPath)tuple2._1();
                    PathChunk chunk = (PathChunk)tuple2._2();
                    return (RelPath)current.$div(chunk);
                }
                throw new MatchError((Object)tuple2);
            });
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(rel.segments(), (Object)BoxesRunTime.boxToInteger((int)rel.ups()));
            this.segments = (Seq)tuple2._1();
            this.ups = BoxesRunTime.unboxToInt((Object)tuple2._2());
        }

        public Nil$ segments0() {
            return this.segments0;
        }

        public void segments0_$eq(Nil$ x$1) {
            this.segments0 = x$1;
        }

        public int ups0() {
            return this.ups0;
        }

        public void ups0_$eq(int x$1) {
            this.ups0 = x$1;
        }

        @Override
        public Seq<String> segments() {
            return this.segments;
        }

        @Override
        public int ups() {
            return this.ups;
        }

        public String toString() {
            return this.segments().mkString("/");
        }
    }

    public static class StringPathChunk
    extends StringPathChunkInternal {
        public StringPathChunk(String s) {
            super(s);
        }
    }

    public static class StringPathChunkInternal
    implements PathChunk {
        private final String s;

        public StringPathChunkInternal(String s) {
            this.s = s;
            BasePath$.MODULE$.checkSegment(s);
        }

        @Override
        public Seq<String> segments() {
            return (Seq)((SeqOps)new .colon.colon((Object)this.s, (List)Nil$.MODULE$));
        }

        @Override
        public int ups() {
            return 0;
        }

        public String toString() {
            return this.s;
        }
    }

    public static class SubPathChunk
    implements PathChunk {
        private final SubPath r;

        public SubPathChunk(SubPath r) {
            this.r = r;
        }

        @Override
        public Seq<String> segments() {
            return this.r.segments();
        }

        @Override
        public int ups() {
            return 0;
        }

        public String toString() {
            return this.r.toString();
        }
    }

    public static class SymbolPathChunk
    implements PathChunk {
        private final Symbol s;

        public SymbolPathChunk(Symbol s) {
            this.s = s;
            BasePath$.MODULE$.checkSegment(s.name());
        }

        @Override
        public Seq<String> segments() {
            return (Seq)((SeqOps)new .colon.colon((Object)this.s.name(), (List)Nil$.MODULE$));
        }

        @Override
        public int ups() {
            return 0;
        }

        public String toString() {
            return this.s.name();
        }
    }
}

