/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl.wireformat;

import java.util.Objects;
import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.protocol.core.CoreRemotingConnection;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.QueueAbstractPacket;

public class SessionCreateConsumerMessage
extends QueueAbstractPacket {
    private long id;
    private SimpleString filterString;
    private int priority;
    private boolean browseOnly;
    private boolean requiresResponse;

    public SessionCreateConsumerMessage(long id, SimpleString queueName, SimpleString filterString, int priority, boolean browseOnly, boolean requiresResponse) {
        super((byte)40);
        this.id = id;
        this.queueName = queueName;
        this.filterString = filterString;
        this.priority = priority;
        this.browseOnly = browseOnly;
        this.requiresResponse = requiresResponse;
    }

    public SessionCreateConsumerMessage() {
        super((byte)40);
    }

    @Override
    protected String getPacketString() {
        StringBuilder sb = new StringBuilder(super.getPacketString());
        sb.append(", queueName=" + String.valueOf(this.queueName));
        sb.append(", filterString=" + String.valueOf(this.filterString));
        sb.append(", id=" + this.id);
        sb.append(", browseOnly=" + this.browseOnly);
        sb.append(", requiresResponse=" + this.requiresResponse);
        sb.append(", priority=" + this.priority);
        return sb.toString();
    }

    public long getID() {
        return this.id;
    }

    public SimpleString getFilterString() {
        return this.filterString;
    }

    public int getPriority() {
        return this.priority;
    }

    public boolean isBrowseOnly() {
        return this.browseOnly;
    }

    @Override
    public boolean isRequiresResponse() {
        return this.requiresResponse;
    }

    public void setQueueName(SimpleString queueName) {
        this.queueName = queueName;
    }

    public void setFilterString(SimpleString filterString) {
        this.filterString = filterString;
    }

    public void setPriority(byte priority) {
        this.priority = priority;
    }

    public void setBrowseOnly(boolean browseOnly) {
        this.browseOnly = browseOnly;
    }

    @Override
    public void encodeRest(ActiveMQBuffer buffer, CoreRemotingConnection coreRemotingConnection) {
        buffer.writeLong(this.id);
        buffer.writeSimpleString(this.queueName);
        buffer.writeNullableSimpleString(this.filterString);
        buffer.writeBoolean(this.browseOnly);
        buffer.writeBoolean(this.requiresResponse);
        if (coreRemotingConnection.isVersionSupportConsumerPriority()) {
            buffer.writeInt(this.priority);
        }
    }

    @Override
    public void decodeRest(ActiveMQBuffer buffer) {
        this.id = buffer.readLong();
        this.queueName = buffer.readSimpleString();
        this.filterString = buffer.readNullableSimpleString();
        this.browseOnly = buffer.readBoolean();
        this.requiresResponse = buffer.readBoolean();
        this.priority = buffer.readableBytes() > 0 ? buffer.readInt() : ActiveMQDefaultConfiguration.getDefaultConsumerPriority();
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.browseOnly, this.filterString, this.id, this.priority, this.queueName, this.requiresResponse);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof SessionCreateConsumerMessage)) {
            return false;
        }
        SessionCreateConsumerMessage other = (SessionCreateConsumerMessage)obj;
        return this.browseOnly == other.browseOnly && Objects.equals(this.filterString, other.filterString) && this.priority == other.priority && this.id == other.id && Objects.equals(this.queueName, other.queueName) && this.requiresResponse == other.requiresResponse;
    }
}

