/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.cluster.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;

public class BridgeMetrics {
    public static final String MESSAGES_PENDING_ACKNOWLEDGEMENT_KEY = "messagesPendingAcknowledgement";
    public static final String MESSAGES_ACKNOWLEDGED_KEY = "messagesAcknowledged";
    private static final AtomicLongFieldUpdater<BridgeMetrics> MESSAGES_PENDING_ACKNOWLEDGEMENT_UPDATER = AtomicLongFieldUpdater.newUpdater(BridgeMetrics.class, "messagesPendingAcknowledgement");
    private static final AtomicLongFieldUpdater<BridgeMetrics> MESSAGES_ACKNOWLEDGED_UPDATER = AtomicLongFieldUpdater.newUpdater(BridgeMetrics.class, "messagesAcknowledged");
    private volatile long messagesPendingAcknowledgement;
    private volatile long messagesAcknowledged;

    public void incrementMessagesPendingAcknowledgement() {
        MESSAGES_PENDING_ACKNOWLEDGEMENT_UPDATER.incrementAndGet(this);
    }

    public void incrementMessagesAcknowledged() {
        MESSAGES_ACKNOWLEDGED_UPDATER.incrementAndGet(this);
    }

    public long getMessagesPendingAcknowledgement() {
        return this.messagesPendingAcknowledgement;
    }

    public long getMessagesAcknowledged() {
        return this.messagesAcknowledged;
    }

    public Map<String, Object> convertToMap() {
        HashMap<String, Object> metrics = new HashMap<String, Object>();
        metrics.put(MESSAGES_PENDING_ACKNOWLEDGEMENT_KEY, this.messagesPendingAcknowledgement);
        metrics.put(MESSAGES_ACKNOWLEDGED_KEY, this.messagesAcknowledged);
        return metrics;
    }
}

