/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aot.hint;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.springframework.aot.hint.ResourcePatternHint;
import org.springframework.aot.hint.TypeReference;
import org.springframework.lang.Nullable;

public final class ResourcePatternHints {
    private final List<ResourcePatternHint> includes;
    private final List<ResourcePatternHint> excludes;

    private ResourcePatternHints(Builder builder) {
        this.includes = new ArrayList<ResourcePatternHint>(builder.includes);
        this.excludes = new ArrayList<ResourcePatternHint>(builder.excludes);
    }

    public List<ResourcePatternHint> getIncludes() {
        return this.includes;
    }

    public List<ResourcePatternHint> getExcludes() {
        return this.excludes;
    }

    public static class Builder {
        private final Set<ResourcePatternHint> includes = new LinkedHashSet<ResourcePatternHint>();
        private final Set<ResourcePatternHint> excludes = new LinkedHashSet<ResourcePatternHint>();

        Builder() {
        }

        public Builder includes(@Nullable TypeReference reachableType, String ... includes) {
            Arrays.stream(includes).map(this::expandToIncludeDirectories).flatMap(Collection::stream).map(include -> new ResourcePatternHint((String)include, reachableType)).forEach(this.includes::add);
            return this;
        }

        private List<String> expandToIncludeDirectories(String includePattern) {
            if (!includePattern.contains("/")) {
                return List.of("/", includePattern);
            }
            ArrayList<String> includePatterns = new ArrayList<String>();
            includePatterns.add("/");
            includePatterns.add(includePattern);
            StringBuilder path = new StringBuilder();
            for (String pathElement : includePattern.split("/")) {
                if (pathElement.isEmpty()) continue;
                if (pathElement.contains("*")) break;
                if (!path.isEmpty()) {
                    path.append("/");
                }
                path.append(pathElement);
                includePatterns.add(path.toString());
            }
            return includePatterns;
        }

        public Builder includes(String ... includes) {
            return this.includes((TypeReference)null, includes);
        }

        public Builder excludes(TypeReference reachableType, String ... excludes) {
            List<ResourcePatternHint> newExcludes = Arrays.stream(excludes).map(include -> new ResourcePatternHint((String)include, reachableType)).toList();
            this.excludes.addAll(newExcludes);
            return this;
        }

        public Builder excludes(String ... excludes) {
            return this.excludes((TypeReference)null, excludes);
        }

        ResourcePatternHints build() {
            return new ResourcePatternHints(this);
        }
    }
}

