/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.auxiliary.disk.block;

import java.io.File;
import java.io.IOException;
import java.util.Random;
import junit.framework.TestCase;
import org.apache.commons.jcs3.auxiliary.disk.block.BlockDisk;
import org.apache.commons.jcs3.engine.behavior.IElementSerializer;
import org.apache.commons.jcs3.utils.serialization.StandardSerializer;

public class BlockDiskUnitTest
extends TestCase {
    private File rafDir;
    private BlockDisk disk;

    protected void setUp() throws Exception {
        super.setUp();
        String rootDirName = "target/test-sandbox/block";
        this.rafDir = new File("target/test-sandbox/block");
        this.rafDir.mkdirs();
    }

    private void setUpBlockDisk(String fileName) throws IOException {
        File file = new File(this.rafDir, fileName + ".data");
        file.delete();
        this.disk = new BlockDisk(file, (IElementSerializer)new StandardSerializer());
    }

    private void setUpBlockDisk(String fileName, int blockSize) throws IOException {
        File file = new File(this.rafDir, fileName + ".data");
        file.delete();
        this.disk = new BlockDisk(file, blockSize, (IElementSerializer)new StandardSerializer());
    }

    protected void tearDown() throws Exception {
        this.disk.close();
        super.tearDown();
    }

    public void testWrite_NullBlockElement() throws Exception {
        this.setUpBlockDisk("testWrite_NullBlockElement");
        int[] blocks = this.disk.write(null);
        BlockDiskUnitTest.assertEquals((String)"Wrong number of blocks recorded.", (int)1, (int)this.disk.getNumberOfBlocks());
        BlockDiskUnitTest.assertEquals((String)"Wrong number of blocks returned.", (int)1, (int)blocks.length);
        BlockDiskUnitTest.assertEquals((String)"Wrong block returned.", (int)0, (int)blocks[0]);
    }

    public void testWrite_SingleBlockElement() throws Exception {
        this.setUpBlockDisk("testWrite_SingleBlockElement");
        int bytes = 1024;
        int[] blocks = this.disk.write((Object)new byte[1024]);
        BlockDiskUnitTest.assertEquals((String)"Wrong number of blocks recorded.", (int)1, (int)this.disk.getNumberOfBlocks());
        BlockDiskUnitTest.assertEquals((String)"Wrong number of blocks returned.", (int)1, (int)blocks.length);
        BlockDiskUnitTest.assertEquals((String)"Wrong block returned.", (int)0, (int)blocks[0]);
    }

    public void testWriteAndRead_SingleBlockElement() throws Exception {
        this.setUpBlockDisk("testWriteAndRead_SingleBlockElement");
        int bytes = 1024;
        int[] blocks = this.disk.write((Object)new byte[1024]);
        byte[] result = (byte[])this.disk.read(blocks);
        BlockDiskUnitTest.assertEquals((String)"Wrong item retured.", (int)new byte[1024].length, (int)result.length);
    }

    public void testWrite_TwoSingleBlockElements() throws Exception {
        this.setUpBlockDisk("testWrite_TwoSingleBlockElements");
        int bytes = 1024;
        int[] blocks1 = this.disk.write((Object)new byte[1024]);
        int[] blocks2 = this.disk.write((Object)new byte[1024]);
        BlockDiskUnitTest.assertEquals((String)"Wrong number of blocks recorded.", (int)2, (int)this.disk.getNumberOfBlocks());
        BlockDiskUnitTest.assertEquals((String)"Wrong number of blocks returned.", (int)1, (int)blocks1.length);
        BlockDiskUnitTest.assertEquals((String)"Wrong block returned.", (int)0, (int)blocks1[0]);
        BlockDiskUnitTest.assertEquals((String)"Wrong number of blocks returned.", (int)1, (int)blocks2.length);
        BlockDiskUnitTest.assertEquals((String)"Wrong block returned.", (int)1, (int)blocks2[0]);
    }

    public void testCalculateBlocksNeededDouble() throws Exception {
        this.setUpBlockDisk("testCalculateBlocksNeededDouble");
        int result = this.disk.calculateTheNumberOfBlocksNeeded(new byte[this.disk.getBlockSizeBytes() * 2 - 8]);
        BlockDiskUnitTest.assertEquals((String)"Wrong number of blocks", (int)2, (int)result);
    }

    public void testWrite_DoubleBlockElement() throws Exception {
        this.setUpBlockDisk("testWriteDoubleBlockElement");
        int bytes = this.getBytesForBlocksOfByteArrays(this.disk.getBlockSizeBytes(), 2);
        int[] blocks = this.disk.write((Object)new byte[bytes]);
        BlockDiskUnitTest.assertEquals((String)"Wrong number of blocks recorded.", (int)2, (int)this.disk.getNumberOfBlocks());
        BlockDiskUnitTest.assertEquals((String)"Wrong number of blocks returned.", (int)2, (int)blocks.length);
        BlockDiskUnitTest.assertEquals((String)"Wrong block returned.", (int)0, (int)blocks[0]);
    }

    public void testWrite_128BlockElement() throws Exception {
        int numBlocks = 128;
        this.setUpBlockDisk("testWrite_128BlockElement");
        int bytes = this.getBytesForBlocksOfByteArrays(this.disk.getBlockSizeBytes(), 128);
        int[] blocks = this.disk.write((Object)new byte[bytes]);
        BlockDiskUnitTest.assertEquals((String)"Wrong number of blocks recorded.", (int)128, (int)this.disk.getNumberOfBlocks());
        BlockDiskUnitTest.assertEquals((String)"Wrong number of blocks returned.", (int)128, (int)blocks.length);
        BlockDiskUnitTest.assertEquals((String)"Wrong block returned.", (int)0, (int)blocks[0]);
    }

    public void testWriteAndReadMultipleMultiBlockElement() throws Exception {
        this.setUpBlockDisk("testWriteAndReadSingleBlockElement");
        int numBlocksPerElement = 4;
        int bytes = this.getBytesForBlocksOfByteArrays(this.disk.getBlockSizeBytes(), 4);
        int numElements = 100;
        for (int i = 0; i < 100; ++i) {
            int[] blocks = this.disk.write((Object)new byte[bytes]);
            byte[] result = (byte[])this.disk.read(blocks);
            BlockDiskUnitTest.assertEquals((String)"Wrong item retured.", (int)new byte[bytes].length, (int)result.length);
            BlockDiskUnitTest.assertEquals((String)"Wrong number of blocks returned.", (int)4, (int)blocks.length);
        }
    }

    public void testWriteAndReadMultipleMultiBlockElement_setSize() throws Exception {
        this.setUpBlockDisk("testWriteAndReadSingleBlockElement", 1024);
        int numBlocksPerElement = 4;
        int bytes = this.getBytesForBlocksOfByteArrays(this.disk.getBlockSizeBytes(), 4);
        int numElements = 100;
        Random r = new Random(System.currentTimeMillis());
        byte[] src = new byte[bytes];
        for (int i = 0; i < 100; ++i) {
            r.nextBytes(src);
            int[] blocks = this.disk.write((Object)src);
            byte[] result = (byte[])this.disk.read(blocks);
            BlockDiskUnitTest.assertEquals((String)"Wrong item length retured.", (int)src.length, (int)result.length);
            BlockDiskUnitTest.assertEquals((String)"Wrong number of blocks returned.", (int)4, (int)blocks.length);
            for (int j = 0; j < src.length; ++j) {
                BlockDiskUnitTest.assertEquals((String)("Mismatch at offset " + j + " in attempt # " + (i + 1)), (byte)src[j], (byte)result[j]);
            }
        }
        BlockDiskUnitTest.assertEquals((String)("Wrong number of elements. " + this.disk), (int)400, (int)this.disk.getNumberOfBlocks());
    }

    private int getBytesForBlocksOfByteArrays(int blockSize, int numBlocks) {
        return blockSize * numBlocks - numBlocks * 4 - numBlocks * 14;
    }

    public void testWriteAndRead_BigString() throws Exception {
        this.setUpBlockDisk("testWriteAndRead_BigString", 4096);
        String string = "This is my big string ABCDEFGH";
        StringBuilder sb = new StringBuilder();
        sb.append(string);
        for (int i = 0; i < 8; ++i) {
            sb.append(" " + i + sb.toString());
        }
        string = sb.toString();
        int[] blocks = this.disk.write((Object)string);
        String result = (String)this.disk.read(blocks);
        BlockDiskUnitTest.assertEquals((String)"Wrong item retured.", (String)string, (String)result);
    }

    public void testWriteAndRead_BigString2() throws Exception {
        this.setUpBlockDisk("testWriteAndRead_BigString", 47);
        String string = "abcdefghijklmnopqrstuvwxyz1234567890";
        string = string + string;
        string = string + string;
        int[] blocks = this.disk.write((Object)string);
        String result = (String)this.disk.read(blocks);
        BlockDiskUnitTest.assertEquals((String)"Wrong item retured.", (String)string, (String)result);
    }

    public void testJCS156() throws Exception {
        this.setUpBlockDisk("testJCS156", 4096);
        long offset = this.disk.calculateByteOffsetForBlockAsLong(Integer.MAX_VALUE);
        BlockDiskUnitTest.assertTrue((String)"Must not wrap round", (offset > 0L ? 1 : 0) != 0);
        BlockDiskUnitTest.assertEquals((long)0x7FFFFFFF000L, (long)offset);
    }
}

